/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.policy.identifier;

import java.util.regex.Pattern;

/**
 * The Class DecisionId.
 *
 * @author Fraunhofer IESE
 */
public class DecisionId {

  /**
   * The Constant serialVersionUID.
   */
  private static final long serialVersionUID = -757909380475601881L;

  /**
   * The Constant URN_DECISION_PATTERN.
   */
  public static final Pattern URN_DECISION_PATTERN = Pattern.compile("^urn:decision(:[a-z0-9()+,\\-.=@;$_!*']+)$", Pattern.CASE_INSENSITIVE);

  /**
   * The identifier.
   */
  private final String identifier;

  /**
   * Instantiates a new decision id.
   *
   * @param id the id
   */
  public DecisionId(String id) {
    this.validate(id);
    this.identifier = id;
  }

  /*
   * (non-Javadoc)
   * @see java.lang.Object#equals(java.lang.Object)
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DecisionId)) {
      return false;
    }

    final DecisionId that = (DecisionId)o;

    return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;

  }

  /**
   * Gets the id.
   *
   * @return the id
   */
  public String getId() {
    return this.toString();
  }

  /*
   * (non-Javadoc)
   * @see java.lang.Object#hashCode()
   */
  @Override
  public int hashCode() {
    return this.identifier != null ? this.identifier.hashCode() : 0;
  }

  /*
   * (non-Javadoc)
   * @see java.lang.Object#toString()
   */
  @Override
  public String toString() {
    return this.identifier;
  }

  /**
   * Validate.
   *
   * @param uri the uri
   */
  protected void validate(String uri) {
    URN_DECISION_PATTERN.matcher(uri).matches();
  }
}
