/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.policy;

/**
 * The Class TimerValidator.
 */
public class TimerValidator implements ITimerValidator {

  private static final ITimerValidator TIMER_VALIDATOR_46 = new TimerValidator46();

  @Override
  public boolean validateXMLSchema(String timer) throws InvalidTimerException {
    if (timer == null) {
      throw new InvalidTimerException("Timer must not be null");
    }

    if (timer.contains("http://www.iese.fraunhofer.de/ind2uce/3.2.46/ind2uceLanguageTimer")) {
      return TIMER_VALIDATOR_46.validateXMLSchema(timer);
    }
    throw new InvalidTimerException("Unsupported timer version");
  }

  @Override
  public boolean checkTimerSolution(Timer timer) throws InvalidTimerException {
    if (timer == null) {
      throw new InvalidTimerException("Timer must not be null");
    }

    if (timer.getXml().contains("http://www.iese.fraunhofer.de/ind2uce/3.2.46/ind2uceLanguageTimer")) {
      return TIMER_VALIDATOR_46.checkTimerSolution(timer);
    }
    throw new InvalidTimerException("Unsupported timer version");
  }
}
