/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.policy;

/**
 * The Class PolicyValidator.
 */
public class PolicyValidator implements IPolicyValidator {

  private static final IPolicyValidator POLICY_VALIDATOR_25 = new PolicyValidator25();

  private static final IPolicyValidator POLICY_VALIDATOR_46 = new PolicyValidator46();

  @Override
  public boolean validateXMLSchema(String policy) throws InvalidPolicyException {
    if (policy == null) {
      throw new InvalidPolicyException("Policy must not be null");
    }

    if (policy.contains("http://www.iese.fraunhofer.de/ind2uce/3.0.25/enforcementLanguage")) {
      return POLICY_VALIDATOR_25.validateXMLSchema(policy);
    } else if (policy.contains("")) {
      return POLICY_VALIDATOR_46.validateXMLSchema(policy);
    }
    throw new InvalidPolicyException("Unsupported policy version");
  }

  @Override
  public boolean checkPolicySolution(Policy policy) throws InvalidPolicyException {
    if (policy == null) {
      throw new InvalidPolicyException("Policy must not be null");
    }

    if (policy.getPolicy().contains("http://www.iese.fraunhofer.de/ind2uce/3.0.25/enforcementLanguage")) {
      return POLICY_VALIDATOR_25.checkPolicySolution(policy);
    } else {
      return POLICY_VALIDATOR_46.checkPolicySolution(policy);
    }
  }
}
