/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.component.interfaces;

import de.fraunhofer.iese.ind2uce.api.component.exception.InformationUndeterminableException;
import de.fraunhofer.iese.ind2uce.api.component.exception.InitializationException;
import de.fraunhofer.iese.ind2uce.api.policy.PipRequest;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.DataObject;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.Parameter;

import java.io.IOException;
import java.util.List;

/**
 * Policy Information Points provide additional information used by PDPs.
 *
 * @author Fraunhofer IESE
 */
public interface IPolicyInformationPoint extends IComponent {
  /**
   * Evaluates a certain method or condition.
   *
   * @param request Object which contains detailed information (context name and
   *          its parameters) about the PIP request
   * @return A DataObject containing the evaluation result and the evaluation
   *         result type. In case of an error, the default value (specified in
   *         the PipRequest object) will be returned.
   * @throws IOException if communication is failed
   * @throws InformationUndeterminableException if sent PIP request is
   *           semantically not processable by PIP
   */
  DataObject<?> evaluate(PipRequest<?> request) throws IOException, InformationUndeterminableException;

  /**
   * Initializes a certain method or condition evaluation.
   *
   * @param method the method to be initializes, e.g. deployContext or
   *          initialRepresentation
   * @param parameters optional parameters for the method
   * @return Return value depends on the method, e.g. initialRepresentation
   * @throws IOException throws if there is a communication problem
   * @throws InitializationException problem occurs at the time of
   *           initialization
   */
  String initialize(String method, List<Parameter<?>> parameters) throws IOException, InitializationException;
}
