/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.component.interfaces;

import de.fraunhofer.iese.ind2uce.api.policy.Event;
import de.fraunhofer.iese.ind2uce.api.policy.ExecuteAction;

import java.io.IOException;

/**
 * Policy Execution Points are used by the PDP to execute additional actions
 * like sending an email.
 *
 * @author Fraunhofer IESE
 */
public interface IPolicyExecutionPoint extends IComponent {

  /**
   * Execute an Action.
   *
   * @param action the action to be executed
   * @param event the event that caused the execution request
   * @return true if the action was executed, false otherwise
   * @throws IOException Signals that an I/O exception has occurred.
   */
  boolean execute(ExecuteAction action, Event event) throws IOException;
}
