/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.component.interfaces;

import de.fraunhofer.iese.ind2uce.api.component.exception.EvaluationUndecidableException;
import de.fraunhofer.iese.ind2uce.api.component.exception.InhibitException;
import de.fraunhofer.iese.ind2uce.api.policy.AuthorizationDecision;
import de.fraunhofer.iese.ind2uce.api.policy.Event;

import java.io.IOException;

/**
 * Policy Enforcement Points intercept system events and communicate with the
 * PDP to get a corresponding decision.
 *
 * @author Fraunhofer IESE
 */
public interface IPolicyEnforcementPoint extends IComponent {

  // it's not required to call PEP client to subscribe and un-subscribe
  // /**
  // * Subscribe for a certain event.
  // *
  // * @param subscriber the UUID of the subscriber
  // * @param eventId the event the subscriber wants to be informed about
  // * @return true if the subscription was successful, false otherwise
  // * @throws IOException if there is a interruption in communication with PEP
  // * from PDP
  // */
  // boolean subscribeForEvent(ComponentId subscriber, ActionId eventId) throws
  // IOException;
  //
  // /**
  // * Un-subscribe from a certain event.
  // *
  // * @param subscriber the UUID of the subscriber
  // * @param eventName the event the subscriber wants to unsubscribe from
  // * @return true if the unsubscription was successful, false otherwise
  // * @throws IOException if there is a interruption in communication with PEP
  // * from PDP
  // */
  // boolean unsubscribeFromEvent(ComponentId subscriber, ActionId eventName)
  // throws IOException;
  //
  // /**
  // * Un-subscribe from all events.
  // *
  // * @param subscriber the UUID of the subscriber
  // * @return true if the un-subscription was successful, false otherwise
  // * @throws IOException if there is a interruption in communication with PEP
  // * from PDP
  // */
  // boolean unsubscribe(ComponentId subscriber) throws IOException;

  /**
   * * Enforces PDP decision to the event if any PDP subscribes to ActionID of
   * the event.
   *
   * @param event to be sent to PDP and AuthorizationDecision to be enforced
   * @throws InhibitException if event is not allowed by PDP
   * @throws EvaluationUndecidableException is thrown by PDP if it was not
   *           possible to evaluate
   * @throws IOException if there is a interruption in communication with PDP
   */
  void enforce(Event event) throws InhibitException, EvaluationUndecidableException, IOException;

  /***
   * It enforces the authorization decision to the event.
   *
   * @param event on what decision to be enforced
   * @param decision which is to be enforced
   * @throws InhibitException if event is not allowed by PDP
   */
  void enforceDecision(Event event, AuthorizationDecision decision) throws InhibitException;

  /**
   * * It sends the event to subscribed PDP and returns AuthorizationDecision of
   * PDP.
   *
   * @param event to be sent to subscribed PDP
   * @return AuthorizationDecision which is returned by subscribed PDP
   * @throws EvaluationUndecidableException is thrown by PDP if it was not
   *           possible to evaluate
   * @throws IOException if there is a interruption in communication with PDP
   */
  AuthorizationDecision getDecision(Event event) throws EvaluationUndecidableException, IOException;

}
