/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.component.interfaces;

import de.fraunhofer.iese.ind2uce.api.component.identifier.ComponentId;

import java.io.IOException;
import java.io.Serializable;

/**
 * Shared interface that offers basic functionality for all IND2UCE components.
 *
 * @author Fraunhofer IESE
 */
public interface IComponent extends Serializable {

  /**
   * Gets the unique ID of the component.
   *
   * @return the unique ID of the component.
   * @throws IOException if getIdentifier fails due to connection problem
   */
  ComponentId getId() throws IOException;

  /**
   * Initializes the component. After calling this method, the component ready
   * to use.
   *
   * @param parameters parameter to serialize
   * @return true, if the component was successfully initialized, false
   *         otherwise
   * @throws IOException if initialization is not finished due to connection
   *           problem.
   */
  boolean initialize(String... parameters) throws IOException;

  /**
   * Resets the component to the initial state.
   *
   * @return true, if the component was successfully reset, false otherwise
   * @throws IOException if reset failed due to connection problem
   */
  boolean reset() throws IOException;

  /**
   * Checks whether a component is up and running.
   *
   * @return a string describing the health status. In case of spring
   *         applications, a JSON of Health.class representation is used.
   * @throws IOException
   */
  String getHealth() throws IOException;
}
