/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.component.identifier;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;

import org.slf4j.Logger;

import java.util.regex.Pattern;

/**
 * The Class EnforcementScopeTypeId.
 */
public class EnforcementScopeTypeId extends Ind2uceEntity {

  /**
   * The Constant serialVersionUID.
   */
  private static final long serialVersionUID = 5971783346726612578L;

  /**
   * The Constant LOG.
   */
  private static final Logger LOG = LoggerFactory.getLogger(EnforcementScopeTypeId.class);

  /**
   * The Constant URN_ES_TYPE_PATTERN.
   */
  public static final Pattern URN_ES_TYPE_PATTERN = Pattern.compile("^urn:es-type:[a-z0-9()+,\\-.=@;$_!*']+$", Pattern.CASE_INSENSITIVE);

  /**
   * The identifier.
   */
  private final String identifier;

  /**
   * Instantiates a new enforcement scope type id.
   *
   * @param urn the urn
   */
  public EnforcementScopeTypeId(String urn) {
    this.validate(urn);
    this.identifier = urn;
  }

  /*
   * (non-Javadoc)
   * @see java.lang.Object#equals(java.lang.Object)
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof EnforcementScopeTypeId)) {
      return false;
    }

    final EnforcementScopeTypeId that = (EnforcementScopeTypeId)o;

    return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;

  }

  /*
   * (non-Javadoc)
   * @see java.lang.Object#hashCode()
   */
  @Override
  public int hashCode() {
    return this.identifier != null ? this.identifier.hashCode() : 0;
  }

  /*
   * (non-Javadoc)
   * @see de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity#toString()
   */
  @Override
  public String toString() {
    return this.identifier;
  }

  /**
   * Validate.
   *
   * @param uri the uri
   */
  protected void validate(String uri) {
    URN_ES_TYPE_PATTERN.matcher(uri).matches();
  }
}
