/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.component.exception;

/**
 * InformationUndeterminableException indicates that a PIP can not resolve the
 * demanded information.
 *
 * @author Fraunhofer IESE
 */
public class InformationUndeterminableException extends Exception {

  /**
   * The Constant serialVersionUID.
   */
  private static final long serialVersionUID = 9019539726558479581L;

  /**
   * Instantiates a new information undeterminable exception.
   */
  public InformationUndeterminableException() {
  }

  /**
   * Instantiates a new information undeterminable exception.
   *
   * @param message the message
   */
  public InformationUndeterminableException(String message) {
    super(message);
  }
}
