/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.component.description;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

/**
 * Describes a JSON Type
 */
@Entity
public class TypeDescription {

  /** The type name. */
  private String typeName;

  /** The json type. */
  private JsonType jsonType;

  /**
   * The id.
   */
  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private Long id;

  /**
   * Gets the id.
   *
   * @return the id
   */
  public Long getId() {
    return this.id;
  }

  /**
   * Gets the json type.
   *
   * @return the json type
   */
  public JsonType getJsonType() {
    return this.jsonType;
  }

  /**
   * Gets the type name.
   *
   * @return the type name
   */
  public String getTypeName() {
    return this.typeName;
  }

  /**
   * Sets the id.
   *
   * @param id the new id
   */
  public void setId(Long id) {
    this.id = id;
  }

  /**
   * Sets the json type.
   *
   * @param jsonType the new json type
   */
  public void setJsonType(JsonType jsonType) {
    this.jsonType = jsonType;
  }

  /**
   * Sets the type name.
   *
   * @param typeName the new type name
   */
  public void setTypeName(String typeName) {
    this.typeName = typeName;
  }

}
