/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.component.description;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import javax.persistence.Entity;

/**
 * Describes a Modifier. Created by chattapa on 10/28/16.
 */
@Entity
public class ModifierInterfaceDescription extends MethodInterfaceDescription {

  /**
   *
   */
  private static final long serialVersionUID = 9151711881363095024L;

  /**
   * The type of the modifier.
   */
  private String modifierType;

  /**
   * Default Constructor for at least JPA.
   */
  public ModifierInterfaceDescription() {

  }

  /**
   * Instantiates a new modifier interface description.
   *
   * @param methodName the method name
   * @param returnType the return type
   * @param description the description
   * @param modifierType the modifier type
   * @param parameters the parameters
   */
  public ModifierInterfaceDescription(String methodName, Class<?> returnType, String description, String modifierType, InputParameterDescription... parameters) {
    super(methodName, returnType, description, new LinkedList<>(Arrays.asList(parameters)));
    this.modifierType = modifierType;
  }

  /**
   * Instantiates a new modifier interface description.
   *
   * @param methodName the method name
   * @param returnType the return type
   * @param description the description
   * @param modifierType the modifier type
   * @param parameters the parameters
   */
  public ModifierInterfaceDescription(String methodName, Class<?> returnType, String description, String modifierType, List<InputParameterDescription> parameters) {
    super(methodName, returnType, description, parameters);
    this.modifierType = modifierType;
  }

  /**
   * *.
   *
   * @return the type of the modifier
   */
  public String getModifierType() {
    return this.modifierType;
  }

  /**
   * *.
   *
   * @param modifierType the new modifier type
   */
  public void setModifierType(String modifierType) {
    this.modifierType = modifierType;
  }

}
