/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.component.description;

/**
 * Represents the three supported Types of JSON: Object, Array and Primitive
 * Created by chattapa on 11/11/16.
 */
public enum JsonType {

  /** The object. */
  OBJECT("OBJECT"),
  /** The array. */
  ARRAY("ARRAY"),
  /** The primitive. */
  PRIMITIVE("PRIMITIVE");

  /** The json type. */
  private final String jsonType;

  /**
   * Instantiates a new json type.
   *
   * @param jsonType the json type
   */
  JsonType(String jsonType) {
    this.jsonType = jsonType;
  }

  /**
   * Gets the json type.
   *
   * @return the json type
   */
  public String getJsonType() {
    return this.jsonType;
  }
}
