/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.component.description;

import java.util.HashMap;
import java.util.Map;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToMany;

/**
 * The Class ClassTypeDescription.
 */
@Entity
public class ClassTypeDescription extends TypeDescription {

  /** The fields. */
  @OneToMany(cascade = {
      CascadeType.ALL
  }, orphanRemoval = true)
  private Map<String, TypeDescription> fields = new HashMap<>();

  /**
   * Adds the fields.
   *
   * @param key the key
   * @param value the value
   */
  public void addFields(String key, TypeDescription value) {
    this.fields.put(key, value);
  }

  /**
   * Gets the fields.
   *
   * @return the fields
   */
  public Map<String, TypeDescription> getFields() {
    return this.fields;
  }

  /**
   * Sets the fields.
   *
   * @param fieldList the field list
   */
  public void setFields(Map<String, TypeDescription> fieldList) {
    this.fields = fieldList;
  }

}
