/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.component;

import de.fraunhofer.iese.ind2uce.api.component.description.ModifierInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.description.PepInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.identifier.ComponentId;

import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.OneToMany;

/**
 * Created by goetzingert on 03/11/2016.
 */
@Entity
public class PepComponent extends ComponentBase {

  /** The interface descriptions. */
  @OneToMany(cascade = {
      CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REMOVE
  })
  private List<PepInterfaceDescription> interfaceDescriptions;

  /** List of Modifier. */
  @OneToMany(cascade = {
      CascadeType.ALL
  }, orphanRemoval = true)
  private List<ModifierInterfaceDescription> modifierDescriptionList;

  /**
   * Used for JPA.
   */
  public PepComponent() {

  }

  /**
   * Instantiates a new pep component.
   *
   * @param id the id
   */
  public PepComponent(ComponentId id) {
    super(id);
  }

  /**
   * Gets the interface descriptions.
   *
   * @return the interface descriptions
   */
  public List<PepInterfaceDescription> getInterfaceDescriptions() {
    return this.interfaceDescriptions;
  }

  /**
   * Gets the modifier description list.
   *
   * @return the modifier description list
   */
  public List<ModifierInterfaceDescription> getModifierDescriptionList() {
    return this.modifierDescriptionList;
  }

  /**
   * Sets the interface descriptions.
   *
   * @param interfaceDescriptions the new interface descriptions
   */
  public void setInterfaceDescriptions(List<PepInterfaceDescription> interfaceDescriptions) {
    this.interfaceDescriptions = interfaceDescriptions;
  }

  /**
   * Sets the modifier description list.
   *
   * @param modifierDescriptionList the new modifier description list
   */
  public void setModifierDescriptionList(List<ModifierInterfaceDescription> modifierDescriptionList) {
    this.modifierDescriptionList = modifierDescriptionList;
  }
}
