/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.component;

import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.component.description.MethodInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.identifier.EnforcementScopeId;
import de.fraunhofer.iese.ind2uce.api.component.identifier.EnforcementScopeTypeId;

import java.util.ArrayList;
import java.util.List;

/**
 * The EsDescription is a description of all components that are registered at
 * the PolicyManagementPoint of the Enforcement Scope, including all URLs and
 * {@link MethodInterfaceDescription}s of the components.
 *
 * @author Fraunhofer IESE
 */
public class EnforcementScope extends Ind2uceEntity {

  /**
   * The Constant serialVersionUID.
   */
  private static final long serialVersionUID = 6977737490961958003L;

  /**
   * The unique ID of the enforcement scope.
   */
  private EnforcementScopeId id;

  /**
   * The type of the enforcement scope.
   */
  private EnforcementScopeTypeId type;

  /**
   * The registered PolicyDecisionPoint.
   */
  private Component pdp;

  /**
   * The List of registered PolicyEnforcementPoints.
   */
  private List<PepComponent> peps = new ArrayList<>();

  /**
   * The List of registered PolicyInformationPoints.
   */
  private List<Component> pips = new ArrayList<>();

  /**
   * The List of registered PolicyExecutionPoints.
   */
  private List<Component> pxps = new ArrayList<>();

  /**
   * Instantiates a new enforcement scope.
   *
   * @param id the id of the enforcement scope
   * @param type the type of the enforcement scope
   */
  public EnforcementScope(EnforcementScopeId id, EnforcementScopeTypeId type) {
    super();
    this.id = id;
    this.type = type;
  }

  /**
   * Instantiates a new enforcement scope.
   *
   * @param id the id of the enforcement scope
   * @param type the type of the enforcement scope
   * @param pdp the registered PolicyDecisionPoint
   * @param peps the List of registered PolicyEnforcementPoints
   * @param pips the List of registered PolicyInformationPoints
   * @param pxps the List of registered PolicyExecutionPoints
   */
  public EnforcementScope(EnforcementScopeId id, EnforcementScopeTypeId type, Component pdp, List<PepComponent> peps, List<Component> pips, List<Component> pxps) {
    super();
    this.id = id;
    this.type = type;
    this.pdp = pdp;
    this.peps = peps;
    this.pips = pips;
    this.pxps = pxps;
  }

  /**
   * Gets the unique ID of the enforcement scope.
   *
   * @return the unique ID of the enforcement scope
   */
  public EnforcementScopeId getId() {
    return this.id;
  }

  /**
   * Gets the registered PolicyDecisionPoint.
   *
   * @return the registered PolicyDecisionPoint
   */
  public Component getPdp() {
    return this.pdp;
  }

  /**
   * Gets the List of registered PolicyEnforcementPoints.
   *
   * @return the registered PolicyEnforcementPoints
   */
  public List<PepComponent> getPeps() {
    return this.peps;
  }

  /**
   * Gets the List of registered PolicyInformationPoints.
   *
   * @return the registered PolicyInformationPoints
   */
  public List<Component> getPips() {
    return this.pips;
  }

  /**
   * Gets the List of registered PolicyExecutionPoints.
   *
   * @return the List of registered PolicyExecutionPoints
   */
  public List<Component> getPxps() {
    return this.pxps;
  }

  /**
   * Gets the unique ID of the enforcement scope.
   *
   * @return the unique ID of the enforcement scope
   */
  public EnforcementScopeTypeId getType() {
    return this.type;
  }

  /**
   * Sets the unique ID of the enforcement scope.
   *
   * @param id the new unique ID of the enforcement scope
   */
  public void setId(EnforcementScopeId id) {
    this.id = id;
  }

  /**
   * Sets the registered PolicyDecisionPoint.
   *
   * @param pdp the new registered PolicyDecisionPoint
   */
  public void setPdp(Component pdp) {
    this.pdp = pdp;
  }

  /**
   * Sets the List of registered PolicyEnforcementPoints.
   *
   * @param peps the new List of registered PolicyEnforcementPoints
   */
  public void setPeps(List<PepComponent> peps) {
    this.peps = peps;
  }

  /**
   * Sets the List of registered PolicyInformationPoints.
   *
   * @param pips the new List of registered PolicyInformationPoints
   */
  public void setPips(List<Component> pips) {
    this.pips = pips;
  }

  /**
   * Sets the List of registered PolicyExecutionPoints.
   *
   * @param pxps the new List of registered PolicyExecutionPoints
   */
  public void setPxps(List<Component> pxps) {
    this.pxps = pxps;
  }

  /**
   * Sets the unique ID of the enforcement scope.
   *
   * @param type the new unique ID of the enforcement scope
   */
  public void setType(EnforcementScopeTypeId type) {
    this.type = type;
  }

}
