/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.api.component;

import de.fraunhofer.iese.ind2uce.api.component.interfaces.IComponent;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyDecisionPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyEnforcementPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyExecutionPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyInformationPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyManagementPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyRetrievalPoint;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IRootPolicyManagementPoint;

/**
 * The different types of IND2UCE framework components.
 *
 * @author Fraunhofer IESE
 */
public enum ComponentType {
  /**
   * Policy Administration Point. Does not have an interface.
   */
  PAP(null),

  /**
   * Policy Decision Point.
   */
  PDP(IPolicyDecisionPoint.class),

  /**
   * Policy Enforcement Point.
   */
  PEP(IPolicyEnforcementPoint.class),

  /**
   * Policy Information Point.
   */
  PIP(IPolicyInformationPoint.class),

  /**
   * Policy Management Point Client.
   */
  PMP(IPolicyManagementPoint.class),

  /**
   * Policy Management Point Server.
   */
  PMP_SERVER(IRootPolicyManagementPoint.class),

  /**
   * Policy Retrieval Point.
   */
  PRP(IPolicyRetrievalPoint.class),

  /**
   * Policy Execution Point.
   */
  PXP(IPolicyExecutionPoint.class);

  /**
   * The class that corresponds to the type.
   */
  private Class<? extends IComponent> interfaceClass;

  /**
   * Instantiates a new component type.
   *
   * @param type the type
   */
  private ComponentType(Class<? extends IComponent> type) {
    this.interfaceClass = type;
  }

  /**
   * Gets interface class for the component type.
   *
   * @return the IND2UCE component interface
   */
  public Class<? extends IComponent> getInterface() {
    return this.interfaceClass;
  }

}
