/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.spha.core.strategy;

import de.fraunhofer.iem.spha.core.hierarchy.KpiHierarchyEdge;
import de.fraunhofer.iem.spha.core.strategy.BaseKpiCalculationStrategy;
import de.fraunhofer.iem.spha.model.kpi.KpiStrategyId;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiCalculationResult;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiNode;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lde/fraunhofer/iem/spha/core/strategy/XorKPICalculationStrategy;", "Lde/fraunhofer/iem/spha/core/strategy/BaseKpiCalculationStrategy;", "<init>", "()V", "kpiStrategyId", "Lde/fraunhofer/iem/spha/model/kpi/KpiStrategyId;", "getKpiStrategyId", "()Lde/fraunhofer/iem/spha/model/kpi/KpiStrategyId;", "internalCalculateKpi", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiCalculationResult;", "edges", "", "Lde/fraunhofer/iem/spha/core/hierarchy/KpiHierarchyEdge;", "internalIsValid", "", "node", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiNode;", "strict", "core"})
public final class XorKPICalculationStrategy
extends BaseKpiCalculationStrategy {
    @NotNull
    public static final XorKPICalculationStrategy INSTANCE = new XorKPICalculationStrategy();

    private XorKPICalculationStrategy() {
    }

    @Override
    @NotNull
    public KpiStrategyId getKpiStrategyId() {
        return KpiStrategyId.XOR_STRATEGY;
    }

    @Override
    @NotNull
    protected KpiCalculationResult internalCalculateKpi(@NotNull Collection<KpiHierarchyEdge> edges) {
        Intrinsics.checkNotNullParameter(edges, (String)"edges");
        if (edges.size() != 2) {
            return (KpiCalculationResult)new KpiCalculationResult.Error("XOR calculation strategy called with " + edges.size() + " valid elements, which is illegal.");
        }
        if (((KpiHierarchyEdge)CollectionsKt.first((Iterable)edges)).getTo().getScore() == 100 != (((KpiHierarchyEdge)CollectionsKt.last((Iterable)edges)).getTo().getScore() == 100)) {
            return (KpiCalculationResult)new KpiCalculationResult.Success(100);
        }
        return (KpiCalculationResult)new KpiCalculationResult.Success(0);
    }

    @Override
    protected boolean internalIsValid(@NotNull KpiNode node, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node.getEdges().size() == 2;
    }
}

