/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.spha.core.strategy;

import de.fraunhofer.iem.spha.core.hierarchy.KpiHierarchyEdge;
import de.fraunhofer.iem.spha.core.strategy.BaseKpiCalculationStrategy;
import de.fraunhofer.iem.spha.core.strategy.WeightedRatioKPICalculationStrategyKt;
import de.fraunhofer.iem.spha.model.kpi.KpiStrategyId;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiCalculationResult;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiNode;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0014R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lde/fraunhofer/iem/spha/core/strategy/WeightedRatioKPICalculationStrategy;", "Lde/fraunhofer/iem/spha/core/strategy/BaseKpiCalculationStrategy;", "<init>", "()V", "kpiStrategyId", "Lde/fraunhofer/iem/spha/model/kpi/KpiStrategyId;", "getKpiStrategyId", "()Lde/fraunhofer/iem/spha/model/kpi/KpiStrategyId;", "internalCalculateKpi", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiCalculationResult;", "edges", "", "Lde/fraunhofer/iem/spha/core/hierarchy/KpiHierarchyEdge;", "internalIsValid", "", "node", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiNode;", "strict", "core"})
@SourceDebugExtension(value={"SMAP\nWeightedRatioKPICalculationStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WeightedRatioKPICalculationStrategy.kt\nde/fraunhofer/iem/spha/core/strategy/WeightedRatioKPICalculationStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1755#2,3:104\n*S KotlinDebug\n*F\n+ 1 WeightedRatioKPICalculationStrategy.kt\nde/fraunhofer/iem/spha/core/strategy/WeightedRatioKPICalculationStrategy\n*L\n35#1:104,3\n*E\n"})
public final class WeightedRatioKPICalculationStrategy
extends BaseKpiCalculationStrategy {
    @NotNull
    public static final WeightedRatioKPICalculationStrategy INSTANCE = new WeightedRatioKPICalculationStrategy();

    private WeightedRatioKPICalculationStrategy() {
    }

    @Override
    @NotNull
    public KpiStrategyId getKpiStrategyId() {
        return KpiStrategyId.WEIGHTED_RATIO_STRATEGY;
    }

    @Override
    @NotNull
    protected KpiCalculationResult internalCalculateKpi(@NotNull Collection<KpiHierarchyEdge> edges) {
        double d;
        double secondScore;
        boolean bl;
        block11: {
            Intrinsics.checkNotNullParameter(edges, (String)"edges");
            if (edges.size() != 2) {
                return (KpiCalculationResult)new KpiCalculationResult.Error("Ratio calculation strategy called with " + edges.size() + " valid elements, which is illegal.");
            }
            Iterable $this$any$iv = edges;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KpiHierarchyEdge it = (KpiHierarchyEdge)element$iv;
                    boolean bl2 = false;
                    if (!it.getTo().hasNoResult()) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return (KpiCalculationResult)new KpiCalculationResult.Error("Ratio calculation strategy has elements without result");
        }
        double biggerValue = 0.0;
        double smallerValue = 0.0;
        double firstScore = (double)((KpiHierarchyEdge)CollectionsKt.first((Iterable)edges)).getTo().getScore() * ((KpiHierarchyEdge)CollectionsKt.first((Iterable)edges)).getActualWeight();
        if (firstScore > (secondScore = (double)((KpiHierarchyEdge)CollectionsKt.last((Iterable)edges)).getTo().getScore() * ((KpiHierarchyEdge)CollectionsKt.last((Iterable)edges)).getActualWeight())) {
            biggerValue = firstScore;
            smallerValue = secondScore;
        } else {
            biggerValue = secondScore;
            smallerValue = firstScore;
        }
        try {
            if (biggerValue == 0.0) {
                return (KpiCalculationResult)new KpiCalculationResult.Error("Tried division by 0");
            }
            d = smallerValue / biggerValue;
        }
        catch (Exception e) {
            WeightedRatioKPICalculationStrategyKt.access$getLogger$p().error(WeightedRatioKPICalculationStrategy::internalCalculateKpi$lambda$1);
            String string = e.getMessage();
            if (string == null) {
                string = e.toString();
            }
            return (KpiCalculationResult)new KpiCalculationResult.Error(string);
        }
        double ratio = d;
        return (KpiCalculationResult)new KpiCalculationResult.Success((int)(ratio * (double)100));
    }

    @Override
    protected boolean internalIsValid(@NotNull KpiNode node, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (strict) {
            return node.getEdges().size() == 2;
        }
        if (node.getEdges().size() > 2) {
            WeightedRatioKPICalculationStrategyKt.access$getLogger$p().warn(() -> WeightedRatioKPICalculationStrategy.internalIsValid$lambda$2(node));
            return true;
        }
        return node.getEdges().size() > 1;
    }

    private static final Object internalCalculateKpi$lambda$1() {
        return "Error ";
    }

    private static final Object internalIsValid$lambda$2(KpiNode $node) {
        return "Ratio KPI calculation strategy for node " + $node + " has more than two children.This is allowed in relaxed mode, however it is not defined, whichchildren are selected for calculation. This can lead toambiguous results.";
    }
}

