/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.spha.core.strategy;

import de.fraunhofer.iem.spha.core.hierarchy.KpiHierarchyEdge;
import de.fraunhofer.iem.spha.core.strategy.KpiCalculationStrategy;
import de.fraunhofer.iem.spha.core.strategy.KpiCalculationStrategyKt;
import de.fraunhofer.iem.spha.model.kpi.KpiStrategyId;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiCalculationResult;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0012\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH$J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH$R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lde/fraunhofer/iem/spha/core/strategy/BaseKpiCalculationStrategy;", "Lde/fraunhofer/iem/spha/core/strategy/KpiCalculationStrategy;", "<init>", "()V", "kpiStrategyId", "Lde/fraunhofer/iem/spha/model/kpi/KpiStrategyId;", "getKpiStrategyId", "()Lde/fraunhofer/iem/spha/model/kpi/KpiStrategyId;", "calculateKpi", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiCalculationResult;", "hierarchyEdges", "", "Lde/fraunhofer/iem/spha/core/hierarchy/KpiHierarchyEdge;", "strict", "", "updateEdgeWeights", "", "edges", "internalCalculateKpi", "isValid", "node", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiNode;", "internalIsValid", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nKpiCalculationStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KpiCalculationStrategy.kt\nde/fraunhofer/iem/spha/core/strategy/BaseKpiCalculationStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n2632#2,3:208\n2632#2,3:211\n1863#2,2:214\n1755#2,3:216\n1863#2,2:219\n774#2:221\n865#2,2:222\n1863#2,2:224\n*S KotlinDebug\n*F\n+ 1 KpiCalculationStrategy.kt\nde/fraunhofer/iem/spha/core/strategy/BaseKpiCalculationStrategy\n*L\n87#1:208,3\n88#1:211,3\n93#1:214,2\n102#1:216,3\n132#1:219,2\n145#1:221\n145#1:222,2\n146#1:224,2\n*E\n"})
public abstract class BaseKpiCalculationStrategy
implements KpiCalculationStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract KpiStrategyId getKpiStrategyId();

    @Override
    @NotNull
    public final KpiCalculationResult calculateKpi(@NotNull Collection<KpiHierarchyEdge> hierarchyEdges, boolean strict) {
        boolean bl;
        KpiCalculationResult result;
        block17: {
            block20: {
                KpiHierarchyEdge it;
                block19: {
                    boolean bl2;
                    block16: {
                        boolean $i$f$none;
                        Iterable $this$none$iv;
                        block18: {
                            boolean bl3;
                            block15: {
                                Intrinsics.checkNotNullParameter(hierarchyEdges, (String)"hierarchyEdges");
                                if (!strict) break block18;
                                $this$none$iv = hierarchyEdges;
                                $i$f$none = false;
                                if (((Collection)$this$none$iv).isEmpty()) {
                                    bl3 = true;
                                } else {
                                    for (Object element$iv : $this$none$iv) {
                                        it = (KpiHierarchyEdge)element$iv;
                                        boolean bl4 = false;
                                        if (!(it.getTo().getResult() instanceof KpiCalculationResult.Success)) continue;
                                        bl3 = false;
                                        break block15;
                                    }
                                    bl3 = true;
                                }
                            }
                            if (bl3) break block19;
                        }
                        $this$none$iv = hierarchyEdges;
                        $i$f$none = false;
                        if (((Collection)$this$none$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                it = (KpiHierarchyEdge)element$iv;
                                boolean bl5 = false;
                                if (!(!it.getTo().hasNoResult())) continue;
                                bl2 = false;
                                break block16;
                            }
                            bl2 = true;
                        }
                    }
                    if (!bl2 && !hierarchyEdges.isEmpty()) break block20;
                }
                Iterable $this$forEach$iv = hierarchyEdges;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (KpiHierarchyEdge)element$iv;
                    boolean bl6 = false;
                    it.setActualWeight(0.0);
                }
                return (KpiCalculationResult)new KpiCalculationResult.Empty(null, 1, null);
            }
            this.updateEdgeWeights(hierarchyEdges, strict);
            result = Companion.getResultInValidRange(this.internalCalculateKpi(hierarchyEdges));
            Iterable $this$any$iv = hierarchyEdges;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KpiHierarchyEdge it = (KpiHierarchyEdge)element$iv;
                    boolean bl7 = false;
                    if (!(!(it.getTo().getResult() instanceof KpiCalculationResult.Success))) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        if (bl && result instanceof KpiCalculationResult.Success) {
            return (KpiCalculationResult)new KpiCalculationResult.Incomplete(((KpiCalculationResult.Success)result).getScore(), "Incomplete results.");
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateEdgeWeights(Collection<KpiHierarchyEdge> edges, boolean strict) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        double missingEdgeWeight = 0.0;
        int counterIncompleteEdges = 0;
        Iterable $this$forEach$iv = edges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KpiHierarchyEdge edge = (KpiHierarchyEdge)element$iv;
            boolean bl = false;
            if (!edge.getTo().hasNoResult() && (!strict || !edge.getTo().hasIncompleteResult())) continue;
            missingEdgeWeight += edge.getPlannedWeight();
            edge.setActualWeight(0.0);
            ++counterIncompleteEdges;
        }
        if (!(missingEdgeWeight == 0.0) && edges.size() - counterIncompleteEdges > 0) {
            missingEdgeWeight /= (double)(edges.size() - counterIncompleteEdges);
        }
        $this$forEach$iv = edges;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KpiHierarchyEdge it = (KpiHierarchyEdge)element$iv$iv;
            boolean bl = false;
            if (!(!it.getTo().hasNoResult())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KpiHierarchyEdge edge = (KpiHierarchyEdge)element$iv;
            boolean bl = false;
            edge.setActualWeight(edge.getPlannedWeight() + missingEdgeWeight);
        }
    }

    @NotNull
    protected abstract KpiCalculationResult internalCalculateKpi(@NotNull Collection<KpiHierarchyEdge> var1);

    @Override
    public final boolean isValid(@NotNull KpiNode node, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getKpiStrategyId() != this.getKpiStrategyId()) {
            return true;
        }
        if (node.getEdges().isEmpty()) {
            return true;
        }
        return this.internalIsValid(node, strict);
    }

    protected abstract boolean internalIsValid(@NotNull KpiNode var1, boolean var2);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J;\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\u00052\u0006\u0010\u0006\u001a\u0002H\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\b0\fH\u0002\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lde/fraunhofer/iem/spha/core/strategy/BaseKpiCalculationStrategy$Companion;", "", "<init>", "()V", "getResultInValidRange", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiCalculationResult;", "result", "createValidScore", "T", "score", "", "createResult", "Lkotlin/Function1;", "(Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiCalculationResult;ILkotlin/jvm/functions/Function1;)Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiCalculationResult;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KpiCalculationResult getResultInValidRange(@NotNull KpiCalculationResult result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            KpiCalculationResult kpiCalculationResult = result;
            return kpiCalculationResult instanceof KpiCalculationResult.Success ? this.createValidScore(result, ((KpiCalculationResult.Success)result).getScore(), Companion::getResultInValidRange$lambda$0) : (kpiCalculationResult instanceof KpiCalculationResult.Incomplete ? this.createValidScore(result, ((KpiCalculationResult.Incomplete)result).getScore(), arg_0 -> Companion.getResultInValidRange$lambda$1(result, arg_0)) : result);
        }

        private final <T extends KpiCalculationResult> T createValidScore(T result, int score, Function1<? super Integer, ? extends T> createResult) {
            Object object;
            if (score < 0) {
                KpiCalculationStrategyKt.access$getLogger$p().warn(() -> Companion.createValidScore$lambda$2(result));
                object = (KpiCalculationResult)createResult.invoke((Object)0);
            } else if (score > 100) {
                KpiCalculationStrategyKt.access$getLogger$p().warn(() -> Companion.createValidScore$lambda$3(result));
                object = (KpiCalculationResult)createResult.invoke((Object)100);
            } else {
                object = result;
            }
            return object;
        }

        private static final KpiCalculationResult.Success getResultInValidRange$lambda$0(int score) {
            return new KpiCalculationResult.Success(score);
        }

        private static final KpiCalculationResult.Incomplete getResultInValidRange$lambda$1(KpiCalculationResult $result, int score) {
            return new KpiCalculationResult.Incomplete(score, ((KpiCalculationResult.Incomplete)$result).getReason());
        }

        private static final Object createValidScore$lambda$2(KpiCalculationResult $result) {
            return "Calculation result score " + $result + " is out of bounds.";
        }

        private static final Object createValidScore$lambda$3(KpiCalculationResult $result) {
            return "Calculation result score " + $result + " is out of bounds.";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

