/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.spha.core.hierarchy;

import de.fraunhofer.iem.spha.core.hierarchy.KpiHierarchyEdge;
import de.fraunhofer.iem.spha.model.kpi.KpiId;
import de.fraunhofer.iem.spha.model.kpi.KpiStrategyId;
import de.fraunhofer.iem.spha.model.kpi.RawValueKpi;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiCalculationResult;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiEdge;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiNode;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiResultEdge;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiResultNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lde/fraunhofer/iem/spha/core/hierarchy/KpiHierarchyNode;", "", "kpiId", "Lde/fraunhofer/iem/spha/model/kpi/KpiId;", "kpiStrategyId", "Lde/fraunhofer/iem/spha/model/kpi/KpiStrategyId;", "hierarchyEdges", "", "Lde/fraunhofer/iem/spha/core/hierarchy/KpiHierarchyEdge;", "<init>", "(Lde/fraunhofer/iem/spha/model/kpi/KpiId;Lde/fraunhofer/iem/spha/model/kpi/KpiStrategyId;Ljava/util/List;)V", "getKpiId", "()Lde/fraunhofer/iem/spha/model/kpi/KpiId;", "getKpiStrategyId", "()Lde/fraunhofer/iem/spha/model/kpi/KpiStrategyId;", "getHierarchyEdges", "()Ljava/util/List;", "result", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiCalculationResult;", "getResult", "()Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiCalculationResult;", "setResult", "(Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiCalculationResult;)V", "score", "", "getScore", "()I", "hasNoResult", "", "hasIncompleteResult", "toString", "", "Companion", "core"})
public final class KpiHierarchyNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KpiId kpiId;
    @NotNull
    private final KpiStrategyId kpiStrategyId;
    @NotNull
    private final List<KpiHierarchyEdge> hierarchyEdges;
    @NotNull
    private KpiCalculationResult result;

    private KpiHierarchyNode(KpiId kpiId, KpiStrategyId kpiStrategyId, List<KpiHierarchyEdge> hierarchyEdges) {
        this.kpiId = kpiId;
        this.kpiStrategyId = kpiStrategyId;
        this.hierarchyEdges = hierarchyEdges;
        this.result = (KpiCalculationResult)new KpiCalculationResult.Empty(null, 1, null);
    }

    @NotNull
    public final KpiId getKpiId() {
        return this.kpiId;
    }

    @NotNull
    public final KpiStrategyId getKpiStrategyId() {
        return this.kpiStrategyId;
    }

    @NotNull
    public final List<KpiHierarchyEdge> getHierarchyEdges() {
        return this.hierarchyEdges;
    }

    @NotNull
    public final KpiCalculationResult getResult() {
        return this.result;
    }

    public final void setResult(@NotNull KpiCalculationResult kpiCalculationResult) {
        Intrinsics.checkNotNullParameter((Object)kpiCalculationResult, (String)"<set-?>");
        this.result = kpiCalculationResult;
    }

    public final int getScore() {
        int n;
        KpiCalculationResult kpiCalculationResult = this.result;
        KpiCalculationResult.Success success = kpiCalculationResult instanceof KpiCalculationResult.Success ? (KpiCalculationResult.Success)kpiCalculationResult : null;
        if (success != null) {
            n = success.getScore();
        } else {
            KpiCalculationResult kpiCalculationResult2 = this.result;
            KpiCalculationResult.Incomplete incomplete = kpiCalculationResult2 instanceof KpiCalculationResult.Incomplete ? (KpiCalculationResult.Incomplete)kpiCalculationResult2 : null;
            n = incomplete != null ? incomplete.getScore() : 0;
        }
        return n;
    }

    public final boolean hasNoResult() {
        return this.result instanceof KpiCalculationResult.Empty || this.result instanceof KpiCalculationResult.Error;
    }

    public final boolean hasIncompleteResult() {
        return this.result instanceof KpiCalculationResult.Incomplete;
    }

    @NotNull
    public String toString() {
        return "KpiHierarchyNode(" + this.kpiId + ", " + this.kpiStrategyId + ", " + this.result + ", " + this.hierarchyEdges + ")";
    }

    public /* synthetic */ KpiHierarchyNode(KpiId kpiId, KpiStrategyId kpiStrategyId, List hierarchyEdges, DefaultConstructorMarker $constructor_marker) {
        this(kpiId, kpiStrategyId, hierarchyEdges);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ*\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\t2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000eH\u0002JA\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132!\u0010\u0014\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00110\u0015\u00a8\u0006\u0018"}, d2={"Lde/fraunhofer/iem/spha/core/hierarchy/KpiHierarchyNode$Companion;", "", "<init>", "()V", "to", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiResultNode;", "node", "Lde/fraunhofer/iem/spha/core/hierarchy/KpiHierarchyNode;", "from", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiNode;", "rawValueKpis", "", "Lde/fraunhofer/iem/spha/model/kpi/RawValueKpi;", "kpiIdToValues", "", "Lde/fraunhofer/iem/spha/model/kpi/KpiId;", "depthFirstTraversal", "", "seen", "", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "core"})
    @SourceDebugExtension(value={"SMAP\nKpiHierarchyNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KpiHierarchyNode.kt\nde/fraunhofer/iem/spha/core/hierarchy/KpiHierarchyNode$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1557#2:139\n1628#2,3:140\n1863#2,2:143\n1863#2,2:145\n1863#2:147\n1863#2,2:148\n1864#2:150\n1863#2,2:151\n*S KotlinDebug\n*F\n+ 1 KpiHierarchyNode.kt\nde/fraunhofer/iem/spha/core/hierarchy/KpiHierarchyNode$Companion\n*L\n54#1:139\n54#1:140,3\n66#1:143,2\n68#1:145,2\n81#1:147\n84#1:148,2\n81#1:150\n130#1:151,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final KpiResultNode to(@NotNull KpiHierarchyNode node) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            KpiId kpiId = node.getKpiId();
            KpiStrategyId kpiStrategyId = node.getKpiStrategyId();
            KpiCalculationResult kpiCalculationResult = node.getResult();
            Iterable $this$map$iv = node.getHierarchyEdges();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KpiHierarchyEdge kpiHierarchyEdge = (KpiHierarchyEdge)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new KpiResultEdge(Companion.to(it.getTo()), it.getPlannedWeight(), it.getActualWeight()));
            }
            List list = (List)destination$iv$iv;
            return new KpiResultNode(kpiId, kpiCalculationResult, kpiStrategyId, list);
        }

        @NotNull
        public final KpiHierarchyNode from(@NotNull KpiNode node, @NotNull List<RawValueKpi> rawValueKpis) {
            KpiId it;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(rawValueKpis, (String)"rawValueKpis");
            Map kpiIdToValues = new LinkedHashMap();
            Iterable $this$forEach$iv = (Iterable)KpiId.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KpiId)element$iv;
                boolean bl = false;
                kpiIdToValues.put(it, (List)new ArrayList());
            }
            $this$forEach$iv = rawValueKpis;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (RawValueKpi)element$iv;
                boolean bl = false;
                Object v = kpiIdToValues.get(it.getKind());
                Intrinsics.checkNotNull(v);
                ((List)v).add(it);
            }
            KpiHierarchyNode hierarchy = this.from(node, kpiIdToValues);
            return hierarchy;
        }

        private final KpiHierarchyNode from(KpiNode node, Map<KpiId, ? extends List<RawValueKpi>> kpiIdToValues) {
            List children = new ArrayList();
            Iterable $this$forEach$iv = node.getEdges();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List rawValues;
                KpiEdge child = (KpiEdge)element$iv;
                boolean bl = false;
                List list = kpiIdToValues.get(child.getTarget().getKpiId());
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                if (!((Collection)(rawValues = list)).isEmpty()) {
                    Iterable $this$forEach$iv2 = rawValues;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        RawValueKpi rawValueKpi = (RawValueKpi)element$iv2;
                        boolean bl2 = false;
                        KpiHierarchyNode hierarchyNode = new KpiHierarchyNode(child.getTarget().getKpiId(), KpiStrategyId.RAW_VALUE_STRATEGY, CollectionsKt.emptyList(), null);
                        hierarchyNode.setResult((KpiCalculationResult)new KpiCalculationResult.Success(rawValueKpi.getScore()));
                        KpiHierarchyEdge edge = new KpiHierarchyEdge(hierarchyNode, child.getWeight() / (double)((Collection)rawValues).size(), 0.0, 4, null);
                        children.add(edge);
                    }
                    continue;
                }
                children.add(new KpiHierarchyEdge(Companion.from(child.getTarget(), kpiIdToValues), child.getWeight(), 0.0, 4, null));
            }
            KpiId kpiId = node.getKpiId();
            KpiStrategyId kpiStrategyId = node.getKpiStrategyId();
            KpiHierarchyNode calcNode = new KpiHierarchyNode(kpiId, kpiStrategyId, children, null);
            return calcNode;
        }

        public final void depthFirstTraversal(@NotNull KpiHierarchyNode node, @NotNull Set<KpiHierarchyNode> seen, @NotNull Function1<? super KpiHierarchyNode, Unit> action) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(seen, (String)"seen");
            Intrinsics.checkNotNullParameter(action, (String)"action");
            if (!seen.add(node)) {
                return;
            }
            Iterable $this$forEach$iv = node.getHierarchyEdges();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KpiHierarchyEdge child = (KpiHierarchyEdge)element$iv;
                boolean bl = false;
                Companion.depthFirstTraversal(child.getTo(), seen, action);
            }
            action.invoke((Object)node);
        }

        public static /* synthetic */ void depthFirstTraversal$default(Companion companion, KpiHierarchyNode kpiHierarchyNode, Set set, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                set = new LinkedHashSet();
            }
            companion.depthFirstTraversal(kpiHierarchyNode, set, (Function1<? super KpiHierarchyNode, Unit>)function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

