/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.spha.core.hierarchy;

import de.fraunhofer.iem.spha.core.hierarchy.HierarchyValidatorKt;
import de.fraunhofer.iem.spha.core.strategy.KpiCalculationStrategyKt;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiEdge;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiHierarchy;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiNode;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"Lde/fraunhofer/iem/spha/core/hierarchy/HierarchyValidator;", "", "<init>", "()V", "isValid", "", "kpiHierarchy", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiHierarchy;", "strict", "validateStrategies", "node", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiNode;", "core"})
@SourceDebugExtension(value={"SMAP\nHierarchyValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HierarchyValidator.kt\nde/fraunhofer/iem/spha/core/hierarchy/HierarchyValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1#2:79\n1863#3,2:80\n*S KotlinDebug\n*F\n+ 1 HierarchyValidator.kt\nde/fraunhofer/iem/spha/core/hierarchy/HierarchyValidator\n*L\n68#1:80,2\n*E\n"})
public final class HierarchyValidator {
    @NotNull
    public static final HierarchyValidator INSTANCE = new HierarchyValidator();

    private HierarchyValidator() {
    }

    public final boolean isValid(@NotNull KpiHierarchy kpiHierarchy, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)kpiHierarchy, (String)"kpiHierarchy");
        HierarchyValidatorKt.access$getLogger$p().info(() -> HierarchyValidator.isValid$lambda$0(strict));
        KpiNode root = kpiHierarchy.getRootNode();
        if (root.getEdges().isEmpty()) {
            if (strict) {
                return false;
            }
            HierarchyValidatorKt.access$getLogger$p().warn(HierarchyValidator::isValid$lambda$1);
        }
        return this.validateStrategies(root, strict);
    }

    public static /* synthetic */ boolean isValid$default(HierarchyValidator hierarchyValidator, KpiHierarchy kpiHierarchy, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return hierarchyValidator.isValid(kpiHierarchy, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean validateStrategies(KpiNode node, boolean strict) {
        boolean isValid;
        if (!((Collection)node.getEdges()).isEmpty()) {
            Iterable iterable = node.getEdges();
            double d = 0.0;
            for (Object t : iterable) {
                void it;
                KpiEdge kpiEdge = (KpiEdge)t;
                double d2 = d;
                boolean bl = false;
                double d3 = it.getWeight();
                d = d2 + d3;
            }
            double edgeWeightSum = d;
            if (!(edgeWeightSum == 1.0)) {
                HierarchyValidatorKt.access$getLogger$p().error(() -> HierarchyValidator.validateStrategies$lambda$3(edgeWeightSum));
                return false;
            }
        }
        if (!(isValid = KpiCalculationStrategyKt.getKpiCalculationStrategy(node.getKpiStrategyId()).isValid(node, strict))) {
            return false;
        }
        Iterable $this$forEach$iv = node.getEdges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KpiEdge edge = (KpiEdge)element$iv;
            boolean bl = false;
            boolean isValidEdge = INSTANCE.validateStrategies(edge.getTarget(), strict);
            if (isValidEdge) continue;
            return false;
        }
        return true;
    }

    private static final Object isValid$lambda$0(boolean $strict) {
        return "Started KPI hierarchy validation with strict mode " + $strict + ".";
    }

    private static final Object isValid$lambda$1() {
        return "Provided KPI hierarchy is empty.";
    }

    private static final Object validateStrategies$lambda$3(double $edgeWeightSum) {
        return "Incorrect edge weights. Should sum up to 1.0 actual sum of weights " + $edgeWeightSum + ".";
    }
}

