/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.spha.core;

import de.fraunhofer.iem.spha.core.hierarchy.KpiHierarchyEdge;
import de.fraunhofer.iem.spha.core.hierarchy.KpiHierarchyNode;
import de.fraunhofer.iem.spha.core.strategy.KpiCalculationStrategyKt;
import de.fraunhofer.iem.spha.model.kpi.KpiStrategyId;
import de.fraunhofer.iem.spha.model.kpi.RawValueKpi;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiCalculationResult;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiHierarchy;
import de.fraunhofer.iem.spha.model.kpi.hierarchy.KpiResultHierarchy;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u001f\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/fraunhofer/iem/spha/core/KpiCalculator;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "calculateKpis", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiResultHierarchy;", "hierarchy", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiHierarchy;", "rawValueKpis", "", "Lde/fraunhofer/iem/spha/model/kpi/RawValueKpi;", "strict", "", "calculateKpi", "Lde/fraunhofer/iem/spha/model/kpi/hierarchy/KpiCalculationResult;", "node", "Lde/fraunhofer/iem/spha/core/hierarchy/KpiHierarchyNode;", "calculateKpi$core", "core"})
public final class KpiCalculator {
    @NotNull
    public static final KpiCalculator INSTANCE = new KpiCalculator();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(KpiCalculator::logger$lambda$0);

    private KpiCalculator() {
    }

    @NotNull
    public final KpiResultHierarchy calculateKpis(@NotNull KpiHierarchy hierarchy, @NotNull List<RawValueKpi> rawValueKpis, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)hierarchy, (String)"hierarchy");
        Intrinsics.checkNotNullParameter(rawValueKpis, (String)"rawValueKpis");
        logger.info(() -> KpiCalculator.calculateKpis$lambda$1(hierarchy, rawValueKpis, strict));
        KpiHierarchyNode root = KpiHierarchyNode.Companion.from(hierarchy.getRootNode(), rawValueKpis);
        KpiHierarchyNode.Companion.depthFirstTraversal$default(KpiHierarchyNode.Companion, root, null, arg_0 -> KpiCalculator.calculateKpis$lambda$2(strict, arg_0), 2, null);
        return KpiResultHierarchy.Companion.create(KpiHierarchyNode.Companion.to(root));
    }

    public static /* synthetic */ KpiResultHierarchy calculateKpis$default(KpiCalculator kpiCalculator, KpiHierarchy kpiHierarchy, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return kpiCalculator.calculateKpis(kpiHierarchy, list, bl);
    }

    @NotNull
    public final KpiCalculationResult calculateKpi$core(@NotNull KpiHierarchyNode node, boolean strict) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        logger.info(() -> KpiCalculator.calculateKpi$lambda$3(node));
        if (node.getKpiStrategyId() == KpiStrategyId.RAW_VALUE_STRATEGY) {
            return node.getResult();
        }
        KpiCalculationResult result = KpiCalculationStrategyKt.getKpiCalculationStrategy(node.getKpiStrategyId()).calculateKpi((Collection<KpiHierarchyEdge>)node.getHierarchyEdges(), strict);
        logger.info(() -> KpiCalculator.calculateKpi$lambda$4(result));
        return result;
    }

    public static /* synthetic */ KpiCalculationResult calculateKpi$core$default(KpiCalculator kpiCalculator, KpiHierarchyNode kpiHierarchyNode, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kpiCalculator.calculateKpi$core(kpiHierarchyNode, bl);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object calculateKpis$lambda$1(KpiHierarchy $hierarchy, List $rawValueKpis, boolean $strict) {
        return "Running KPI calculation on " + $hierarchy + " and " + $rawValueKpis + " with strict mode=" + $strict;
    }

    private static final Unit calculateKpis$lambda$2(boolean $strict, KpiHierarchyNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setResult(INSTANCE.calculateKpi$core(it, $strict));
        return Unit.INSTANCE;
    }

    private static final Object calculateKpi$lambda$3(KpiHierarchyNode $node) {
        return "Running KPI calculation on " + $node;
    }

    private static final Object calculateKpi$lambda$4(KpiCalculationResult $result) {
        return "KPI calculation result " + $result;
    }
}

