/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.spha.adapter.tools.trivy;

import de.fraunhofer.iem.spha.adapter.AdapterResult;
import de.fraunhofer.iem.spha.adapter.kpis.cve.CveAdapter;
import de.fraunhofer.iem.spha.model.adapter.trivy.CVSSData;
import de.fraunhofer.iem.spha.model.adapter.trivy.Result;
import de.fraunhofer.iem.spha.model.adapter.trivy.TrivyDto;
import de.fraunhofer.iem.spha.model.adapter.trivy.TrivyDtoV1;
import de.fraunhofer.iem.spha.model.adapter.trivy.TrivyDtoV2;
import de.fraunhofer.iem.spha.model.adapter.trivy.TrivyVulnerabilityDto;
import de.fraunhofer.iem.spha.model.adapter.vulnerability.VulnerabilityDto;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tJ\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\tH\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/fraunhofer/iem/spha/adapter/tools/trivy/TrivyAdapter;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "jsonParser", "Lkotlinx/serialization/json/Json;", "transformDataToKpi", "", "Lde/fraunhofer/iem/spha/adapter/AdapterResult;", "data", "Lde/fraunhofer/iem/spha/model/adapter/trivy/TrivyDto;", "dtoFromJson", "jsonData", "Ljava/io/InputStream;", "parseV1", "json", "Lkotlinx/serialization/json/JsonArray;", "parseV2", "Lkotlinx/serialization/json/JsonObject;", "createVulnerabilitiesDto", "Lde/fraunhofer/iem/spha/model/adapter/vulnerability/VulnerabilityDto;", "vulnerabilities", "Lde/fraunhofer/iem/spha/model/adapter/trivy/TrivyVulnerabilityDto;", "getHighestCvssScore", "", "scores", "Lde/fraunhofer/iem/spha/model/adapter/trivy/CVSSData;", "adapter"})
@SourceDebugExtension(value={"SMAP\nTrivyAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrivyAdapter.kt\nde/fraunhofer/iem/spha/adapter/tools/trivy/TrivyAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 4 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1368#2:120\n1454#2,5:121\n1368#2:128\n1454#2,5:129\n1368#2:135\n1454#2,5:136\n1611#2,9:141\n1863#2:150\n1557#2:151\n1628#2,2:152\n1630#2:155\n1864#2:157\n1620#2:158\n80#3:126\n309#4:127\n309#4:134\n309#4:154\n1#5:156\n*S KotlinDebug\n*F\n+ 1 TrivyAdapter.kt\nde/fraunhofer/iem/spha/adapter/tools/trivy/TrivyAdapter\n*L\n36#1:120\n36#1:121,5\n63#1:128\n63#1:129,5\n70#1:135\n70#1:136,5\n83#1:141,9\n83#1:150\n91#1:151\n91#1:152,2\n91#1:155\n83#1:157\n83#1:158\n45#1:126\n62#1:127\n69#1:134\n91#1:154\n83#1:156\n*E\n"})
public final class TrivyAdapter {
    @NotNull
    public static final TrivyAdapter INSTANCE = new TrivyAdapter();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(TrivyAdapter::logger$lambda$0);
    @NotNull
    private static final Json jsonParser = JsonKt.Json$default(null, TrivyAdapter::jsonParser$lambda$1, (int)1, null);

    private TrivyAdapter() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<AdapterResult> transformDataToKpi(@NotNull Collection<TrivyDto> data) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Iterable iterable = data;
        CveAdapter cveAdapter = CveAdapter.INSTANCE;
        boolean $i$f$flatMap = false;
        void var4_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TrivyDto it = (TrivyDto)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getVulnerabilities();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return cveAdapter.transformContainerVulnerabilityToKpi((List)destination$iv$iv);
    }

    @NotNull
    public final Collection<AdapterResult> transformDataToKpi(@NotNull TrivyDto data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.transformDataToKpi(CollectionsKt.listOf((Object)data));
    }

    @NotNull
    public final TrivyDto dtoFromJson(@NotNull InputStream jsonData) {
        Integer schemaVersion;
        Intrinsics.checkNotNullParameter((Object)jsonData, (String)"jsonData");
        Json $this$decodeFromStream$iv = (Json)Json.Default;
        boolean $i$f$decodeFromStream = false;
        $this$decodeFromStream$iv.getSerializersModule();
        JsonElement json = (JsonElement)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)JsonElement.Companion.serializer()), (InputStream)jsonData);
        if (json instanceof JsonArray) {
            return this.parseV1((JsonArray)json);
        }
        if (!(json instanceof JsonObject)) {
            throw new UnsupportedOperationException("The provided Trivy result is not supported.");
        }
        JsonElement jsonElement = (JsonElement)((JsonObject)json).get((Object)"SchemaVersion");
        Integer n = schemaVersion = jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? JsonElementKt.getIntOrNull((JsonPrimitive)jsonElement) : null;
        int n2 = 2;
        if (n != null && n == n2) {
            return this.parseV2((JsonObject)json);
        }
        throw new UnsupportedOperationException("Trivy results for schema version '" + schemaVersion + "' are currently not supported.");
    }

    /*
     * WARNING - void declaration
     */
    private final TrivyDto parseV1(JsonArray json) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        logger.info(TrivyAdapter::parseV1$lambda$3);
        Json $this$decodeFromJsonElement$iv = jsonParser;
        boolean $i$f$decodeFromJsonElement22 = false;
        $this$decodeFromJsonElement$iv.getSerializersModule();
        List v1dto = (List)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)new ArrayListSerializer(TrivyDtoV1.Companion.serializer()), (JsonElement)json);
        Iterable $i$f$decodeFromJsonElement22 = v1dto;
        TrivyAdapter trivyAdapter = this;
        boolean $i$f$flatMap = false;
        void var6_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TrivyDtoV1 it = (TrivyDtoV1)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getVulnerabilities();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection<VulnerabilityDto> vulnerabilities = trivyAdapter.createVulnerabilitiesDto((List)destination$iv$iv);
        return new TrivyDto(vulnerabilities);
    }

    /*
     * WARNING - void declaration
     */
    private final TrivyDto parseV2(JsonObject json) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        logger.info(TrivyAdapter::parseV2$lambda$5);
        Json $this$decodeFromJsonElement$iv = jsonParser;
        boolean $i$f$decodeFromJsonElement22 = false;
        $this$decodeFromJsonElement$iv.getSerializersModule();
        TrivyDtoV2 v2dto = (TrivyDtoV2)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)TrivyDtoV2.Companion.serializer(), (JsonElement)json);
        Iterable $i$f$decodeFromJsonElement22 = v2dto.getResults();
        TrivyAdapter trivyAdapter = this;
        boolean $i$f$flatMap = false;
        void var6_8 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Result it = (Result)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getVulnerabilities();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection<VulnerabilityDto> vulnerabilities = trivyAdapter.createVulnerabilitiesDto((List)destination$iv$iv);
        return new TrivyDto(vulnerabilities);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<VulnerabilityDto> createVulnerabilitiesDto(Collection<TrivyVulnerabilityDto> vulnerabilities) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = vulnerabilities;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VulnerabilityDto vulnerabilityDto;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TrivyVulnerabilityDto it = (TrivyVulnerabilityDto)element$iv$iv;
            boolean bl2 = false;
            if (it.getCvss() == null) {
                logger.debug(() -> TrivyAdapter.createVulnerabilitiesDto$lambda$10$lambda$7(it));
                vulnerabilityDto = null;
            } else {
                void $this$mapTo$iv$iv;
                JsonObject jsonObject = it.getCvss();
                Intrinsics.checkNotNull((Object)jsonObject);
                Iterable $this$map$iv = jsonObject.values();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    JsonElement jsonElement = (JsonElement)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    Json $this$decodeFromJsonElement$iv = jsonParser;
                    boolean $i$f$decodeFromJsonElement = false;
                    $this$decodeFromJsonElement$iv.getSerializersModule();
                    collection.add((CVSSData)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)CVSSData.Companion.serializer(), (JsonElement)it2));
                }
                List cvssData = (List)destination$iv$iv2;
                double score = INSTANCE.getHighestCvssScore(cvssData);
                logger.trace(() -> TrivyAdapter.createVulnerabilitiesDto$lambda$10$lambda$9(score, it));
                vulnerabilityDto = new VulnerabilityDto(it.getVulnerabilityID(), it.getPkgName(), it.getInstalledVersion(), score);
            }
            if (vulnerabilityDto == null) continue;
            VulnerabilityDto it$iv$iv = vulnerabilityDto;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final double getHighestCvssScore(Collection<CVSSData> scores) {
        double v2Score = 0.0;
        double v3Score = 0.0;
        for (CVSSData data : scores) {
            if (data.getV2Score() != null) {
                Double d = data.getV2Score();
                Intrinsics.checkNotNull((Object)d);
                v2Score = Math.max(v2Score, d);
            }
            if (data.getV3Score() == null) continue;
            Double d = data.getV3Score();
            Intrinsics.checkNotNull((Object)d);
            v3Score = Math.max(v3Score, d);
        }
        return Math.max(v2Score, v3Score);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit jsonParser$lambda$1(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setExplicitNulls(false);
        return Unit.INSTANCE;
    }

    private static final Object parseV1$lambda$3() {
        return "Processing Trivy result from version 0.19.0 or earlier.";
    }

    private static final Object parseV2$lambda$5() {
        return "Processing Trivy result of SchemaVersion: 2";
    }

    private static final Object createVulnerabilitiesDto$lambda$10$lambda$7(TrivyVulnerabilityDto $it) {
        return "Reported vulnerability '" + $it.getVulnerabilityID() + "' does not have a score. Skipping!";
    }

    private static final Object createVulnerabilitiesDto$lambda$10$lambda$9(double $score, TrivyVulnerabilityDto $it) {
        return "Selected CVSS score " + $score + " for vulnerability '" + $it.getVulnerabilityID() + "'";
    }
}

