/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.spha.adapter.tools.tlc.util;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u0016\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005\u00a8\u0006\u0013"}, d2={"Lde/fraunhofer/iem/spha/adapter/tools/tlc/util/TimeHelper;", "", "<init>", "()V", "dateToMs", "", "dateString", "", "getDifferenceInDays", "currentVersion", "newestVersion", "getDifferenceInWeeks", "", "getDifferenceInMonths", "getTimeDiff", "isWithinOneYear", "", "date1", "date2", "adapter"})
public final class TimeHelper {
    @NotNull
    public static final TimeHelper INSTANCE = new TimeHelper();

    private TimeHelper() {
    }

    public final long dateToMs(@NotNull String dateString) {
        Intrinsics.checkNotNullParameter((Object)dateString, (String)"dateString");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ISO_OFFSET_DATE_TIME");
        DateTimeFormatter formatter = dateTimeFormatter;
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(dateString, formatter);
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"parse(...)");
        OffsetDateTime dateTime = offsetDateTime;
        return dateTime.toInstant().toEpochMilli();
    }

    public final long getDifferenceInDays(long currentVersion, long newestVersion) {
        return this.getTimeDiff(currentVersion, newestVersion);
    }

    public final double getDifferenceInWeeks(long currentVersion, long newestVersion) {
        return (double)this.getTimeDiff(currentVersion, newestVersion) / 7.0;
    }

    public final double getDifferenceInMonths(long currentVersion, long newestVersion) {
        return (double)this.getTimeDiff(currentVersion, newestVersion) / 30.0;
    }

    private final long getTimeDiff(long currentVersion, long newestVersion) {
        Instant currentVersionTime = new Date(currentVersion).toInstant();
        Instant newestVersionTime = new Date(newestVersion).toInstant();
        long differenceInDays = ChronoUnit.DAYS.between(currentVersionTime, newestVersionTime);
        return differenceInDays;
    }

    public final boolean isWithinOneYear(long date1, long date2) {
        long oneYearInMilliseconds = TimeUnit.DAYS.toMillis(365L);
        return Math.abs(date1 - date2) <= oneYearInMilliseconds;
    }
}

