/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.spha.adapter.tools.tlc.model;

import de.fraunhofer.iem.spha.adapter.tools.tlc.model.ReleaseDistance;
import de.fraunhofer.iem.spha.adapter.tools.tlc.model.ReleaseFrequency;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0018\u001a\u00020\u0003H\u0016J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003J;\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u000bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lde/fraunhofer/iem/spha/adapter/tools/tlc/model/TechnicalLag;", "", "version", "", "libDays", "", "releaseDistance", "Lde/fraunhofer/iem/spha/adapter/tools/tlc/model/ReleaseDistance;", "releaseFrequency", "Lde/fraunhofer/iem/spha/adapter/tools/tlc/model/ReleaseFrequency;", "numberOfMissedReleases", "", "<init>", "(Ljava/lang/String;JLde/fraunhofer/iem/spha/adapter/tools/tlc/model/ReleaseDistance;Lde/fraunhofer/iem/spha/adapter/tools/tlc/model/ReleaseFrequency;I)V", "getVersion", "()Ljava/lang/String;", "getLibDays", "()J", "getReleaseDistance", "()Lde/fraunhofer/iem/spha/adapter/tools/tlc/model/ReleaseDistance;", "getReleaseFrequency", "()Lde/fraunhofer/iem/spha/adapter/tools/tlc/model/ReleaseFrequency;", "getNumberOfMissedReleases", "()I", "toString", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "adapter"})
public final class TechnicalLag {
    @NotNull
    private final String version;
    private final long libDays;
    @NotNull
    private final ReleaseDistance releaseDistance;
    @NotNull
    private final ReleaseFrequency releaseFrequency;
    private final int numberOfMissedReleases;

    public TechnicalLag(@NotNull String version, long libDays, @NotNull ReleaseDistance releaseDistance, @NotNull ReleaseFrequency releaseFrequency, int numberOfMissedReleases) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)releaseDistance, (String)"releaseDistance");
        Intrinsics.checkNotNullParameter((Object)releaseFrequency, (String)"releaseFrequency");
        this.version = version;
        this.libDays = libDays;
        this.releaseDistance = releaseDistance;
        this.releaseFrequency = releaseFrequency;
        this.numberOfMissedReleases = numberOfMissedReleases;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final long getLibDays() {
        return this.libDays;
    }

    @NotNull
    public final ReleaseDistance getReleaseDistance() {
        return this.releaseDistance;
    }

    @NotNull
    public final ReleaseFrequency getReleaseFrequency() {
        return this.releaseFrequency;
    }

    public final int getNumberOfMissedReleases() {
        return this.numberOfMissedReleases;
    }

    @NotNull
    public String toString() {
        return "Technical Lag: libDays: " + this.libDays + ", target version: " + this.version + ", # missed releases: " + this.numberOfMissedReleases + ", Version distance " + this.releaseDistance.getMajor() + "." + this.releaseDistance.getMinor() + "." + this.releaseDistance.getPatch() + " Release frequency: " + this.releaseFrequency;
    }

    @NotNull
    public final String component1() {
        return this.version;
    }

    public final long component2() {
        return this.libDays;
    }

    @NotNull
    public final ReleaseDistance component3() {
        return this.releaseDistance;
    }

    @NotNull
    public final ReleaseFrequency component4() {
        return this.releaseFrequency;
    }

    public final int component5() {
        return this.numberOfMissedReleases;
    }

    @NotNull
    public final TechnicalLag copy(@NotNull String version, long libDays, @NotNull ReleaseDistance releaseDistance, @NotNull ReleaseFrequency releaseFrequency, int numberOfMissedReleases) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)releaseDistance, (String)"releaseDistance");
        Intrinsics.checkNotNullParameter((Object)releaseFrequency, (String)"releaseFrequency");
        return new TechnicalLag(version, libDays, releaseDistance, releaseFrequency, numberOfMissedReleases);
    }

    public static /* synthetic */ TechnicalLag copy$default(TechnicalLag technicalLag, String string, long l, ReleaseDistance releaseDistance, ReleaseFrequency releaseFrequency, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = technicalLag.version;
        }
        if ((n2 & 2) != 0) {
            l = technicalLag.libDays;
        }
        if ((n2 & 4) != 0) {
            releaseDistance = technicalLag.releaseDistance;
        }
        if ((n2 & 8) != 0) {
            releaseFrequency = technicalLag.releaseFrequency;
        }
        if ((n2 & 0x10) != 0) {
            n = technicalLag.numberOfMissedReleases;
        }
        return technicalLag.copy(string, l, releaseDistance, releaseFrequency, n);
    }

    public int hashCode() {
        int result = this.version.hashCode();
        result = result * 31 + Long.hashCode(this.libDays);
        result = result * 31 + this.releaseDistance.hashCode();
        result = result * 31 + this.releaseFrequency.hashCode();
        result = result * 31 + Integer.hashCode(this.numberOfMissedReleases);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TechnicalLag)) {
            return false;
        }
        TechnicalLag technicalLag = (TechnicalLag)other;
        if (!Intrinsics.areEqual((Object)this.version, (Object)technicalLag.version)) {
            return false;
        }
        if (this.libDays != technicalLag.libDays) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.releaseDistance, (Object)technicalLag.releaseDistance)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.releaseFrequency, (Object)technicalLag.releaseFrequency)) {
            return false;
        }
        return this.numberOfMissedReleases == technicalLag.numberOfMissedReleases;
    }
}

