/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.spha.adapter.tools.tlc;

import de.fraunhofer.iem.spha.adapter.AdapterResult;
import de.fraunhofer.iem.spha.adapter.ErrorType;
import de.fraunhofer.iem.spha.adapter.tools.tlc.TechLagResult;
import de.fraunhofer.iem.spha.adapter.tools.tlc.model.Graph;
import de.fraunhofer.iem.spha.adapter.tools.tlc.model.Project;
import de.fraunhofer.iem.spha.adapter.tools.tlc.model.Version;
import de.fraunhofer.iem.spha.adapter.tools.tlc.util.TechLagHelper;
import de.fraunhofer.iem.spha.model.adapter.tlc.ProjectDto;
import de.fraunhofer.iem.spha.model.adapter.tlc.RangeThreshold;
import de.fraunhofer.iem.spha.model.adapter.tlc.TlcConfig;
import de.fraunhofer.iem.spha.model.adapter.tlc.TlcDefaultConfig;
import de.fraunhofer.iem.spha.model.adapter.tlc.TlcDto;
import de.fraunhofer.iem.spha.model.kpi.KpiId;
import de.fraunhofer.iem.spha.model.kpi.RawValueKpi;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JvmStreamsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/fraunhofer/iem/spha/adapter/tools/tlc/TlcAdapter;", "", "<init>", "()V", "jsonParser", "Lkotlinx/serialization/json/Json;", "dtoFromJson", "Lde/fraunhofer/iem/spha/model/adapter/tlc/TlcDto;", "jsonData", "Ljava/io/InputStream;", "transformDataToKpi", "", "Lde/fraunhofer/iem/spha/adapter/AdapterResult;", "data", "config", "Lde/fraunhofer/iem/spha/model/adapter/tlc/TlcConfig;", "getLibyearScore", "", "libyear", "", "isProductionScope", "", "scope", "", "ecosystem", "adapter"})
@SourceDebugExtension(value={"SMAP\nTlcAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlcAdapter.kt\nde/fraunhofer/iem/spha/adapter/tools/tlc/TlcAdapter\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,108:1\n80#2:109\n1368#3:110\n1454#3,2:111\n1368#3:113\n1454#3,2:114\n1456#3,3:120\n1456#3,3:123\n1053#3:126\n1863#3,2:127\n126#4:116\n153#4,3:117\n*S KotlinDebug\n*F\n+ 1 TlcAdapter.kt\nde/fraunhofer/iem/spha/adapter/tools/tlc/TlcAdapter\n*L\n42#1:109\n50#1:110\n50#1:111,2\n51#1:113\n51#1:114,2\n51#1:120,3\n50#1:123,3\n90#1:126\n92#1:127,2\n53#1:116\n53#1:117,3\n*E\n"})
public final class TlcAdapter {
    @NotNull
    public static final TlcAdapter INSTANCE = new TlcAdapter();
    @NotNull
    private static final Json jsonParser = JsonKt.Json$default(null, TlcAdapter::jsonParser$lambda$0, (int)1, null);

    private TlcAdapter() {
    }

    @NotNull
    public final TlcDto dtoFromJson(@NotNull InputStream jsonData) {
        Intrinsics.checkNotNullParameter((Object)jsonData, (String)"jsonData");
        Json $this$decodeFromStream$iv = jsonParser;
        boolean $i$f$decodeFromStream = false;
        $this$decodeFromStream$iv.getSerializersModule();
        return (TlcDto)JvmStreamsKt.decodeFromStream((Json)$this$decodeFromStream$iv, (DeserializationStrategy)((DeserializationStrategy)TlcDto.Companion.serializer()), (InputStream)jsonData);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<AdapterResult> transformDataToKpi(@NotNull Collection<TlcDto> data, @NotNull TlcConfig config) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Iterable $this$flatMap$iv = data;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$flatMapTo$iv$iv2;
            TlcDto tlcDto = (TlcDto)element$iv$iv;
            boolean bl = false;
            Iterable $this$flatMap$iv2 = tlcDto.getProjectDtos();
            boolean $i$f$flatMap2 = false;
            Iterable iterable2 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv2 : $this$flatMapTo$iv$iv2) {
                void $this$mapTo$iv$iv;
                ProjectDto it = (ProjectDto)element$iv$iv2;
                boolean bl2 = false;
                Project project = Project.Companion.from(it);
                Map<String, Graph> $this$map$iv = project.getGraph();
                boolean $i$f$map = false;
                Map<String, Graph> map = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    AdapterResult adapterResult;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv3;
                    boolean bl3 = false;
                    String scope = (String)entry.getKey();
                    Graph graph = (Graph)entry.getValue();
                    TechLagResult techLag = TechLagHelper.INSTANCE.getTechLagForGraph(graph, project.getArtifacts(), Version.Major);
                    if (techLag instanceof TechLagResult.Success) {
                        RawValueKpi rawValueKpi;
                        int libyearScore = INSTANCE.getLibyearScore(((TechLagResult.Success)techLag).getLibyear(), config);
                        TlcAdapter tlcAdapter = INSTANCE;
                        String string = project.getEcosystem();
                        if (tlcAdapter.isProductionScope(scope, string)) {
                            tlcAdapter = KpiId.LIB_DAYS_PROD;
                            rawValueKpi = new RawValueKpi((KpiId)tlcAdapter, libyearScore);
                        } else {
                            tlcAdapter = KpiId.LIB_DAYS_DEV;
                            rawValueKpi = new RawValueKpi((KpiId)tlcAdapter, libyearScore);
                        }
                        RawValueKpi rawValueKpi2 = rawValueKpi;
                        adapterResult = new AdapterResult.Success.KpiTechLag(rawValueKpi2, (TechLagResult.Success)techLag);
                    } else {
                        adapterResult = new AdapterResult.Error(ErrorType.DATA_VALIDATION_ERROR);
                    }
                    collection.add(adapterResult);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ Collection transformDataToKpi$default(TlcAdapter tlcAdapter, Collection collection, TlcConfig tlcConfig, int n, Object object) {
        if ((n & 2) != 0) {
            tlcConfig = TlcDefaultConfig.INSTANCE.get();
        }
        return tlcAdapter.transformDataToKpi(collection, tlcConfig);
    }

    private final int getLibyearScore(long libyear, TlcConfig config) {
        if (libyear < 0L) {
            return 100;
        }
        Iterable $this$sortedBy$iv = config.getThresholds();
        boolean $i$f$sortedBy = false;
        List sortedThresholds = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RangeThreshold it = (RangeThreshold)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getRange().getFrom());
                it = (RangeThreshold)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getRange().getFrom()));
            }
        });
        Iterable $this$forEach$iv = sortedThresholds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeThreshold threshold = (RangeThreshold)element$iv;
            boolean bl = false;
            if (libyear <= threshold.getRange().getFrom() || libyear >= threshold.getRange().getTo()) continue;
            return threshold.getScore();
        }
        return 0;
    }

    private final boolean isProductionScope(String scope, String ecosystem) {
        return Intrinsics.areEqual((Object)ecosystem, (Object)"NPM") ? Intrinsics.areEqual((Object)"dependencies", (Object)scope) : true;
    }

    private static final Unit jsonParser$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setExplicitNulls(false);
        return Unit.INSTANCE;
    }
}

