/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.spha.adapter.kpis.vcs;

import de.fraunhofer.iem.spha.adapter.AdapterResult;
import de.fraunhofer.iem.spha.adapter.ErrorType;
import de.fraunhofer.iem.spha.model.adapter.vcs.RepositoryDetailsDto;
import de.fraunhofer.iem.spha.model.kpi.KpiId;
import de.fraunhofer.iem.spha.model.kpi.RawValueKpi;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a8\u0006\t"}, d2={"Lde/fraunhofer/iem/spha/adapter/kpis/vcs/VcsAdapter;", "", "<init>", "()V", "transformDataToKpi", "", "Lde/fraunhofer/iem/spha/adapter/AdapterResult;", "data", "Lde/fraunhofer/iem/spha/model/adapter/vcs/RepositoryDetailsDto;", "adapter"})
public final class VcsAdapter {
    @NotNull
    public static final VcsAdapter INSTANCE = new VcsAdapter();

    private VcsAdapter() {
    }

    @NotNull
    public final Collection<AdapterResult> transformDataToKpi(@NotNull Collection<RepositoryDetailsDto> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        if (data.size() != 1) {
            return CollectionsKt.listOf((Object)new AdapterResult.Error(ErrorType.DATA_VALIDATION_ERROR));
        }
        RepositoryDetailsDto repoDetailsDto = (RepositoryDetailsDto)CollectionsKt.first((Iterable)data);
        Object[] objectArray = new AdapterResult.Success.Kpi[]{new AdapterResult.Success.Kpi(new RawValueKpi(KpiId.NUMBER_OF_COMMITS, repoDetailsDto.getNumberOfCommits())), new AdapterResult.Success.Kpi(new RawValueKpi(KpiId.NUMBER_OF_SIGNED_COMMITS, repoDetailsDto.getNumberOfSignedCommits())), new AdapterResult.Success.Kpi(new RawValueKpi(KpiId.IS_DEFAULT_BRANCH_PROTECTED, repoDetailsDto.isDefaultBranchProtected() ? 100 : 0))};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

