/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.spha.adapter.kpis.cve;

import de.fraunhofer.iem.spha.adapter.AdapterResult;
import de.fraunhofer.iem.spha.adapter.ErrorType;
import de.fraunhofer.iem.spha.model.adapter.vulnerability.VulnerabilityDto;
import de.fraunhofer.iem.spha.model.kpi.KpiId;
import de.fraunhofer.iem.spha.model.kpi.RawValueKpi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005J\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Lde/fraunhofer/iem/spha/adapter/kpis/cve/CveAdapter;", "", "<init>", "()V", "transformCodeVulnerabilityToKpi", "", "Lde/fraunhofer/iem/spha/adapter/AdapterResult;", "data", "Lde/fraunhofer/iem/spha/model/adapter/vulnerability/VulnerabilityDto;", "transformContainerVulnerabilityToKpi", "transformDataToKpi", "kpiId", "Lde/fraunhofer/iem/spha/model/kpi/KpiId;", "isValid", "", "adapter"})
@SourceDebugExtension(value={"SMAP\nCveAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CveAdapter.kt\nde/fraunhofer/iem/spha/adapter/kpis/cve/CveAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1557#2:54\n1628#2,3:55\n*S KotlinDebug\n*F\n+ 1 CveAdapter.kt\nde/fraunhofer/iem/spha/adapter/kpis/cve/CveAdapter\n*L\n36#1:54\n36#1:55,3\n*E\n"})
public final class CveAdapter {
    @NotNull
    public static final CveAdapter INSTANCE = new CveAdapter();

    private CveAdapter() {
    }

    @NotNull
    public final Collection<AdapterResult> transformCodeVulnerabilityToKpi(@NotNull Collection<VulnerabilityDto> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return this.transformDataToKpi(data, KpiId.CODE_VULNERABILITY_SCORE);
    }

    @NotNull
    public final Collection<AdapterResult> transformContainerVulnerabilityToKpi(@NotNull Collection<VulnerabilityDto> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        return this.transformDataToKpi(data, KpiId.CONTAINER_VULNERABILITY_SCORE);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<AdapterResult> transformDataToKpi(Collection<VulnerabilityDto> data, KpiId kpiId) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = data;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VulnerabilityDto vulnerabilityDto = (VulnerabilityDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.isValid((VulnerabilityDto)it) ? (AdapterResult)new AdapterResult.Success.Kpi(new RawValueKpi(kpiId, 100 - (int)(it.getSeverity() * (double)10))) : (AdapterResult)new AdapterResult.Error(ErrorType.DATA_VALIDATION_ERROR));
        }
        return (List)destination$iv$iv;
    }

    private final boolean isValid(VulnerabilityDto data) {
        double d = data.getSeverity();
        return (0.0 <= d ? d <= 10.0 : false) && !StringsKt.isBlank((CharSequence)data.getPackageName()) && !StringsKt.isBlank((CharSequence)data.getCveIdentifier());
    }
}

