/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iem.spha.adapter.tools.tlc.util;

import de.fraunhofer.iem.spha.adapter.tools.tlc.TechLagResult;
import de.fraunhofer.iem.spha.adapter.tools.tlc.model.Artifact;
import de.fraunhofer.iem.spha.adapter.tools.tlc.model.ArtifactVersion;
import de.fraunhofer.iem.spha.adapter.tools.tlc.model.Graph;
import de.fraunhofer.iem.spha.adapter.tools.tlc.model.Node;
import de.fraunhofer.iem.spha.adapter.tools.tlc.model.Version;
import de.fraunhofer.iem.spha.adapter.tools.tlc.util.TechLagHelperKt;
import de.fraunhofer.iem.spha.adapter.tools.tlc.util.TimeHelper;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lde/fraunhofer/iem/spha/adapter/tools/tlc/util/TechLagHelper;", "", "<init>", "()V", "getTechLagForGraph", "Lde/fraunhofer/iem/spha/adapter/tools/tlc/TechLagResult;", "graph", "Lde/fraunhofer/iem/spha/adapter/tools/tlc/model/Graph;", "artifacts", "", "Lde/fraunhofer/iem/spha/adapter/tools/tlc/model/Artifact;", "targetVersion", "Lde/fraunhofer/iem/spha/adapter/tools/tlc/model/Version;", "getTechLagForNode", "node", "Lde/fraunhofer/iem/spha/adapter/tools/tlc/model/Node;", "targetUpdateType", "adapter"})
@SourceDebugExtension(value={"SMAP\nTechLagHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TechLagHelper.kt\nde/fraunhofer/iem/spha/adapter/tools/tlc/util/TechLagHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class TechLagHelper {
    @NotNull
    public static final TechLagHelper INSTANCE = new TechLagHelper();

    private TechLagHelper() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TechLagResult getTechLagForGraph(@NotNull Graph graph, @NotNull List<Artifact> artifacts, @NotNull Version targetVersion) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter(artifacts, (String)"artifacts");
        Intrinsics.checkNotNullParameter((Object)((Object)targetVersion), (String)"targetVersion");
        if (graph.getDirectDependencies().isEmpty()) {
            return new TechLagResult.Empty("Direct dependencies are empty.");
        }
        Iterable iterable = graph.getDirectDependencies();
        long l = 0L;
        for (Object t : iterable) {
            long l2;
            void directDependency;
            Node node = (Node)t;
            long l3 = l;
            boolean bl = false;
            TechLagResult techLagResult = INSTANCE.getTechLagForNode((Node)directDependency, artifacts, targetVersion);
            if (techLagResult instanceof TechLagResult.Success) {
                l2 = ((TechLagResult.Success)techLagResult).getLibyear();
            } else {
                TechLagHelperKt.access$getLogger$p().warn(() -> TechLagHelper.getTechLagForGraph$lambda$1$lambda$0(techLagResult));
                l2 = 0L;
            }
            long l4 = l2;
            l = l3 + l4;
        }
        long sumOfTechLag = l;
        return new TechLagResult.Success(sumOfTechLag);
    }

    /*
     * WARNING - void declaration
     */
    private final TechLagResult getTechLagForNode(Node node, List<Artifact> artifacts, Version targetUpdateType) {
        Object v0;
        ArtifactVersion targetVersion;
        long childSum;
        block3: {
            Object object;
            Object object22;
            Iterable iterable = node.getChildren();
            long l = 0L;
            for (Object object22 : iterable) {
                void it;
                object = (Node)object22;
                long l2 = l;
                boolean bl = false;
                TechLagResult techLag = INSTANCE.getTechLagForNode((Node)it, artifacts, targetUpdateType);
                long l3 = techLag instanceof TechLagResult.Success ? ((TechLagResult.Success)techLag).getLibyear() : 0L;
                l = l2 + l3;
            }
            childSum = l;
            Artifact artifact = artifacts.get(node.getArtifactIdx());
            targetVersion = ArtifactVersion.Companion.getTargetVersion(node.getUsedVersion(), targetUpdateType, artifact.getVersions());
            object22 = artifact.getVersions();
            object = object22.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                ArtifactVersion it = (ArtifactVersion)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getVersionNumber(), (Object)node.getUsedVersion())) continue;
                v0 = e;
                break block3;
            }
            v0 = null;
        }
        ArtifactVersion usedVersion = v0;
        if (usedVersion == null || targetVersion == null) {
            return new TechLagResult.Empty("Result incomplete. Current version: " + usedVersion + ", target version: " + targetVersion + ".");
        }
        long diffInDays = TimeHelper.INSTANCE.getDifferenceInDays(usedVersion.getReleaseDate(), targetVersion.getReleaseDate());
        return new TechLagResult.Success(diffInDays + childSum);
    }

    private static final Object getTechLagForGraph$lambda$1$lambda$0(TechLagResult $techLagResult) {
        return "Tech lag result is " + $techLagResult;
    }
}

