/*
 * Decompiled with CFR 0.152.
 */
package boomerang.solver;

import boomerang.BoomerangOptions;
import boomerang.Query;
import boomerang.callgraph.BackwardsObservableICFG;
import boomerang.callgraph.CallerListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.controlflowgraph.ObservableControlFlowGraph;
import boomerang.scene.AllocVal;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.DataFlowScope;
import boomerang.scene.Field;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Type;
import boomerang.scene.Val;
import boomerang.solver.BackwardBoomerangSolver;
import boomerang.solver.ControlFlowEdgeBasedCallTransitionListener;
import boomerang.solver.ControlFlowEdgeBasedFieldTransitionListener;
import boomerang.solver.ForwardBoomerangSolver;
import boomerang.solver.MethodBasedFieldTransitionListener;
import boomerang.util.RegExAccessPath;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pathexpression.IRegEx;
import sync.pds.solver.EmptyStackWitnessListener;
import sync.pds.solver.SyncPDSSolver;
import sync.pds.solver.WitnessListener;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.NestedWeightedPAutomatons;
import wpds.impl.NormalRule;
import wpds.impl.Rule;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.impl.WeightedPushdownSystem;
import wpds.interfaces.State;
import wpds.interfaces.WPAUpdateListener;

public abstract class AbstractBoomerangSolver<W extends Weight>
extends SyncPDSSolver<ControlFlowGraph.Edge, Val, Field, W> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBoomerangSolver.class);
    protected final ObservableICFG<Statement, Method> icfg;
    protected final ObservableControlFlowGraph cfg;
    protected boolean INTERPROCEDURAL = true;
    protected final Map<Map.Entry<INode<Node<ControlFlowGraph.Edge, Val>>, Field>, INode<Node<ControlFlowGraph.Edge, Val>>> generatedFieldState;
    private Multimap<Method, Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>>> perMethodFieldTransitions = HashMultimap.create();
    private Multimap<Method, MethodBasedFieldTransitionListener<W>> perMethodFieldTransitionsListener = HashMultimap.create();
    protected Multimap<ControlFlowGraph.Edge, Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>>> perStatementFieldTransitions = HashMultimap.create();
    private Multimap<ControlFlowGraph.Edge, ControlFlowEdgeBasedFieldTransitionListener<W>> perStatementFieldTransitionsListener = HashMultimap.create();
    private HashBasedTable<ControlFlowGraph.Edge, Transition<ControlFlowGraph.Edge, INode<Val>>, W> perStatementCallTransitions = HashBasedTable.create();
    private Multimap<ControlFlowGraph.Edge, ControlFlowEdgeBasedCallTransitionListener<W>> perStatementCallTransitionsListener = HashMultimap.create();
    private Multimap<Method, UnbalancedDataFlow<W>> unbalancedDataFlows = HashMultimap.create();
    private Multimap<Method, UnbalancedDataFlowListener> unbalancedDataFlowListeners = HashMultimap.create();
    protected final DataFlowScope dataFlowScope;
    protected final BoomerangOptions options;
    protected final Type type;

    public AbstractBoomerangSolver(ObservableICFG<Statement, Method> icfg, ObservableControlFlowGraph cfg, Map<Map.Entry<INode<Node<ControlFlowGraph.Edge, Val>>, Field>, INode<Node<ControlFlowGraph.Edge, Val>>> genField, BoomerangOptions options, NestedWeightedPAutomatons<ControlFlowGraph.Edge, INode<Val>, W> callSummaries, NestedWeightedPAutomatons<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> fieldSummaries, DataFlowScope scope, Type propagationType) {
        super(icfg instanceof BackwardsObservableICFG ? false : options.callSummaries(), callSummaries, options.fieldSummaries(), fieldSummaries, options.maxCallDepth(), options.maxFieldDepth(), options.maxUnbalancedCallDepth());
        this.options = options;
        this.icfg = icfg;
        this.cfg = cfg;
        this.dataFlowScope = scope;
        this.type = propagationType;
        this.fieldAutomaton.registerListener((t, w, aut) -> {
            this.addTransitionToMethod(((ControlFlowGraph.Edge)((Node)((INode)t.getStart()).fact()).stmt()).getStart().getMethod(), (Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>>)t);
            this.addTransitionToMethod(((ControlFlowGraph.Edge)((Node)((INode)t.getTarget()).fact()).stmt()).getStart().getMethod(), (Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>>)t);
            this.addTransitionToStatement((ControlFlowGraph.Edge)((Node)((INode)t.getStart()).fact()).stmt(), (Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>>)t);
        });
        this.callAutomaton.registerListener((t, w, aut) -> this.addCallTransitionToStatement((ControlFlowGraph.Edge)t.getLabel(), (Transition<ControlFlowGraph.Edge, INode<Val>>)t, w));
        this.callAutomaton.registerListener((WPAUpdateListener)new UnbalancedListener());
        this.generatedFieldState = genField;
    }

    public boolean reachesNodeWithEmptyField(Node<ControlFlowGraph.Edge, Val> node) {
        for (Transition t : this.getFieldAutomaton().getTransitions()) {
            if (t.getStart() instanceof GeneratedState || !((Node)((INode)t.getStart()).fact()).equals(node) || !((Field)t.getLabel()).equals((Object)Field.empty())) continue;
            return true;
        }
        return false;
    }

    public INode<Node<ControlFlowGraph.Edge, Val>> createQueryNodeField(Query query) {
        return new SingleNode((Object)new Node((Object)query.cfgEdge(), (Object)((Val)query.asNode().fact()).asUnbalanced(query.cfgEdge())));
    }

    public void synchedEmptyStackReachable(Node<ControlFlowGraph.Edge, Val> sourceNode, final EmptyStackWitnessListener<ControlFlowGraph.Edge, Val> listener) {
        this.synchedReachable(sourceNode, new WitnessListener<ControlFlowGraph.Edge, Val, Field>(){
            Multimap<Val, Node<ControlFlowGraph.Edge, Val>> potentialFieldCandidate = HashMultimap.create();
            Set<Val> potentialCallCandidate = Sets.newHashSet();

            public void fieldWitness(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t) {
                if (t.getTarget() instanceof GeneratedState) {
                    return;
                }
                if (!((Field)t.getLabel()).equals((Object)AbstractBoomerangSolver.this.emptyField())) {
                    return;
                }
                Node targetFact = new Node((Object)((ControlFlowGraph.Edge)((Node)((INode)t.getTarget()).fact()).stmt()), (Object)((Val)((Node)((INode)t.getTarget()).fact()).fact()).asUnbalanced(null));
                if (!this.potentialFieldCandidate.put((Object)((Val)targetFact.fact()), (Object)targetFact)) {
                    return;
                }
                if (this.potentialCallCandidate.contains(targetFact.fact())) {
                    listener.witnessFound(targetFact);
                }
            }

            public void callWitness(Transition<ControlFlowGraph.Edge, INode<Val>> t) {
                Val targetFact = (Val)((INode)t.getTarget()).fact();
                if (targetFact instanceof AllocVal) {
                    if (!this.potentialCallCandidate.add(targetFact = ((AllocVal)targetFact).getDelegate())) {
                        return;
                    }
                    if (this.potentialFieldCandidate.containsKey((Object)targetFact)) {
                        for (Node w : this.potentialFieldCandidate.get((Object)targetFact)) {
                            listener.witnessFound(w);
                        }
                    }
                }
            }
        });
    }

    public void synchedReachable(Node<ControlFlowGraph.Edge, Val> sourceNode, WitnessListener<ControlFlowGraph.Edge, Val, Field> listener) {
        this.registerListener(reachableNode -> {
            if (!reachableNode.equals((Object)sourceNode)) {
                return;
            }
            this.fieldAutomaton.registerListener((t, w, aut) -> {
                if (t.getStart() instanceof GeneratedState) {
                    return;
                }
                if (!((Node)((INode)t.getStart()).fact()).equals((Object)sourceNode)) {
                    return;
                }
                listener.fieldWitness(t);
            });
            this.callAutomaton.registerListener((t, w, aut) -> {
                if (t.getStart() instanceof GeneratedState) {
                    return;
                }
                if (!((Val)((INode)t.getStart()).fact()).equals(sourceNode.fact())) {
                    return;
                }
                if (!((ControlFlowGraph.Edge)t.getLabel()).equals(sourceNode.stmt())) {
                    return;
                }
                if (this.callAutomaton.isUnbalancedState((State)((INode)t.getTarget()))) {
                    listener.callWitness(t);
                }
            });
        });
    }

    public Table<ControlFlowGraph.Edge, Val, W> asEdgeValWeightTable() {
        HashBasedTable results = HashBasedTable.create();
        WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> callAut = this.getCallAutomaton();
        for (Map.Entry e : callAut.getTransitionsToFinalWeights().entrySet()) {
            Transition t = (Transition)e.getKey();
            Weight w = (Weight)e.getValue();
            if (((ControlFlowGraph.Edge)t.getLabel()).equals((Object)new ControlFlowGraph.Edge(Statement.epsilon(), Statement.epsilon())) || ((Val)((INode)t.getStart()).fact()).isLocal() && !((ControlFlowGraph.Edge)t.getLabel()).getMethod().equals(((Val)((INode)t.getStart()).fact()).m())) continue;
            results.put((Object)((ControlFlowGraph.Edge)t.getLabel()), (Object)((Val)((INode)t.getStart()).fact()), (Object)w);
        }
        return results;
    }

    public Table<Statement, Val, W> asStatementValWeightTable() {
        HashBasedTable results = HashBasedTable.create();
        WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> callAut = this.getCallAutomaton();
        for (Map.Entry e : callAut.getTransitionsToFinalWeights().entrySet()) {
            Transition t = (Transition)e.getKey();
            Weight w = (Weight)e.getValue();
            if (((ControlFlowGraph.Edge)t.getLabel()).equals((Object)new ControlFlowGraph.Edge(Statement.epsilon(), Statement.epsilon())) || ((Val)((INode)t.getStart()).fact()).isLocal() && !((ControlFlowGraph.Edge)t.getLabel()).getMethod().equals(((Val)((INode)t.getStart()).fact()).m())) continue;
            results.put((Object)((ControlFlowGraph.Edge)t.getLabel()).getStart(), (Object)((Val)((INode)t.getStart()).fact()), (Object)w);
        }
        return results;
    }

    protected void addPotentialUnbalancedFlow(final Method callee, final Transition<ControlFlowGraph.Edge, INode<Val>> trans, W weight) {
        if (this.unbalancedDataFlows.put((Object)callee, new UnbalancedDataFlow(callee, trans))) {
            ArrayList existingListeners = Lists.newArrayList((Iterable)this.unbalancedDataFlowListeners.get((Object)callee));
            for (UnbalancedDataFlowListener l : existingListeners) {
                this.propagateUnbalancedToCallSite(l.getCallSiteEdge(), trans);
            }
        }
        if (this.forceUnbalanced((INode<Val>)((INode)trans.getTarget()), this.callAutomaton.getUnbalancedStartOf((State)((INode)trans.getTarget())))) {
            this.icfg.addCallerListener(new CallerListener<Statement, Method>(){

                @Override
                public Method getObservedCallee() {
                    return callee;
                }

                @Override
                public void onCallerAdded(Statement n, Method m) {
                    AbstractBoomerangSolver.this.propagateUnbalancedToCallSite(n, (Transition<ControlFlowGraph.Edge, INode<Val>>)trans);
                }
            });
        }
    }

    protected boolean forceUnbalanced(INode<Val> iNode, Collection<INode<Val>> collection) {
        return false;
    }

    public void allowUnbalanced(Method callee, Statement callSite) {
        if (this.dataFlowScope.isExcluded(callee)) {
            return;
        }
        UnbalancedDataFlowListener l = new UnbalancedDataFlowListener(callee, callSite);
        if (this.unbalancedDataFlowListeners.put((Object)callee, (Object)l)) {
            LOGGER.trace("Allowing unbalanced propagation from {} to {} of {}", new Object[]{callee, callSite, this});
            for (UnbalancedDataFlow e : Lists.newArrayList((Iterable)this.unbalancedDataFlows.get((Object)callee))) {
                this.propagateUnbalancedToCallSite(callSite, e.getReturningTransition());
            }
        }
    }

    protected boolean isMatchingCallSiteCalleePair(Statement callSite, final Method method) {
        final HashSet callsitesOfCall = Sets.newHashSet();
        this.icfg.addCallerListener(new CallerListener<Statement, Method>(){

            @Override
            public Method getObservedCallee() {
                return method;
            }

            @Override
            public void onCallerAdded(Statement statement, Method method2) {
                callsitesOfCall.add(statement);
            }
        });
        return callsitesOfCall.contains(callSite);
    }

    protected abstract void propagateUnbalancedToCallSite(Statement var1, Transition<ControlFlowGraph.Edge, INode<Val>> var2);

    protected boolean preventCallTransitionAdd(Transition<ControlFlowGraph.Edge, INode<Val>> t, W weight) {
        return false;
    }

    public void addCallRule(Rule<ControlFlowGraph.Edge, INode<Val>, W> rule) {
        if (rule instanceof NormalRule && ((ControlFlowGraph.Edge)rule.getL1()).equals((Object)rule.getL2()) && ((INode)rule.getS1()).equals(rule.getS2())) {
            return;
        }
        super.addCallRule(rule);
    }

    public void addFieldRule(Rule<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> rule) {
        if (rule instanceof NormalRule && ((Field)rule.getL1()).equals((Object)rule.getL2()) && ((INode)rule.getS1()).equals(rule.getS2())) {
            return;
        }
        super.addFieldRule(rule);
    }

    private void addTransitionToMethod(Method method, Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t) {
        if (this.perMethodFieldTransitions.put((Object)method, t)) {
            for (MethodBasedFieldTransitionListener l : Lists.newArrayList((Iterable)this.perMethodFieldTransitionsListener.get((Object)method))) {
                l.onAddedTransition(t);
            }
        }
    }

    public void registerFieldTransitionListener(MethodBasedFieldTransitionListener<W> l) {
        if (this.perMethodFieldTransitionsListener.put((Object)l.getMethod(), l)) {
            for (Transition t : Lists.newArrayList((Iterable)this.perMethodFieldTransitions.get((Object)l.getMethod()))) {
                l.onAddedTransition((Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>>)t);
            }
        }
    }

    private void addTransitionToStatement(ControlFlowGraph.Edge s, Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t) {
        if (this.perStatementFieldTransitions.put((Object)s, t)) {
            for (ControlFlowEdgeBasedFieldTransitionListener l : Lists.newArrayList((Iterable)this.perStatementFieldTransitionsListener.get((Object)s))) {
                l.onAddedTransition(t);
            }
        }
    }

    public void registerStatementFieldTransitionListener(ControlFlowEdgeBasedFieldTransitionListener<W> l) {
        if (this.perStatementFieldTransitionsListener.put((Object)l.getCfgEdge(), l)) {
            for (Transition t : Lists.newArrayList((Iterable)this.perStatementFieldTransitions.get((Object)l.getCfgEdge()))) {
                l.onAddedTransition((Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>>)t);
            }
        }
    }

    private void addCallTransitionToStatement(ControlFlowGraph.Edge s, Transition<ControlFlowGraph.Edge, INode<Val>> t, W w) {
        block3: {
            block2: {
                Weight put = (Weight)this.perStatementCallTransitions.get((Object)s, t);
                if (put == null) break block2;
                Weight combineWith = put.combineWith(w);
                if (combineWith.equals(put)) break block3;
                this.perStatementCallTransitions.put((Object)s, t, (Object)combineWith);
                for (ControlFlowEdgeBasedCallTransitionListener l : Lists.newArrayList((Iterable)this.perStatementCallTransitionsListener.get((Object)s))) {
                    l.onAddedTransition(t, w);
                }
                break block3;
            }
            this.perStatementCallTransitions.put((Object)s, t, w);
            for (ControlFlowEdgeBasedCallTransitionListener l : Lists.newArrayList((Iterable)this.perStatementCallTransitionsListener.get((Object)s))) {
                l.onAddedTransition(t, w);
            }
        }
    }

    public void registerStatementCallTransitionListener(ControlFlowEdgeBasedCallTransitionListener<W> l) {
        if (this.perStatementCallTransitionsListener.put((Object)l.getControlFlowEdge(), l)) {
            Map row = this.perStatementCallTransitions.row((Object)l.getControlFlowEdge());
            for (Map.Entry t : Lists.newArrayList(row.entrySet())) {
                l.onAddedTransition((Transition<ControlFlowGraph.Edge, INode<Val>>)((Transition)t.getKey()), (Weight)t.getValue());
            }
        }
    }

    public INode<Node<ControlFlowGraph.Edge, Val>> generateFieldState(INode<Node<ControlFlowGraph.Edge, Val>> d, Field loc) {
        AbstractMap.SimpleEntry<INode<Node<ControlFlowGraph.Edge, Val>>, Field> e = new AbstractMap.SimpleEntry<INode<Node<ControlFlowGraph.Edge, Val>>, Field>(d, loc);
        if (!this.generatedFieldState.containsKey(e)) {
            this.generatedFieldState.put(e, (INode<Node<ControlFlowGraph.Edge, Val>>)new GeneratedState(d, (Object)loc));
        }
        return this.generatedFieldState.get(e);
    }

    private boolean isBackward() {
        return this instanceof BackwardBoomerangSolver;
    }

    protected abstract Collection<? extends State> computeReturnFlow(Method var1, Statement var2, Val var3);

    protected void returnFlow(Method method, Node<ControlFlowGraph.Edge, Val> currNode) {
        Val value = (Val)currNode.fact();
        Collection<State> outFlow = this.computeReturnFlow(method, ((ControlFlowGraph.Edge)currNode.stmt()).getTarget(), value);
        for (State s : outFlow) {
            this.propagate(currNode, s);
        }
    }

    protected abstract Collection<State> computeNormalFlow(Method var1, ControlFlowGraph.Edge var2, Val var3);

    public Field epsilonField() {
        return Field.epsilon();
    }

    public Field emptyField() {
        return Field.empty();
    }

    public ControlFlowGraph.Edge epsilonStmt() {
        return new ControlFlowGraph.Edge(Statement.epsilon(), Statement.epsilon());
    }

    public Field fieldWildCard() {
        return Field.wildcard();
    }

    public Field exclusionFieldWildCard(Field exclusion) {
        return Field.exclusionWildcard((Field)exclusion);
    }

    public WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> getFieldAutomaton() {
        return this.fieldAutomaton;
    }

    public WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> getCallAutomaton() {
        return this.callAutomaton;
    }

    public WeightedPushdownSystem<ControlFlowGraph.Edge, INode<Val>, W> getCallPDS() {
        return this.callingPDS;
    }

    public WeightedPushdownSystem<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> getFieldPDS() {
        return this.fieldPDS;
    }

    public int getNumberOfRules() {
        return this.callingPDS.getAllRules().size() + this.fieldPDS.getAllRules().size();
    }

    protected boolean preventFieldTransitionAdd(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W weight) {
        Type targetVal;
        if (((INode)t.getStart()).equals(t.getTarget()) && ((Field)t.getLabel()).equals((Object)Field.empty())) {
            LOGGER.warn("Prevented illegal edge addition of {}", t);
            return true;
        }
        if (!((Field)t.getLabel()).equals((Object)Field.empty()) || !this.options.typeCheck()) {
            return false;
        }
        if (t.getTarget() instanceof GeneratedState || t.getStart() instanceof GeneratedState) {
            return false;
        }
        Val target = (Val)((Node)((INode)t.getTarget()).fact()).fact();
        Val source = (Val)((Node)((INode)t.getStart()).fact()).fact();
        if (source.isStatic()) {
            return false;
        }
        Type sourceVal = source.getType();
        Type type = targetVal = this.isBackward() ? target.getType() : this.type;
        if (sourceVal == null) {
            return true;
        }
        if (sourceVal.equals(targetVal)) {
            return false;
        }
        if (!targetVal.isRefType() || !sourceVal.isRefType()) {
            return this.options.killNullAtCast() && targetVal.isNullType() && this.isCastNode((Node<ControlFlowGraph.Edge, Val>)((Node)((INode)t.getStart()).fact()));
        }
        return sourceVal.doesCastFail(targetVal, target);
    }

    private boolean isCastNode(Node<ControlFlowGraph.Edge, Val> node) {
        Val rightOp;
        boolean isCast = ((ControlFlowGraph.Edge)node.stmt()).getStart().isCast();
        return isCast && (rightOp = ((ControlFlowGraph.Edge)node.stmt()).getStart().getRightOp()).isCast() && rightOp.getCastOp().equals(node.fact());
    }

    public Map<RegExAccessPath, W> getResultsAt(Statement stmt) {
        HashMap results = Maps.newHashMap();
        this.fieldAutomaton.registerListener((t, w, aut) -> {
            if (t.getStart() instanceof GeneratedState) {
                return;
            }
            if (((ControlFlowGraph.Edge)((Node)((INode)t.getStart()).fact()).stmt()).equals((Object)stmt)) {
                for (INode initState : this.fieldAutomaton.getInitialStates()) {
                    IRegEx regEx = this.fieldAutomaton.toRegEx((State)((INode)t.getStart()), (State)initState);
                    results.put(new RegExAccessPath((Val)((Node)((INode)t.getStart()).fact()).fact(), (IRegEx<Field>)regEx), w);
                }
            }
        });
        return results;
    }

    public Table<ControlFlowGraph.Edge, RegExAccessPath, W> getResults(Method m) {
        HashBasedTable results = HashBasedTable.create();
        LOGGER.debug("Start extracting results from {}", (Object)this);
        this.fieldAutomaton.registerListener((arg_0, arg_1, arg_2) -> this.lambda$getResults$7(m, (Table)results, arg_0, arg_1, arg_2));
        LOGGER.debug("End extracted results from {}", (Object)this);
        return results;
    }

    public void debugFieldAutomaton(Statement stmt) {
        this.fieldAutomaton.registerListener((t, w, aut) -> {
            if (t.getStart() instanceof GeneratedState) {
                return;
            }
            if (((ControlFlowGraph.Edge)((Node)((INode)t.getStart()).fact()).stmt()).equals((Object)stmt)) {
                for (INode initState : this.fieldAutomaton.getInitialStates()) {
                    IRegEx regEx = this.fieldAutomaton.toRegEx((State)((INode)t.getStart()), (State)initState);
                    LOGGER.debug(((Node)((INode)t.getStart()).fact()).fact() + " " + regEx);
                }
            }
        });
    }

    public void unregisterAllListeners() {
        this.callAutomaton.unregisterAllListeners();
        this.fieldAutomaton.unregisterAllListeners();
        this.perMethodFieldTransitionsListener.clear();
        this.perStatementCallTransitionsListener.clear();
        this.perStatementFieldTransitionsListener.clear();
        this.unbalancedDataFlowListeners.clear();
        this.unbalancedDataFlows.clear();
        this.callingPDS.unregisterAllListeners();
        this.fieldPDS.unregisterAllListeners();
    }

    private /* synthetic */ void lambda$getResults$7(Method m, Table results, Transition t, Weight w, WeightedPAutomaton aut) {
        if (t.getStart() instanceof GeneratedState) {
            return;
        }
        if (((ControlFlowGraph.Edge)((Node)((INode)t.getStart()).fact()).stmt()).getStart().getMethod().equals(m)) {
            for (INode initState : this.fieldAutomaton.getInitialStates()) {
                IRegEx regEx = this.fieldAutomaton.toRegEx((State)((INode)t.getStart()), (State)initState);
                this.callAutomaton.registerListener((callT, w1, aut1) -> {
                    if (((Val)((INode)callT.getStart()).fact()).equals(((Node)((INode)t.getStart()).fact()).fact()) && ((ControlFlowGraph.Edge)callT.getLabel()).equals(((Node)((INode)t.getStart()).fact()).stmt())) {
                        results.put((Object)((ControlFlowGraph.Edge)((Node)((INode)t.getStart()).fact()).stmt()), (Object)new RegExAccessPath((Val)((Node)((INode)t.getStart()).fact()).fact(), (IRegEx<Field>)regEx), (Object)w1);
                    }
                });
            }
        }
    }

    private static class UnbalancedDataFlowListener {
        private Method callee;
        private Statement callSite;

        public UnbalancedDataFlowListener(Method callee, Statement callSite) {
            this.callee = callee;
            this.callSite = callSite;
        }

        public Statement getCallSiteEdge() {
            return this.callSite;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.callee == null ? 0 : this.callee.hashCode());
            result = 31 * result + (this.callSite == null ? 0 : this.callSite.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnbalancedDataFlowListener other = (UnbalancedDataFlowListener)obj;
            if (this.callee == null ? other.callee != null : !this.callee.equals(other.callee)) {
                return false;
            }
            return !(this.callSite == null ? other.callSite != null : !this.callSite.equals((Object)other.callSite));
        }
    }

    private static class UnbalancedDataFlow<W> {
        private final Method callee;
        private Transition<ControlFlowGraph.Edge, INode<Val>> trans;

        public UnbalancedDataFlow(Method callee, Transition<ControlFlowGraph.Edge, INode<Val>> trans) {
            this.callee = callee;
            this.trans = trans;
        }

        public Transition<ControlFlowGraph.Edge, INode<Val>> getReturningTransition() {
            return this.trans;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.callee == null ? 0 : this.callee.hashCode());
            result = 31 * result + (this.trans == null ? 0 : this.trans.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnbalancedDataFlow other = (UnbalancedDataFlow)obj;
            if (this.callee == null ? other.callee != null : !this.callee.equals(other.callee)) {
                return false;
            }
            return !(this.trans == null ? other.trans != null : !this.trans.equals(other.trans));
        }
    }

    private class UnbalancedListener
    implements WPAUpdateListener<ControlFlowGraph.Edge, INode<Val>, W> {
        private UnbalancedListener() {
        }

        public void onWeightAdded(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w, WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> aut) {
            if (((ControlFlowGraph.Edge)t.getLabel()).equals((Object)new ControlFlowGraph.Edge(Statement.epsilon(), Statement.epsilon()))) {
                return;
            }
            if (AbstractBoomerangSolver.this.icfg.isExitStmt(AbstractBoomerangSolver.this instanceof ForwardBoomerangSolver ? ((ControlFlowGraph.Edge)t.getLabel()).getTarget() : ((ControlFlowGraph.Edge)t.getLabel()).getStart())) {
                Statement exitStmt = ((ControlFlowGraph.Edge)t.getLabel()).getTarget();
                Method callee = exitStmt.getMethod();
                if (AbstractBoomerangSolver.this.callAutomaton.getInitialStates().contains(t.getTarget())) {
                    AbstractBoomerangSolver.this.addPotentialUnbalancedFlow(callee, t, w);
                }
            }
        }
    }
}

