/*
 * Decompiled with CFR 0.152.
 */
package boomerang.results;

import boomerang.ForwardQuery;
import boomerang.Util;
import boomerang.callgraph.CallerListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.controlflowgraph.ObservableControlFlowGraph;
import boomerang.controlflowgraph.PredecessorListener;
import boomerang.results.AbstractBoomerangResults;
import boomerang.results.NullPointerDereference;
import boomerang.results.PathElement;
import boomerang.results.QueryResults;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.DeclaredMethod;
import boomerang.scene.Field;
import boomerang.scene.IfStatement;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.scene.jimple.JimpleVal;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.ForwardBoomerangSolver;
import boomerang.stats.IBoomerangStats;
import boomerang.util.DefaultValueMap;
import boomerang.weights.DataFlowPathWeight;
import boomerang.weights.PathConditionWeight;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Value;
import soot.jimple.IntConstant;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;

public class ForwardBoomerangResults<W extends Weight>
extends AbstractBoomerangResults<W> {
    private final ForwardQuery query;
    private final boolean timedout;
    private final IBoomerangStats<W> stats;
    private Stopwatch analysisWatch;
    private long maxMemory;
    private ObservableICFG<Statement, Method> icfg;
    private Set<Method> visitedMethods;
    private final boolean trackDataFlowPath;
    private final boolean pruneContradictoryDataFlowPath;
    private ObservableControlFlowGraph cfg;
    private boolean pruneImplictFlows;

    public ForwardBoomerangResults(ForwardQuery query, ObservableICFG<Statement, Method> icfg, ObservableControlFlowGraph cfg, boolean timedout, DefaultValueMap<ForwardQuery, ForwardBoomerangSolver<W>> queryToSolvers, IBoomerangStats<W> stats, Stopwatch analysisWatch, Set<Method> visitedMethods, boolean trackDataFlowPath, boolean pruneContradictoryDataFlowPath, boolean pruneImplictFlows) {
        super(queryToSolvers);
        this.query = query;
        this.icfg = icfg;
        this.cfg = cfg;
        this.timedout = timedout;
        this.stats = stats;
        this.analysisWatch = analysisWatch;
        this.visitedMethods = visitedMethods;
        this.trackDataFlowPath = trackDataFlowPath;
        this.pruneContradictoryDataFlowPath = pruneContradictoryDataFlowPath;
        this.pruneImplictFlows = pruneImplictFlows;
        stats.terminated(query, this);
        this.maxMemory = Util.getReallyUsedMemory();
    }

    public Stopwatch getAnalysisWatch() {
        return this.analysisWatch;
    }

    public boolean isTimedout() {
        return this.timedout;
    }

    public Table<ControlFlowGraph.Edge, Val, W> getObjectDestructingStatements() {
        AbstractBoomerangSolver solver = (AbstractBoomerangSolver)((Object)this.queryToSolvers.get(this.query));
        if (solver == null) {
            return HashBasedTable.create();
        }
        final Table<ControlFlowGraph.Edge, Val, W> res = this.asEdgeValWeightTable();
        final HashSet visitedMethods = Sets.newHashSet();
        for (ControlFlowGraph.Edge s : res.rowKeySet()) {
            visitedMethods.add(s.getMethod());
        }
        final ForwardBoomerangSolver forwardSolver = (ForwardBoomerangSolver)((Object)this.queryToSolvers.get(this.query));
        HashBasedTable destructingStatement = HashBasedTable.create();
        for (final Method flowReaches : visitedMethods) {
            for (final Statement exitStmt : this.icfg.getEndPointsOf(flowReaches)) {
                for (Statement predOfExit : exitStmt.getMethod().getControlFlowGraph().getPredsOf(exitStmt)) {
                    final ControlFlowGraph.Edge exitEdge = new ControlFlowGraph.Edge(predOfExit, exitStmt);
                    final HashSet escapes = Sets.newHashSet();
                    this.icfg.addCallerListener(new CallerListener<Statement, Method>(){

                        @Override
                        public Method getObservedCallee() {
                            return flowReaches;
                        }

                        @Override
                        public void onCallerAdded(Statement callSite, Method m) {
                            Method callee = callSite.getMethod();
                            if (visitedMethods.contains(callee)) {
                                for (Map.Entry valAndW : res.row((Object)exitEdge).entrySet()) {
                                    escapes.addAll(forwardSolver.computeReturnFlow(flowReaches, exitStmt, (Val)valAndW.getKey()));
                                }
                            }
                        }
                    });
                    if (!escapes.isEmpty()) continue;
                    Map row = res.row((Object)exitEdge);
                    this.findLastUsage(exitEdge, row, (Table<ControlFlowGraph.Edge, Val, W>)destructingStatement, forwardSolver);
                }
            }
        }
        return destructingStatement;
    }

    public Table<ControlFlowGraph.Edge, Val, W> asEdgeValWeightTable() {
        return this.asEdgeValWeightTable(this.query);
    }

    public Table<Statement, Val, W> asStatementValWeightTable() {
        return this.asStatementValWeightTable(this.query);
    }

    private void findLastUsage(ControlFlowGraph.Edge exitStmt, Map<Val, W> row, Table<ControlFlowGraph.Edge, Val, W> destructingStatement, ForwardBoomerangSolver<W> forwardSolver) {
        final LinkedList worklist = Lists.newLinkedList();
        worklist.add(exitStmt);
        HashSet visited = Sets.newHashSet();
        while (!worklist.isEmpty()) {
            final ControlFlowGraph.Edge curr = (ControlFlowGraph.Edge)worklist.poll();
            if (!visited.add(curr)) continue;
            boolean valueUsedInStmt = false;
            for (Map.Entry<Val, W> e : row.entrySet()) {
                if (!curr.getTarget().uses(e.getKey())) continue;
                destructingStatement.put((Object)curr, (Object)e.getKey(), (Object)((Weight)e.getValue()));
                valueUsedInStmt = true;
            }
            if (valueUsedInStmt || curr.getTarget().isIdentityStmt()) continue;
            this.cfg.addPredsOfListener(new PredecessorListener(curr.getStart()){

                @Override
                public void getPredecessor(Statement succ) {
                    worklist.add(new ControlFlowGraph.Edge(succ, curr.getStart()));
                }
            });
        }
    }

    public IBoomerangStats<W> getStats() {
        return this.stats;
    }

    public Map<ControlFlowGraph.Edge, DeclaredMethod> getInvokedMethodOnInstance() {
        HashMap invokedMethodsOnInstance = Maps.newHashMap();
        if (this.query.cfgEdge().getStart().containsInvokeExpr()) {
            invokedMethodsOnInstance.put(this.query.cfgEdge(), this.query.cfgEdge().getStart().getInvokeExpr().getMethod());
        }
        ((ForwardBoomerangSolver)((Object)this.queryToSolvers.get(this.query))).getFieldAutomaton().registerListener((t, w, aut) -> {
            Val base;
            if (!((Field)t.getLabel()).equals((Object)Field.empty()) || t.getStart() instanceof GeneratedState) {
                return;
            }
            Node node = (Node)((INode)t.getStart()).fact();
            Val fact = (Val)node.fact();
            ControlFlowGraph.Edge currEdge = (ControlFlowGraph.Edge)node.stmt();
            Statement curr = currEdge.getStart();
            if (curr.containsInvokeExpr() && curr.getInvokeExpr().isInstanceInvokeExpr() && (base = curr.getInvokeExpr().getBase()).equals((Object)fact)) {
                invokedMethodsOnInstance.put(currEdge, curr.getInvokeExpr().getMethod());
            }
        });
        return invokedMethodsOnInstance;
    }

    public Collection<Statement> getInvokeStatementsOnInstance() {
        HashSet<Statement> statements = new HashSet<Statement>();
        Map<ControlFlowGraph.Edge, DeclaredMethod> callsOnObject = this.getInvokedMethodOnInstance();
        for (ControlFlowGraph.Edge edge : callsOnObject.keySet()) {
            statements.add(edge.getStart());
        }
        return statements;
    }

    public QueryResults getPotentialNullPointerDereferences() {
        HashSet res = Sets.newHashSet();
        for (Object t : ((ForwardBoomerangSolver)((Object)this.queryToSolvers.get(this.query))).getFieldAutomaton().getTransitions()) {
            Node nullPointerNode;
            if (!((Field)t.getLabel()).equals((Object)Field.empty()) || t.getStart() instanceof GeneratedState || !NullPointerDereference.isNullPointerNode((Node<ControlFlowGraph.Edge, Val>)(nullPointerNode = (Node)((INode)t.getStart()).fact())) || !((ForwardBoomerangSolver)((Object)this.queryToSolvers.get(this.query))).getReachedStates().contains(nullPointerNode)) continue;
            res.add(nullPointerNode);
        }
        HashSet resWithContext = Sets.newHashSet();
        for (Node r : res) {
            Object dataFlowPath;
            if (this.trackDataFlowPath) {
                dataFlowPath = this.getDataFlowPathWeight(this.query, (Node<ControlFlowGraph.Edge, Val>)r);
                if (!this.isValidPath((DataFlowPathWeight)((Object)dataFlowPath))) continue;
                List<PathElement> p = this.transformPath(((DataFlowPathWeight)((Object)dataFlowPath)).getAllStatements(), (Node<ControlFlowGraph.Edge, Val>)r);
                resWithContext.add(new NullPointerDereference(this.query, (ControlFlowGraph.Edge)r.stmt(), (Val)r.fact(), null, null, p));
                continue;
            }
            dataFlowPath = Lists.newArrayList();
            resWithContext.add(new NullPointerDereference(this.query, (ControlFlowGraph.Edge)r.stmt(), (Val)r.fact(), null, null, (List<PathElement>)dataFlowPath));
        }
        QueryResults nullPointerResult = new QueryResults(this.query, resWithContext, this.visitedMethods, this.timedout);
        return nullPointerResult;
    }

    private boolean isValidPath(DataFlowPathWeight dataFlowPath) {
        if (!this.pruneContradictoryDataFlowPath) {
            return true;
        }
        Map<Statement, PathConditionWeight.ConditionDomain> conditions = dataFlowPath.getConditions();
        for (Map.Entry<Statement, PathConditionWeight.ConditionDomain> c : conditions.entrySet()) {
            if (!this.contradiction(c.getKey(), c.getValue(), dataFlowPath.getEvaluationMap())) continue;
            return false;
        }
        return true;
    }

    private DataFlowPathWeight getDataFlowPathWeight(ForwardQuery query, Node<ControlFlowGraph.Edge, Val> sinkLocation) {
        WeightedPAutomaton callAut = ((ForwardBoomerangSolver)((Object)this.queryToSolvers.getOrCreate(query))).getCallAutomaton();
        for (Map.Entry e : callAut.getTransitionsToFinalWeights().entrySet()) {
            Transition t = (Transition)e.getKey();
            if (((ControlFlowGraph.Edge)t.getLabel()).equals((Object)new ControlFlowGraph.Edge(Statement.epsilon(), Statement.epsilon())) || ((Val)((INode)t.getStart()).fact()).isLocal() && !((ControlFlowGraph.Edge)t.getLabel()).getMethod().equals(((Val)((INode)t.getStart()).fact()).m()) || !((Val)((INode)t.getStart()).fact()).equals(sinkLocation.fact()) || !((ControlFlowGraph.Edge)t.getLabel()).equals(sinkLocation.stmt()) || !(e.getValue() instanceof DataFlowPathWeight)) continue;
            DataFlowPathWeight v = (DataFlowPathWeight)((Object)e.getValue());
            return v;
        }
        return null;
    }

    private boolean contradiction(Statement ifStmt, PathConditionWeight.ConditionDomain mustBeVal, Map<Val, PathConditionWeight.ConditionDomain> evaluationMap) {
        if (ifStmt.isIfStmt()) {
            IfStatement ifStmt1 = ifStmt.getIfStmt();
            for (Transition transition : ((ForwardBoomerangSolver)((Object)this.queryToSolvers.get(this.query))).getFieldAutomaton().getTransitions()) {
                if (!((ControlFlowGraph.Edge)((Node)((INode)transition.getStart()).fact()).stmt()).equals((Object)ifStmt) || !((Field)transition.getLabel()).equals((Object)Field.empty()) || transition.getStart() instanceof GeneratedState) continue;
                Node node = (Node)((INode)transition.getStart()).fact();
                Val fact = (Val)node.fact();
                switch (ifStmt1.evaluate(fact)) {
                    case TRUE: {
                        if (!mustBeVal.equals((Object)PathConditionWeight.ConditionDomain.FALSE)) break;
                        return true;
                    }
                    case FALSE: {
                        if (!mustBeVal.equals((Object)PathConditionWeight.ConditionDomain.TRUE)) break;
                        return true;
                    }
                }
            }
            if (this.pruneImplictFlows) {
                for (Map.Entry entry : evaluationMap.entrySet()) {
                    if (!ifStmt1.uses((Val)entry.getKey())) continue;
                    IfStatement.Evaluation eval = null;
                    if (((PathConditionWeight.ConditionDomain)((Object)entry.getValue())).equals((Object)PathConditionWeight.ConditionDomain.TRUE)) {
                        eval = ifStmt1.evaluate((Val)new JimpleVal((Value)IntConstant.v((int)1), ((Val)entry.getKey()).m()));
                    } else if (((PathConditionWeight.ConditionDomain)((Object)entry.getValue())).equals((Object)PathConditionWeight.ConditionDomain.FALSE)) {
                        eval = ifStmt1.evaluate((Val)new JimpleVal((Value)IntConstant.v((int)0), ((Val)entry.getKey()).m()));
                    }
                    if (eval == null || !(mustBeVal.equals((Object)PathConditionWeight.ConditionDomain.FALSE) ? eval.equals((Object)IfStatement.Evaluation.FALSE) : mustBeVal.equals((Object)PathConditionWeight.ConditionDomain.TRUE) && eval.equals((Object)IfStatement.Evaluation.TRUE))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private List<PathElement> transformPath(List<Node<ControlFlowGraph.Edge, Val>> allStatements, Node<ControlFlowGraph.Edge, Val> sinkLocation) {
        ArrayList res = Lists.newArrayList();
        int index = 0;
        for (Node<ControlFlowGraph.Edge, Val> x : allStatements) {
            res.add(new PathElement((ControlFlowGraph.Edge)x.stmt(), (Val)x.fact(), index++));
        }
        if (!allStatements.contains(sinkLocation)) {
            res.add(new PathElement((ControlFlowGraph.Edge)sinkLocation.stmt(), (Val)sinkLocation.fact(), index));
        }
        for (PathElement n : res) {
            this.LOGGER.trace("Statement: {}, Variable {}, Index {}", new Object[]{n.getEdge(), n.getVariable(), n.stepIndex()});
        }
        return res;
    }

    public AbstractBoomerangResults.Context getContext(Node<ControlFlowGraph.Edge, Val> node) {
        return this.constructContextGraph(this.query, node);
    }

    public boolean containsCallRecursion() {
        for (Map.Entry e : this.queryToSolvers.entrySet()) {
            if (!((ForwardBoomerangSolver)((Object)e.getValue())).getCallAutomaton().containsLoop()) continue;
            return true;
        }
        return false;
    }

    public boolean containsFieldLoop() {
        for (Map.Entry e : this.queryToSolvers.entrySet()) {
            if (!((ForwardBoomerangSolver)((Object)e.getValue())).getFieldAutomaton().containsLoop()) continue;
            return true;
        }
        return false;
    }

    public Set<Method> getVisitedMethods() {
        return this.visitedMethods;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }
}

