/*
 * Decompiled with CFR 0.152.
 */
package boomerang.results;

import boomerang.ForwardQuery;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.ForwardBoomerangSolver;
import boomerang.util.DefaultValueMap;
import com.google.common.collect.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.PAutomaton;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;

public class AbstractBoomerangResults<W extends Weight> {
    protected final DefaultValueMap<ForwardQuery, ForwardBoomerangSolver<W>> queryToSolvers;
    protected final Logger LOGGER = LoggerFactory.getLogger(AbstractBoomerangResults.class);

    public AbstractBoomerangResults(DefaultValueMap<ForwardQuery, ForwardBoomerangSolver<W>> solverMap) {
        this.queryToSolvers = solverMap;
    }

    protected Context constructContextGraph(ForwardQuery forwardQuery, Node<ControlFlowGraph.Edge, Val> targetFact) {
        Context context = new Context(targetFact, forwardQuery);
        AbstractBoomerangSolver forwardSolver = this.queryToSolvers.get(forwardQuery);
        this.computeUnmatchedOpeningContext(context, forwardSolver, targetFact);
        this.computeUnmatchedClosingContext(context, forwardSolver);
        return context;
    }

    public void computeUnmatchedClosingContext(Context context, AbstractBoomerangSolver<W> forwardSolver) {
        for (Transition t : forwardSolver.getCallAutomaton().getTransitions()) {
            if (!((Val)((INode)t.getTarget()).fact()).isUnbalanced()) continue;
            INode v = (INode)t.getTarget();
            forwardSolver.getCallAutomaton().registerListener(new ClosingCallStackExtracter<W>((INode<Val>)v, (INode<Val>)v, context, forwardSolver));
        }
    }

    public void computeUnmatchedOpeningContext(Context context, AbstractBoomerangSolver<W> forwardSolver, Node<ControlFlowGraph.Edge, Val> node) {
        SingleNode initialState = new SingleNode((Object)((Val)node.fact()));
        forwardSolver.getCallAutomaton().registerListener(new OpeningCallStackExtracter<W>((INode<Val>)initialState, (INode<Val>)initialState, context, forwardSolver));
    }

    public Table<ControlFlowGraph.Edge, Val, W> asEdgeValWeightTable(ForwardQuery query) {
        return this.queryToSolvers.getOrCreate(query).asEdgeValWeightTable();
    }

    public Table<Statement, Val, W> asStatementValWeightTable(ForwardQuery query) {
        return this.queryToSolvers.getOrCreate(query).asStatementValWeightTable();
    }

    public static class Context {
        final Node<ControlFlowGraph.Edge, Val> node;
        private final PAutomaton<ControlFlowGraph.Edge, INode<Val>> openingContext;
        private final PAutomaton<ControlFlowGraph.Edge, INode<Val>> closingContext;

        public Context(Node<ControlFlowGraph.Edge, Val> node, ForwardQuery forwardQuery) {
            this.node = node;
            this.openingContext = new PAutomaton<ControlFlowGraph.Edge, INode<Val>>(){

                public INode<Val> createState(INode<Val> d, ControlFlowGraph.Edge loc) {
                    throw new RuntimeException("Not implemented");
                }

                public boolean isGeneratedState(INode<Val> d) {
                    throw new RuntimeException("Not implemented");
                }

                public ControlFlowGraph.Edge epsilon() {
                    return new ControlFlowGraph.Edge(Statement.epsilon(), Statement.epsilon());
                }
            };
            this.closingContext = new PAutomaton<ControlFlowGraph.Edge, INode<Val>>(){

                public INode<Val> createState(INode<Val> d, ControlFlowGraph.Edge loc) {
                    throw new RuntimeException("Not implemented");
                }

                public boolean isGeneratedState(INode<Val> d) {
                    throw new RuntimeException("Not implemented");
                }

                public ControlFlowGraph.Edge epsilon() {
                    return new ControlFlowGraph.Edge(Statement.epsilon(), Statement.epsilon());
                }
            };
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.closingContext == null ? 0 : this.closingContext.hashCode());
            result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
            result = 31 * result + (this.openingContext == null ? 0 : this.openingContext.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Context other = (Context)obj;
            return !(this.node == null ? other.node != null : !this.node.equals(other.node));
        }

        public PAutomaton<ControlFlowGraph.Edge, INode<Val>> getOpeningContext() {
            return this.openingContext;
        }

        public PAutomaton<ControlFlowGraph.Edge, INode<Val>> getClosingContext() {
            return this.closingContext;
        }
    }

    private static class ClosingCallStackExtracter<W extends Weight>
    extends WPAStateListener<ControlFlowGraph.Edge, INode<Val>, W> {
        private AbstractBoomerangSolver<W> solver;
        private INode<Val> source;
        private Context context;

        public ClosingCallStackExtracter(INode<Val> state, INode<Val> source, Context context, AbstractBoomerangSolver<W> solver) {
            super(state);
            this.source = source;
            this.context = context;
            this.solver = solver;
        }

        public void onOutTransitionAdded(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w, WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> weightedPAutomaton) {
        }

        public void onInTransitionAdded(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w, WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> weightedPAutomaton) {
            if (weightedPAutomaton.isUnbalancedState((State)((INode)t.getStart())) && !((Val)((INode)t.getStart()).fact()).isStatic()) {
                this.context.getClosingContext().addTransition(t);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
            result = 31 * result + (this.solver == null ? 0 : ((Object)this.solver).hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            ClosingCallStackExtracter other = (ClosingCallStackExtracter)((Object)obj);
            if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
                return false;
            }
            if (this.solver == null ? other.solver != null : !((Object)this.solver).equals(other.solver)) {
                return false;
            }
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }
    }

    private static class OpeningCallStackExtracter<W extends Weight>
    extends WPAStateListener<ControlFlowGraph.Edge, INode<Val>, W> {
        private AbstractBoomerangSolver<W> solver;
        private INode<Val> source;
        private Context context;

        public OpeningCallStackExtracter(INode<Val> state, INode<Val> source, Context context, AbstractBoomerangSolver<W> solver) {
            super(state);
            this.source = source;
            this.context = context;
            this.solver = solver;
        }

        public void onOutTransitionAdded(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w, WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> weightedPAutomaton) {
            if (weightedPAutomaton.getInitialStates().contains(t.getTarget())) {
                return;
            }
            if (((ControlFlowGraph.Edge)t.getLabel()).getMethod() != null) {
                if (t.getStart() instanceof GeneratedState) {
                    this.context.getOpeningContext().addTransition(new Transition(this.source, (Location)((ControlFlowGraph.Edge)t.getLabel()), (State)((INode)t.getTarget())));
                } else {
                    weightedPAutomaton.registerListener(new OpeningCallStackExtracter<W>((INode<Val>)((INode)t.getTarget()), this.source, this.context, this.solver));
                    return;
                }
            }
            weightedPAutomaton.registerListener(new OpeningCallStackExtracter<W>((INode<Val>)((INode)t.getTarget()), (INode<Val>)((INode)t.getTarget()), this.context, this.solver));
        }

        public void onInTransitionAdded(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w, WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> weightedPAutomaton) {
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
            result = 31 * result + (this.solver == null ? 0 : ((Object)this.solver).hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            OpeningCallStackExtracter other = (OpeningCallStackExtracter)((Object)obj);
            if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
                return false;
            }
            if (this.solver == null ? other.solver != null : !((Object)this.solver).equals(other.solver)) {
                return false;
            }
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }
    }
}

