/*
 * Decompiled with CFR 0.152.
 */
package boomerang.poi;

import boomerang.poi.AbstractPOI;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Field;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.ControlFlowEdgeBasedCallTransitionListener;
import boomerang.solver.ControlFlowEdgeBasedFieldTransitionListener;
import boomerang.solver.ForwardBoomerangSolver;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;
import wpds.interfaces.WPAUpdateListener;

public abstract class ExecuteImportFieldStmtPOI<W extends Weight> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecuteImportFieldStmtPOI.class);
    private static final int MAX_IMPORT_DEPTH = -1;
    private Set<INode<Node<ControlFlowGraph.Edge, Val>>> reachable = Sets.newHashSet();
    private Multimap<INode<Node<ControlFlowGraph.Edge, Val>>, InsertFieldTransitionCallback> delayedTransitions = HashMultimap.create();
    protected final ForwardBoomerangSolver<W> baseSolver;
    protected final ForwardBoomerangSolver<W> flowSolver;
    protected final ControlFlowGraph.Edge curr;
    protected final WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> baseAutomaton;
    protected final WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> flowAutomaton;
    private final Val baseVar;
    private final Val storedVar;
    private final Field field;
    boolean active = false;

    public ExecuteImportFieldStmtPOI(ForwardBoomerangSolver<W> baseSolver, ForwardBoomerangSolver<W> flowSolver, AbstractPOI<ControlFlowGraph.Edge, Val, Field> poi) {
        this.baseSolver = baseSolver;
        this.flowSolver = flowSolver;
        this.baseAutomaton = baseSolver.getFieldAutomaton();
        this.flowAutomaton = flowSolver.getFieldAutomaton();
        this.curr = poi.getCfgEdge();
        this.baseVar = poi.getBaseVar();
        this.storedVar = poi.getStoredVar();
        this.field = poi.getField();
    }

    private boolean isLogEnabled() {
        return true;
    }

    public void solve() {
        if (((Object)this.baseSolver).equals(this.flowSolver)) {
            return;
        }
        this.baseSolver.registerStatementFieldTransitionListener(new BaseVarPointsTo(this.curr, this));
    }

    protected void flowsTo() {
        if (this.active) {
            return;
        }
        this.active = true;
        if (this.isLogEnabled()) {
            LOGGER.trace("POI: Propagation of {} flows to {}", this.baseSolver, this.flowSolver);
        }
        this.handlingAtFieldStatements();
        this.handlingAtCallSites();
    }

    private void handlingAtFieldStatements() {
        this.baseSolver.registerStatementFieldTransitionListener(new ImportIndirectAliases(this.curr, this.flowSolver, this.baseSolver));
        this.flowSolver.registerStatementCallTransitionListener(new ImportIndirectCallAliases(this.curr, this.flowSolver));
    }

    private void handlingAtCallSites() {
        this.flowSolver.getCallAutomaton().registerListener((WPAUpdateListener)new ForAnyCallSiteOrExitStmt(this.baseSolver));
    }

    protected void importFieldTransitionsStartingAt(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, int importDepth) {
        if (((Field)t.getLabel()).equals((Object)Field.epsilon())) {
            return;
        }
        if (((Field)t.getLabel()).equals((Object)Field.empty())) {
            if (this.isLogEnabled()) {
                LOGGER.trace("Activating with {}", (Object)t.getStart());
            }
            if (this.baseSolver.getFieldAutomaton().isUnbalancedState((State)((INode)t.getTarget()))) {
                this.activate((INode<Node<ControlFlowGraph.Edge, Val>>)((INode)t.getStart()));
            }
        } else if (t.getTarget() instanceof GeneratedState) {
            if (this.isLogEnabled()) {
                LOGGER.trace("Copying {} into Field Automaton {}", t, this.flowSolver);
            }
            this.queueOrAdd(t);
            int newDepth = importDepth + 1;
            this.baseSolver.getFieldAutomaton().registerListener((WPAStateListener)new ImportFieldTransitionsFrom((INode<Node<ControlFlowGraph.Edge, Val>>)((INode)t.getTarget()), this.flowSolver, newDepth));
        }
    }

    public void addReachable(INode<Node<ControlFlowGraph.Edge, Val>> node) {
        if (this.reachable.add(node)) {
            for (InsertFieldTransitionCallback callback : Lists.newArrayList((Iterable)this.delayedTransitions.get(node))) {
                callback.trigger();
            }
        }
    }

    private void queueOrAdd(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> transToInsert) {
        if (this.reachable.contains(transToInsert.getTarget())) {
            this.flowSolver.getFieldAutomaton().addTransition(transToInsert);
            this.addReachable((INode<Node<ControlFlowGraph.Edge, Val>>)((INode)transToInsert.getStart()));
        } else {
            this.delayedTransitions.put((Object)((INode)transToInsert.getTarget()), (Object)new InsertFieldTransitionCallback(transToInsert));
        }
    }

    public abstract void activate(INode<Node<ControlFlowGraph.Edge, Val>> var1);

    public void trigger(INode<Node<ControlFlowGraph.Edge, Val>> start) {
        INode intermediateState = (INode)this.flowSolver.getFieldAutomaton().createState((State)new SingleNode((Object)new Node((Object)this.curr, (Object)this.baseVar)), (Location)this.field);
        Transition connectingTrans = new Transition(start, (Location)this.field, (State)intermediateState);
        if (this.isLogEnabled()) {
            LOGGER.trace("Connecting {} into Field Automaton {}", (Object)connectingTrans, this.flowSolver);
        }
        this.flowSolver.getFieldAutomaton().addTransition(connectingTrans);
        this.addReachable((INode<Node<ControlFlowGraph.Edge, Val>>)((INode)connectingTrans.getStart()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseSolver == null ? 0 : ((Object)this.baseSolver).hashCode());
        result = 31 * result + (this.flowSolver == null ? 0 : ((Object)this.flowSolver).hashCode());
        result = 31 * result + (this.curr == null ? 0 : this.curr.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecuteImportFieldStmtPOI other = (ExecuteImportFieldStmtPOI)obj;
        if (this.baseSolver == null ? other.baseSolver != null : !((Object)this.baseSolver).equals(other.baseSolver)) {
            return false;
        }
        if (this.flowSolver == null ? other.flowSolver != null : !((Object)this.flowSolver).equals(other.flowSolver)) {
            return false;
        }
        return !(this.curr == null ? other.curr != null : !this.curr.equals((Object)other.curr));
    }

    private class InsertFieldTransitionCallback {
        private final Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> trans;

        public InsertFieldTransitionCallback(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> trans) {
            this.trans = trans;
        }

        public void trigger() {
            ExecuteImportFieldStmtPOI.this.flowSolver.getFieldAutomaton().addTransition(this.trans);
            ExecuteImportFieldStmtPOI.this.addReachable((INode<Node<ControlFlowGraph.Edge, Val>>)((INode)this.trans.getStart()));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.trans == null ? 0 : this.trans.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InsertFieldTransitionCallback other = (InsertFieldTransitionCallback)obj;
            return !(this.trans == null ? other.trans != null : !this.trans.equals(other.trans));
        }
    }

    private final class ImportFieldTransitionsFrom
    extends WPAStateListener<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> {
        private AbstractBoomerangSolver<W> flowSolver;
        private int importDepth;

        public ImportFieldTransitionsFrom(INode<Node<ControlFlowGraph.Edge, Val>> target, AbstractBoomerangSolver<W> flowSolver, int importDepth) {
            super(target);
            this.flowSolver = flowSolver;
            this.importDepth = importDepth;
        }

        public void onOutTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
            if (((Field)t.getLabel()).equals((Object)Field.epsilon())) {
                return;
            }
            ExecuteImportFieldStmtPOI.this.importFieldTransitionsStartingAt(t, this.importDepth);
        }

        public void onInTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.flowSolver == null ? 0 : ((Object)((Object)this.flowSolver)).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            ImportFieldTransitionsFrom other = (ImportFieldTransitionsFrom)((Object)obj);
            return !(this.flowSolver == null ? other.flowSolver != null : !((Object)((Object)this.flowSolver)).equals((Object)other.flowSolver));
        }
    }

    private final class CallSiteOrExitStmtFieldImport
    extends ControlFlowEdgeBasedFieldTransitionListener<W> {
        private AbstractBoomerangSolver<W> flowSolver;
        private AbstractBoomerangSolver<W> baseSolver;
        private Val fact;

        private CallSiteOrExitStmtFieldImport(AbstractBoomerangSolver<W> flowSolver, AbstractBoomerangSolver<W> baseSolver, Node<ControlFlowGraph.Edge, Val> reachableNode) {
            super((ControlFlowGraph.Edge)reachableNode.stmt());
            this.flowSolver = flowSolver;
            this.baseSolver = baseSolver;
            this.fact = (Val)reachableNode.fact();
        }

        @Override
        public void onAddedTransition(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> innerT) {
            if (((Field)innerT.getLabel()).equals((Object)Field.epsilon())) {
                return;
            }
            if (!(innerT.getStart() instanceof GeneratedState) && ((Val)((Node)((INode)innerT.getStart()).fact()).fact()).equals((Object)this.fact)) {
                ExecuteImportFieldStmtPOI.this.importFieldTransitionsStartingAt(innerT, 0);
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.baseSolver == null ? 0 : ((Object)((Object)this.baseSolver)).hashCode());
            result = 31 * result + (this.flowSolver == null ? 0 : ((Object)((Object)this.flowSolver)).hashCode());
            result = 31 * result + (this.fact == null ? 0 : this.fact.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CallSiteOrExitStmtFieldImport other = (CallSiteOrExitStmtFieldImport)obj;
            if (this.baseSolver == null ? other.baseSolver != null : !((Object)((Object)this.baseSolver)).equals((Object)other.baseSolver)) {
                return false;
            }
            if (this.flowSolver == null ? other.flowSolver != null : !((Object)((Object)this.flowSolver)).equals((Object)other.flowSolver)) {
                return false;
            }
            return !(this.fact == null ? other.fact != null : !this.fact.equals((Object)other.fact));
        }
    }

    private final class ImportIndirectAliases
    extends ControlFlowEdgeBasedFieldTransitionListener<W> {
        private AbstractBoomerangSolver<W> flowSolver;
        private AbstractBoomerangSolver<W> baseSolver;

        public ImportIndirectAliases(ControlFlowGraph.Edge succ, AbstractBoomerangSolver<W> flowSolver, AbstractBoomerangSolver<W> baseSolver) {
            super(succ);
            this.flowSolver = flowSolver;
            this.baseSolver = baseSolver;
        }

        @Override
        public void onAddedTransition(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t) {
            if (((Field)t.getLabel()).equals((Object)Field.epsilon())) {
                return;
            }
            if (!(t.getStart() instanceof GeneratedState)) {
                ExecuteImportFieldStmtPOI.this.importFieldTransitionsStartingAt(t, 0);
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.baseSolver == null ? 0 : ((Object)((Object)this.baseSolver)).hashCode());
            result = 31 * result + (this.flowSolver == null ? 0 : ((Object)((Object)this.flowSolver)).hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImportIndirectAliases other = (ImportIndirectAliases)obj;
            if (this.baseSolver == null ? other.baseSolver != null : !((Object)((Object)this.baseSolver)).equals((Object)other.baseSolver)) {
                return false;
            }
            if (this.flowSolver == null) {
                return other.flowSolver == null;
            }
            return ((Object)((Object)this.flowSolver)).equals((Object)other.flowSolver);
        }
    }

    private static final class ImportIndirectCallAliasesAtSucc
    extends ControlFlowEdgeBasedCallTransitionListener<W> {
        private INode<Val> target;
        private W w;
        final /* synthetic */ ExecuteImportFieldStmtPOI this$0;

        public ImportIndirectCallAliasesAtSucc(ControlFlowGraph.Edge succ, INode<Val> target, W w) {
            this.this$0 = var1_1;
            super(succ);
            this.target = target;
            this.w = w;
        }

        @Override
        public void onAddedTransition(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w) {
            if (this.getControlFlowEdge().getStart().isFieldStore() && !((Val)this.getControlFlowEdge().getStart().getFieldStore().getX()).equals(((INode)t.getStart()).fact())) {
                this.this$0.flowSolver.getCallAutomaton().addWeightForTransition(new Transition((State)((INode)t.getStart()), (Location)((ControlFlowGraph.Edge)t.getLabel()), this.target), this.w);
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            result = 31 * result + (this.w == null ? 0 : this.w.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImportIndirectCallAliasesAtSucc other = (ImportIndirectCallAliasesAtSucc)obj;
            if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
                return false;
            }
            return !(this.w == null ? other.w != null : !this.w.equals(other.w));
        }
    }

    private final class ImportIndirectCallAliases
    extends ControlFlowEdgeBasedCallTransitionListener<W> {
        private AbstractBoomerangSolver<W> flowSolver;

        public ImportIndirectCallAliases(ControlFlowGraph.Edge stmt, AbstractBoomerangSolver<W> flowSolver) {
            super(stmt);
            this.flowSolver = flowSolver;
        }

        @Override
        public void onAddedTransition(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w) {
            if (((Val)((INode)t.getStart()).fact()).equals((Object)ExecuteImportFieldStmtPOI.this.storedVar)) {
                ExecuteImportFieldStmtPOI.this.baseSolver.registerStatementCallTransitionListener(new ImportIndirectCallAliasesAtSucc(ExecuteImportFieldStmtPOI.this, ExecuteImportFieldStmtPOI.this.curr, (INode)t.getTarget(), w));
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.flowSolver == null ? 0 : ((Object)((Object)this.flowSolver)).hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImportIndirectCallAliases other = (ImportIndirectCallAliases)obj;
            return !(this.flowSolver == null ? other.flowSolver != null : !((Object)((Object)this.flowSolver)).equals((Object)other.flowSolver));
        }
    }

    private class BaseVarPointsTo
    extends ControlFlowEdgeBasedFieldTransitionListener<W> {
        private ExecuteImportFieldStmtPOI<W> poi;

        public BaseVarPointsTo(ControlFlowGraph.Edge curr, ExecuteImportFieldStmtPOI<W> executeImportFieldStmtPOI2) {
            super(curr);
            this.poi = executeImportFieldStmtPOI2;
        }

        @Override
        public void onAddedTransition(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t) {
            Val alias;
            INode aliasedVariableAtStmt = (INode)t.getStart();
            if (ExecuteImportFieldStmtPOI.this.active) {
                return;
            }
            if (!(aliasedVariableAtStmt instanceof GeneratedState) && (alias = (Val)((Node)aliasedVariableAtStmt.fact()).fact()).equals((Object)this.poi.baseVar) && ((Field)t.getLabel()).equals((Object)Field.empty())) {
                ExecuteImportFieldStmtPOI.this.flowsTo();
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.poi == null ? 0 : this.poi.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BaseVarPointsTo other = (BaseVarPointsTo)obj;
            return !(this.poi == null ? other.poi != null : !this.poi.equals(other.poi));
        }
    }

    private class ForAnyCallSiteOrExitStmt
    implements WPAUpdateListener<ControlFlowGraph.Edge, INode<Val>, W> {
        private AbstractBoomerangSolver<W> baseSolver;

        public ForAnyCallSiteOrExitStmt(AbstractBoomerangSolver<W> baseSolver) {
            this.baseSolver = baseSolver;
        }

        public void onWeightAdded(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w, WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> aut) {
            if (!ExecuteImportFieldStmtPOI.this.flowSolver.getCallAutomaton().isUnbalancedState((State)((INode)t.getTarget()))) {
                return;
            }
            if (((ControlFlowGraph.Edge)t.getLabel()).equals((Object)new ControlFlowGraph.Edge(Statement.epsilon(), Statement.epsilon()))) {
                return;
            }
            ControlFlowGraph.Edge edge = (ControlFlowGraph.Edge)t.getLabel();
            Statement callSite = edge.getStart();
            if (callSite.containsInvokeExpr()) {
                if (callSite.isAssign() && callSite.getLeftOp().equals(((INode)t.getStart()).fact())) {
                    return;
                }
                if (callSite.uses((Val)((INode)t.getStart()).fact())) {
                    this.importSolvers(edge, (INode<Val>)((INode)t.getStart()), (INode<Val>)((INode)t.getTarget()), w);
                }
            }
        }

        private void importSolvers(ControlFlowGraph.Edge callSiteOrExitStmt, INode<Val> start, INode<Val> node, W w) {
            if (ExecuteImportFieldStmtPOI.this.isLogEnabled()) {
                LOGGER.trace("Importing solvers at {} from {} to {}", new Object[]{callSiteOrExitStmt, this.baseSolver, ExecuteImportFieldStmtPOI.this.flowSolver});
            }
            this.baseSolver.registerStatementCallTransitionListener(new ImportOnReachStatement(ExecuteImportFieldStmtPOI.this.flowSolver, callSiteOrExitStmt));
            this.baseSolver.registerStatementCallTransitionListener(new ImportTransitionFromCall(ExecuteImportFieldStmtPOI.this, ExecuteImportFieldStmtPOI.this.flowSolver, callSiteOrExitStmt, start, node, w));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.baseSolver == null ? 0 : ((Object)((Object)this.baseSolver)).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ForAnyCallSiteOrExitStmt other = (ForAnyCallSiteOrExitStmt)obj;
            return !(this.baseSolver == null ? other.baseSolver != null : !((Object)((Object)this.baseSolver)).equals((Object)other.baseSolver));
        }
    }

    private final class ImportOnReachStatement
    extends ControlFlowEdgeBasedCallTransitionListener<W> {
        private AbstractBoomerangSolver<W> flowSolver;

        private ImportOnReachStatement(AbstractBoomerangSolver<W> flowSolver, ControlFlowGraph.Edge callSiteOrExitStmt) {
            super(callSiteOrExitStmt);
            this.flowSolver = flowSolver;
        }

        @Override
        public void onAddedTransition(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w) {
            if (t.getStart() instanceof GeneratedState) {
                return;
            }
            if (((ControlFlowGraph.Edge)t.getLabel()).equals((Object)this.getControlFlowEdge())) {
                ExecuteImportFieldStmtPOI.this.baseSolver.registerStatementFieldTransitionListener(new CallSiteOrExitStmtFieldImport(this.flowSolver, ExecuteImportFieldStmtPOI.this.baseSolver, (Node<ControlFlowGraph.Edge, Val>)new Node((Object)((ControlFlowGraph.Edge)t.getLabel()), (Object)((Val)((INode)t.getStart()).fact()))));
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.flowSolver == null ? 0 : ((Object)((Object)this.flowSolver)).hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImportOnReachStatement other = (ImportOnReachStatement)obj;
            return !(this.flowSolver == null ? other.flowSolver != null : !((Object)((Object)this.flowSolver)).equals((Object)other.flowSolver));
        }
    }

    private static final class ImportTransitionFromCall
    extends ControlFlowEdgeBasedCallTransitionListener<W> {
        private final INode<Val> start;
        private AbstractBoomerangSolver<W> flowSolver;
        private INode<Val> target;
        private W w;
        final /* synthetic */ ExecuteImportFieldStmtPOI this$0;

        public ImportTransitionFromCall(AbstractBoomerangSolver<W> flowSolver, ControlFlowGraph.Edge stmt, INode<Val> start, INode<Val> target, W w) {
            this.this$0 = var1_1;
            super(stmt);
            this.start = start;
            this.flowSolver = flowSolver;
            this.target = target;
            this.w = w;
        }

        @Override
        public void onAddedTransition(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w) {
            if (t.getStart() instanceof GeneratedState) {
                return;
            }
            Transition newTrans = new Transition((State)((INode)t.getStart()), (Location)((ControlFlowGraph.Edge)t.getLabel()), this.target);
            if (this.this$0.isLogEnabled()) {
                LOGGER.trace("Copying {} to {}", (Object)newTrans, this.flowSolver);
            }
            if (!((INode)t.getStart()).equals(this.start) && ((Val)((INode)t.getStart()).fact()).m().equals(((ControlFlowGraph.Edge)t.getLabel()).getStart().getMethod())) {
                this.flowSolver.getCallAutomaton().addWeightForTransition(newTrans, this.w);
            }
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.flowSolver == null ? 0 : ((Object)((Object)this.flowSolver)).hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            result = 31 * result + (this.w == null ? 0 : this.w.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImportTransitionFromCall other = (ImportTransitionFromCall)obj;
            if (this.flowSolver == null ? other.flowSolver != null : !((Object)((Object)this.flowSolver)).equals((Object)other.flowSolver)) {
                return false;
            }
            if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
                return false;
            }
            return !(this.w == null ? other.w != null : !this.w.equals(other.w));
        }
    }
}

