/*
 * Decompiled with CFR 0.152.
 */
package boomerang.guided;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Specification {
    private static final String ON_SELECTOR = "ON";
    private static final String GO_SELECTOR = "GO";
    private static final String BACKWARD = "{B}";
    private static final String FORWARD = "{F}";
    private final Set<SootMethodWithSelector> methodAndQueries;

    private Specification(Collection<String> spec) {
        this.methodAndQueries = spec.stream().map(x -> this.parse((String)x)).collect(Collectors.toSet());
    }

    private SootMethodWithSelector parse(String input) {
        Pattern base;
        Matcher baseMatcher;
        Pattern arguments = Pattern.compile("\\((.*?)\\)");
        Matcher argumentMatcher = arguments.matcher(input);
        HashSet on = Sets.newHashSet();
        HashSet go = Sets.newHashSet();
        if (argumentMatcher.find()) {
            String group = argumentMatcher.group(1);
            String[] args = group.split(",");
            for (int i = 0; i < args.length; ++i) {
                this.createQuerySelector(args[i], Parameter.of(i), on, go);
            }
        }
        if ((baseMatcher = (base = Pattern.compile("<(.*?):")).matcher(input)).find()) {
            String group = baseMatcher.group(1);
            this.createQuerySelector(group, Parameter.base(), on, go);
        }
        String[] s = input.split(" ");
        this.createQuerySelector(s[1], Parameter.returnParam(), on, go);
        String sootMethod = input.replace(FORWARD, "").replace(BACKWARD, "").replace(ON_SELECTOR, "").replace(GO_SELECTOR, "");
        long backwardQueryCount = on.stream().filter(x -> x.direction == QueryDirection.BACKWARD).count() + go.stream().filter(x -> x.direction == QueryDirection.BACKWARD).count();
        long forwardQueryCount = on.stream().filter(x -> x.direction == QueryDirection.FORWARD).count() + go.stream().filter(x -> x.direction == QueryDirection.FORWARD).count();
        if ((long)input.length() != (long)sootMethod.length() + ((long)(on.size() * ON_SELECTOR.length() + go.size() * GO_SELECTOR.length()) + backwardQueryCount * (long)BACKWARD.length() + forwardQueryCount * (long)FORWARD.length())) {
            throw new RuntimeException("Parsing Specification failed. Please check your specification");
        }
        return new SootMethodWithSelector(sootMethod, on, go);
    }

    private void createQuerySelector(String arg, Parameter p, Set<QuerySelector> on, Set<QuerySelector> go) {
        if (arg.startsWith(ON_SELECTOR)) {
            on.add(new QuerySelector(arg.contains(FORWARD) ? QueryDirection.FORWARD : QueryDirection.BACKWARD, p));
        }
        if (arg.startsWith(GO_SELECTOR)) {
            go.add(new QuerySelector(arg.contains(FORWARD) ? QueryDirection.FORWARD : QueryDirection.BACKWARD, p));
        }
    }

    public static Specification loadFrom(String filePath) throws IOException {
        return new Specification(Files.lines(Paths.get(filePath, new String[0])).collect(Collectors.toSet()));
    }

    public static Specification create(String ... spec) {
        return new Specification(Sets.newHashSet((Object[])spec));
    }

    public Set<SootMethodWithSelector> getMethodAndQueries() {
        return this.methodAndQueries;
    }

    public class QuerySelector {
        QueryDirection direction;
        Parameter argumentSelection;

        QuerySelector(QueryDirection direction, Parameter argumentSelection) {
            this.direction = direction;
            this.argumentSelection = argumentSelection;
        }
    }

    public static class Parameter {
        private final int value;

        private Parameter(int newValue) {
            this.value = newValue;
        }

        public static Parameter returnParam() {
            return new Parameter(-2);
        }

        public static Parameter base() {
            return new Parameter(-1);
        }

        public static Parameter of(int integer) {
            if (integer < 0) {
                throw new RuntimeException("Parameter index must be > 0");
            }
            return new Parameter(integer);
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            return this.value == parameter.value;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value});
        }
    }

    public static class SootMethodWithSelector {
        private String sootMethod;
        private Collection<QuerySelector> on;
        private Collection<QuerySelector> go;

        SootMethodWithSelector(String sootMethod, Collection<QuerySelector> on, Collection<QuerySelector> go) {
            this.sootMethod = sootMethod;
            this.on = on;
            this.go = go;
        }

        public Collection<QuerySelector> getOn() {
            return this.on;
        }

        public Collection<QuerySelector> getGo() {
            return this.go;
        }

        public String getSootMethod() {
            return this.sootMethod;
        }
    }

    public static enum QueryDirection {
        FORWARD,
        BACKWARD;

    }
}

