/*
 * Decompiled with CFR 0.152.
 */
package boomerang.guided;

import boomerang.BackwardQuery;
import boomerang.Boomerang;
import boomerang.BoomerangOptions;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.QueryGraph;
import boomerang.guided.IDemandDrivenGuidedManager;
import boomerang.guided.Specification;
import boomerang.results.AbstractBoomerangResults;
import boomerang.results.BackwardBoomerangResults;
import boomerang.scene.CallGraph;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.DataFlowScope;
import boomerang.scene.SootDataFlowScope;
import boomerang.scene.Val;
import boomerang.scene.jimple.SootCallGraph;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import soot.Scene;
import sync.pds.solver.nodes.Node;
import wpds.impl.Weight;

public class DemandDrivenGuidedAnalysis {
    private final BoomerangOptions customBoomerangOptions;
    private final IDemandDrivenGuidedManager spec;
    private final DataFlowScope scope;
    private final SootCallGraph callGraph;
    private final LinkedList<QueryWithContext> queryQueue = Lists.newLinkedList();
    private final Set<Query> visited = Sets.newHashSet();
    private final Boomerang solver;
    private boolean triggered;

    public DemandDrivenGuidedAnalysis(IDemandDrivenGuidedManager specification, BoomerangOptions options, DataFlowScope dataFlowScope) {
        this.spec = specification;
        this.callGraph = new SootCallGraph();
        this.scope = dataFlowScope;
        if (!options.allowMultipleQueries()) {
            throw new RuntimeException("Boomerang options allowMultipleQueries is set to false. Please enable it.");
        }
        this.customBoomerangOptions = options;
        this.solver = new Boomerang((CallGraph)this.callGraph, this.scope, this.customBoomerangOptions);
    }

    public DemandDrivenGuidedAnalysis(IDemandDrivenGuidedManager specification, BoomerangOptions options) {
        this(specification, options, SootDataFlowScope.make((Scene)Scene.v()));
    }

    public QueryGraph<Weight.NoWeight> run(Query query) {
        if (this.triggered) {
            throw new RuntimeException(DemandDrivenGuidedAnalysis.class.getName() + " must be instantiated once per query. Use a different instance.");
        }
        this.triggered = true;
        this.queryQueue.add(new QueryWithContext(query));
        while (!this.queryQueue.isEmpty()) {
            AbstractBoomerangResults results;
            QueryWithContext pop = this.queryQueue.pop();
            if (pop.query instanceof ForwardQuery) {
                ForwardQuery currentQuery = (ForwardQuery)pop.query;
                results = pop.parentQuery == null ? this.solver.solve(currentQuery) : this.solver.solveUnderScope(currentQuery, pop.triggeringNode, pop.parentQuery);
                Table forwardResults = results.asEdgeValWeightTable((ForwardQuery)pop.query);
                this.triggerNewBackwardQueries(forwardResults, currentQuery, Specification.QueryDirection.FORWARD);
                continue;
            }
            results = pop.parentQuery == null ? this.solver.solve((BackwardQuery)pop.query) : this.solver.solveUnderScope((BackwardQuery)pop.query, pop.triggeringNode, pop.parentQuery);
            Table backwardResults = this.solver.getBackwardSolvers().get(query).asEdgeValWeightTable();
            this.triggerNewBackwardQueries(backwardResults, pop.query, Specification.QueryDirection.BACKWARD);
            Map<ForwardQuery, AbstractBoomerangResults.Context> allocationSites = ((BackwardBoomerangResults)results).getAllocationSites();
            for (Map.Entry<ForwardQuery, AbstractBoomerangResults.Context> entry : allocationSites.entrySet()) {
                this.triggerNewBackwardQueries(results.asEdgeValWeightTable(entry.getKey()), entry.getKey(), Specification.QueryDirection.FORWARD);
            }
        }
        QueryGraph<Weight.NoWeight> queryGraph = this.solver.getQueryGraph();
        return queryGraph;
    }

    public void cleanUp() {
        this.solver.unregisterAllListeners();
    }

    public Boomerang getSolver() {
        return this.solver;
    }

    private void triggerNewBackwardQueries(Table<ControlFlowGraph.Edge, Val, Weight.NoWeight> backwardResults, Query lastQuery, Specification.QueryDirection direction) {
        for (Table.Cell cell : backwardResults.cellSet()) {
            ControlFlowGraph.Edge triggeringEdge = (ControlFlowGraph.Edge)cell.getRowKey();
            Val fact = (Val)cell.getColumnKey();
            Collection<Query> queries = direction == Specification.QueryDirection.FORWARD ? this.spec.onForwardFlow((ForwardQuery)lastQuery, (ControlFlowGraph.Edge)cell.getRowKey(), (Val)cell.getColumnKey()) : this.spec.onBackwardFlow((BackwardQuery)lastQuery, (ControlFlowGraph.Edge)cell.getRowKey(), (Val)cell.getColumnKey());
            for (Query q : queries) {
                this.addToQueue(new QueryWithContext(q, (Node<ControlFlowGraph.Edge, Val>)new Node((Object)triggeringEdge, (Object)fact), lastQuery));
            }
        }
    }

    private void addToQueue(QueryWithContext nextQuery) {
        if (this.visited.add(nextQuery.query)) {
            this.queryQueue.add(nextQuery);
        }
    }

    private static class QueryWithContext {
        Query query;
        Query parentQuery;
        Node<ControlFlowGraph.Edge, Val> triggeringNode;

        private QueryWithContext(Query query) {
            this.query = query;
        }

        private QueryWithContext(Query query, Node<ControlFlowGraph.Edge, Val> triggeringNode, Query parentQuery) {
            this.query = query;
            this.parentQuery = parentQuery;
            this.triggeringNode = triggeringNode;
        }
    }
}

