/*
 * Decompiled with CFR 0.152.
 */
package boomerang.debugger;

import boomerang.BackwardQuery;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.CallerListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.controlflowgraph.ObservableControlFlowGraph;
import boomerang.controlflowgraph.SuccessorListener;
import boomerang.debugger.Debugger;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.solver.ForwardBoomerangSolver;
import boomerang.util.RegExAccessPath;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import wpds.impl.NormalRule;
import wpds.impl.Rule;
import wpds.impl.Weight;

public class IDEVizDebugger<W extends Weight>
extends Debugger<W> {
    private static boolean ONLY_CFG = false;
    private static final Logger logger = LoggerFactory.getLogger(IDEVizDebugger.class);
    private File ideVizFile;
    private ObservableICFG<Statement, Method> icfg;
    private Table<Query, Method, Set<Rule<ControlFlowGraph.Edge, INode<Val>, W>>> rules = HashBasedTable.create();
    private Map<Object, Integer> objectToInteger = new HashMap<Object, Integer>();
    private int charSize;
    private ObservableControlFlowGraph cfg;

    public IDEVizDebugger(File ideVizFile) {
        this.ideVizFile = ideVizFile;
    }

    private void callRules(Query q, Set<Rule<ControlFlowGraph.Edge, INode<Val>, W>> allRules) {
        for (Rule<ControlFlowGraph.Edge, INode<Val>, W> e : allRules) {
            ControlFlowGraph.Edge stmt = (ControlFlowGraph.Edge)e.getL1();
            if (stmt.getMethod() == null) continue;
            Set<Rule<ControlFlowGraph.Edge, INode<Val>, W>> transInMethod = this.getOrCreateRuleSet(q, stmt.getMethod());
            transInMethod.add(e);
        }
    }

    private Set<Rule<ControlFlowGraph.Edge, INode<Val>, W>> getOrCreateRuleSet(Query q, Method method) {
        Set map = (Set)this.rules.get((Object)q, (Object)method);
        if (map != null) {
            return map;
        }
        this.rules.put((Object)q, (Object)method, (Object)Sets.newHashSet());
        return (Set)this.rules.get((Object)q, (Object)method);
    }

    @Override
    public void done(ObservableICFG<Statement, Method> icfg, ObservableControlFlowGraph confg, Set<Method> visitedMethods, Map<ForwardQuery, ForwardBoomerangSolver<W>> solvers) {
        this.icfg = icfg;
        this.cfg = confg;
        logger.warn("Starting to compute visualization, this requires a large amount of memory, please ensure the VM has enough memory.");
        Stopwatch watch = Stopwatch.createStarted();
        JSONArray eventualData = new JSONArray();
        if (!ONLY_CFG) {
            for (Query query : solvers.keySet()) {
                this.callRules(query, solvers.get(query).getCallPDS().getAllRules());
            }
        }
        for (Map.Entry entry : Lists.newArrayList(solvers.entrySet())) {
            logger.debug("Computing results for {}", entry.getKey());
            Query query = (Query)entry.getKey();
            JSONQuery queryJSON = new JSONQuery(query);
            JSONArray data = new JSONArray();
            for (Method m : Lists.newArrayList(visitedMethods)) {
                Table results = ((ForwardBoomerangSolver)((Object)entry.getValue())).getResults(m);
                if (results.isEmpty()) continue;
                int labelYOffset = ONLY_CFG ? 0 : this.computeLabelYOffset(results.columnKeySet());
                JSONMethod jsonMethod = new JSONMethod(m);
                logger.debug("Creating control-flow graph for {}", (Object)m);
                JSONControlFlowGraph cfg = this.createControlFlowGraph(m, labelYOffset);
                jsonMethod.put("cfg", (Object)cfg);
                if (!ONLY_CFG) {
                    Set<Rule<ControlFlowGraph.Edge, INode<Val>, W>> rulesInMethod = this.getOrCreateRuleSet(query, m);
                    logger.debug("Creating data-flow graph for {}", (Object)m);
                    DataFlowGraph dfg = this.createDataFlowGraph(query, results, rulesInMethod, cfg, m, labelYOffset);
                    jsonMethod.put("dfg", (Object)dfg);
                }
                data.add((Object)jsonMethod);
            }
            queryJSON.put("methods", data);
            eventualData.add((Object)queryJSON);
        }
        logger.info("Computing visualization took: {}", (Object)watch.elapsed());
        try (FileWriter file = new FileWriter(this.ideVizFile);){
            logger.info("Writing visualization to file {}", (Object)this.ideVizFile.getAbsolutePath());
            file.write(eventualData.toJSONString());
            logger.info("Visualization available in file {}", (Object)this.ideVizFile.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.info("Exception in writing to visualization file {}", (Object)this.ideVizFile.getAbsolutePath());
        }
    }

    private int computeLabelYOffset(Set<RegExAccessPath> facts) {
        int labelYOffset = 0;
        for (RegExAccessPath g : facts) {
            labelYOffset = Math.max(labelYOffset, this.charSize * g.toString().length());
        }
        return labelYOffset;
    }

    private DataFlowGraph createDataFlowGraph(Query q, Table<ControlFlowGraph.Edge, RegExAccessPath, W> table, Set<Rule<ControlFlowGraph.Edge, INode<Val>, W>> rulesInMethod, JSONControlFlowGraph cfg, Method m, int labelYOffset) {
        LinkedList<RegExAccessPath> factsList = new LinkedList<RegExAccessPath>();
        DataFlowGraph dataFlowGraph = new DataFlowGraph();
        Set facts = table.columnKeySet();
        JSONArray data = new JSONArray();
        int offset = 0;
        int charSize = 8;
        for (RegExAccessPath u : facts) {
            JSONObject jSONObject = new JSONObject();
            JSONObject pos = new JSONObject();
            factsList.add(u);
            pos.put((Object)"x", (Object)(factsList.size() * 30 + offset * charSize));
            pos.put((Object)"y", (Object)labelYOffset);
            jSONObject.put((Object)"position", (Object)pos);
            JSONObject label = new JSONObject();
            label.put((Object)"label", (Object)u.toString());
            label.put((Object)"factId", (Object)this.id(u));
            jSONObject.put((Object)"classes", (Object)("fact label method" + this.id(m)));
            jSONObject.put((Object)"data", (Object)label);
            data.add((Object)jSONObject);
        }
        HashMultimap esgNodes = HashMultimap.create();
        for (Table.Cell cell : table.cellSet()) {
            ControlFlowGraph.Edge stmt = (ControlFlowGraph.Edge)cell.getRowKey();
            RegExAccessPath val = (RegExAccessPath)cell.getColumnKey();
            if (!((ControlFlowGraph.Edge)cell.getRowKey()).getMethod().equals(val.getVal().m())) continue;
            JSONObject nodeObj = new JSONObject();
            JSONObject pos = new JSONObject();
            pos.put((Object)"x", (Object)((factsList.indexOf(val) + 1) * 30));
            pos.put((Object)"y", (Object)(cfg.stmtsList.indexOf(stmt) * 30 + (q instanceof BackwardQuery ? 30 : 0)));
            nodeObj.put((Object)"position", (Object)pos);
            String classes = "esgNode method" + this.id(m) + " ";
            JSONObject additionalData = new JSONObject();
            additionalData.put((Object)"id", (Object)("q" + this.id(q) + "n" + this.id(new Node((Object)stmt, (Object)val))));
            additionalData.put((Object)"stmtId", (Object)this.id(stmt));
            additionalData.put((Object)"factId", (Object)this.id(val));
            if (cell.getValue() != null) {
                additionalData.put((Object)"ideValue", (Object)((Weight)cell.getValue()).toString());
            }
            nodeObj.put((Object)"classes", (Object)classes);
            nodeObj.put((Object)"group", (Object)"nodes");
            nodeObj.put((Object)"data", (Object)additionalData);
            data.add((Object)nodeObj);
            esgNodes.put((Object)new Node((Object)stmt, (Object)val.getVal()), (Object)val);
        }
        for (Rule rule : rulesInMethod) {
            if (!(rule instanceof NormalRule)) continue;
            JSONObject nodeObj = new JSONObject();
            JSONObject dataEntry = new JSONObject();
            dataEntry.put((Object)"id", (Object)("e" + this.id(rule)));
            Node<ControlFlowGraph.Edge, Val> start = this.getStartNode(rule);
            Node<ControlFlowGraph.Edge, Val> target = this.getTargetNode(rule);
            for (RegExAccessPath startField : esgNodes.get(start)) {
                for (RegExAccessPath targetField : esgNodes.get(target)) {
                    dataEntry.put((Object)"source", (Object)("q" + this.id(q) + "n" + this.id(new Node((Object)((ControlFlowGraph.Edge)start.stmt()), (Object)startField))));
                    dataEntry.put((Object)"target", (Object)("q" + this.id(q) + "n" + this.id(new Node((Object)((ControlFlowGraph.Edge)target.stmt()), (Object)targetField))));
                    dataEntry.put((Object)"directed", (Object)"true");
                    dataEntry.put((Object)"direction", (Object)(q instanceof BackwardQuery ? "Backward" : "Forward"));
                    nodeObj.put((Object)"data", (Object)dataEntry);
                    nodeObj.put((Object)"classes", (Object)("esgEdge  method" + this.id(m)));
                    nodeObj.put((Object)"group", (Object)"edges");
                    data.add((Object)nodeObj);
                }
            }
        }
        dataFlowGraph.put("dataFlowNode", data);
        return dataFlowGraph;
    }

    private Node<ControlFlowGraph.Edge, Val> getTargetNode(Rule<ControlFlowGraph.Edge, INode<Val>, W> rule) {
        return new Node((Object)((ControlFlowGraph.Edge)rule.getL2()), (Object)((Val)((INode)rule.getS2()).fact()));
    }

    private Node<ControlFlowGraph.Edge, Val> getStartNode(Rule<ControlFlowGraph.Edge, INode<Val>, W> rule) {
        return new Node((Object)((ControlFlowGraph.Edge)rule.getL1()), (Object)((Val)((INode)rule.getS1()).fact()));
    }

    private JSONControlFlowGraph createControlFlowGraph(final Method m, int labelYOffset) {
        JSONControlFlowGraph cfg = new JSONControlFlowGraph();
        int index = 0;
        int offset = 0;
        final JSONArray data = new JSONArray();
        for (final Statement u : m.getStatements()) {
            JSONArray callees;
            if (u.getMethod() == null) continue;
            JSONObject nodeObj = new JSONObject();
            JSONObject pos = new JSONObject();
            cfg.stmtsList.add(u);
            pos.put((Object)"x", (Object)10);
            pos.put((Object)"y", (Object)(cfg.stmtsList.size() * 30 + labelYOffset));
            nodeObj.put((Object)"position", (Object)pos);
            JSONObject label = new JSONObject();
            label.put((Object)"label", (Object)u.toString());
            label.put((Object)"shortLabel", (Object)u.toString());
            if (this.icfg.isCallStmt(u)) {
                label.put((Object)"callSite", (Object)this.icfg.isCallStmt(u));
                callees = new JSONArray();
                this.icfg.addCalleeListener(new JsonCalleeListener(u, callees));
                label.put((Object)"callees", (Object)callees);
            }
            if (this.icfg.isExitStmt(u)) {
                label.put((Object)"returnSite", (Object)this.icfg.isExitStmt(u));
                callees = new JSONArray();
                HashSet<Method> callers = new HashSet<Method>();
                this.icfg.addCallerListener(new JsonCallerListener(u, callers));
                for (Method caller : callers) {
                    callees.add((Object)new JSONMethod(caller));
                }
                label.put((Object)"callers", (Object)callees);
            }
            label.put((Object)"stmtId", (Object)this.id(u));
            label.put((Object)"id", (Object)("stmt" + this.id(u)));
            label.put((Object)"stmtIndex", (Object)index);
            ++index;
            nodeObj.put((Object)"data", (Object)label);
            nodeObj.put((Object)"classes", (Object)("stmt label " + (this.icfg.isExitStmt(u) ? " returnSite " : " ") + (this.icfg.isCallStmt(u) ? " callSite " : " ") + " method" + this.id(m)));
            data.add((Object)nodeObj);
            offset = Math.max(offset, u.toString().length());
            this.cfg.addSuccsOfListener(new SuccessorListener(u){

                @Override
                public void getSuccessor(Statement succ) {
                    JSONObject cfgEdgeObj = new JSONObject();
                    JSONObject dataEntry = new JSONObject();
                    dataEntry.put((Object)"source", (Object)("stmt" + IDEVizDebugger.this.id(u)));
                    dataEntry.put((Object)"target", (Object)("stmt" + IDEVizDebugger.this.id(succ)));
                    dataEntry.put((Object)"directed", (Object)"true");
                    cfgEdgeObj.put((Object)"data", (Object)dataEntry);
                    cfgEdgeObj.put((Object)"classes", (Object)("cfgEdge label method" + IDEVizDebugger.this.id(m)));
                    data.add((Object)cfgEdgeObj);
                }
            });
        }
        cfg.put("controlFlowNode", data);
        return cfg;
    }

    public Integer id(Object u) {
        if (this.objectToInteger.get(u) != null) {
            return this.objectToInteger.get(u);
        }
        int size = this.objectToInteger.size() + 1;
        this.objectToInteger.put(u, size);
        return size;
    }

    private class DataFlowGraph
    extends JSONObject {
        private DataFlowGraph() {
        }
    }

    private class JSONControlFlowGraph
    extends JSONObject {
        public List<Statement> stmtsList = Lists.newLinkedList();

        private JSONControlFlowGraph() {
        }
    }

    private class JSONQuery
    extends JSONObject {
        JSONQuery(Query m) {
            this.put("query", this.prettyPrintQuery(m));
            this.put("id", IDEVizDebugger.this.id(m));
        }

        private String prettyPrintQuery(Query m) {
            return (m instanceof BackwardQuery ? "B " : "F ") + m.asNode().fact() + " @ " + ((ControlFlowGraph.Edge)m.asNode().stmt()).getMethod();
        }
    }

    private class JSONMethod
    extends JSONObject {
        JSONMethod(Method m) {
            this.put("methodName", m.toString());
            this.put("id", IDEVizDebugger.this.id(m));
        }
    }

    private class JsonCallerListener
    implements CallerListener<Statement, Method> {
        Statement u;
        Set<Method> callers;

        JsonCallerListener(Statement u, Set<Method> callers) {
            this.u = u;
            this.callers = callers;
        }

        @Override
        public Method getObservedCallee() {
            return this.u.getMethod();
        }

        @Override
        public void onCallerAdded(Statement unit, Method sootMethod) {
            this.callers.add(unit.getMethod());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonCallerListener that = (JsonCallerListener)o;
            return Objects.equals(this.u, that.u) && Objects.equals(this.callers, that.callers);
        }

        public int hashCode() {
            return Objects.hash(this.u, this.callers);
        }
    }

    private class JsonCalleeListener
    implements CalleeListener<Statement, Method> {
        Statement u;
        JSONArray callees;

        JsonCalleeListener(Statement u, JSONArray callees) {
            this.u = u;
            this.callees = callees;
        }

        @Override
        public Statement getObservedCaller() {
            return this.u;
        }

        @Override
        public void onCalleeAdded(Statement unit, Method sootMethod) {
            if (sootMethod != null && sootMethod.toString() != null) {
                this.callees.add((Object)new JSONMethod(sootMethod));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonCalleeListener that = (JsonCalleeListener)o;
            return Objects.equals(this.u, that.u) && Objects.equals(this.callees, that.callees);
        }

        public int hashCode() {
            return Objects.hash(this.u, this.callees);
        }

        @Override
        public void onNoCalleeFound() {
        }
    }
}

