/*
 * Decompiled with CFR 0.152.
 */
package boomerang.callgraph;

import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.CallerListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.scene.CallGraph;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservableStaticICFG
implements ObservableICFG<Statement, Method> {
    private CallGraph precomputedGraph;
    private static final Logger LOGGER = LoggerFactory.getLogger(ObservableStaticICFG.class);
    private static final int IMPRECISE_CALL_GRAPH_WARN_THRESHOLD = 30000;

    public ObservableStaticICFG(CallGraph icfg) {
        this.precomputedGraph = icfg;
    }

    @Override
    public void addCalleeListener(CalleeListener<Statement, Method> listener) {
        Collection edges = this.precomputedGraph.edgesOutOf(listener.getObservedCaller());
        if (edges.size() > 30000) {
            LOGGER.debug("Call graph has more than {} callees at {}", (Object)30000, (Object)listener.getObservedCaller());
            for (CallGraph.Edge e : edges) {
                LOGGER.trace("\t callee {}", (Object)e.tgt());
            }
        }
        for (CallGraph.Edge e : edges) {
            listener.onCalleeAdded(listener.getObservedCaller(), e.tgt());
        }
        if (edges.size() == 0) {
            listener.onNoCalleeFound();
        }
    }

    @Override
    public void addCallerListener(CallerListener<Statement, Method> listener) {
        Collection edges = this.precomputedGraph.edgesInto(listener.getObservedCallee());
        if (edges.size() > 30000) {
            LOGGER.debug("Call graph has more than {} caller of {}", (Object)30000, (Object)listener.getObservedCallee());
            for (CallGraph.Edge e : edges) {
                LOGGER.trace("\t callsite {}", (Object)e.src());
            }
        }
        for (CallGraph.Edge e : edges) {
            listener.onCallerAdded(e.src(), listener.getObservedCallee());
        }
    }

    @Override
    public Collection<Statement> getStartPointsOf(Method m) {
        return m.getControlFlowGraph().getStartPoints();
    }

    @Override
    public boolean isCallStmt(Statement stmt) {
        return stmt.containsInvokeExpr();
    }

    @Override
    public boolean isExitStmt(Statement stmt) {
        return stmt.getMethod().getControlFlowGraph().getEndPoints().contains(stmt);
    }

    @Override
    public boolean isStartPoint(Statement stmt) {
        return stmt.getMethod().getControlFlowGraph().getStartPoints().contains(stmt);
    }

    @Override
    public Collection<Statement> getEndPointsOf(Method m) {
        return m.getControlFlowGraph().getEndPoints();
    }

    @Override
    public int getNumberOfEdgesTakenFromPrecomputedGraph() {
        return -1;
    }

    @Override
    public void resetCallGraph() {
    }

    @Override
    public void computeFallback() {
    }

    @Override
    public void addEdges(CallGraph.Edge e) {
        throw new RuntimeException("Unnecessary");
    }
}

