/*
 * Decompiled with CFR 0.152.
 */
package boomerang;

import boomerang.BackwardQuery;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.WeightedBoomerang;
import boomerang.callgraph.CallerListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.BackwardBoomerangSolver;
import boomerang.solver.ForwardBoomerangSolver;
import boomerang.util.DefaultValueMap;
import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;

public class QueryGraph<W extends Weight> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryGraph.class);
    private final ObservableICFG<Statement, Method> icfg;
    private Multimap<Query, QueryEdge> sourceToQueryEdgeLookUp = HashMultimap.create();
    private Multimap<Query, QueryEdge> targetToQueryEdgeLookUp = HashMultimap.create();
    private Set<Query> roots = Sets.newHashSet();
    private DefaultValueMap<ForwardQuery, ForwardBoomerangSolver<W>> forwardSolvers;
    private Multimap<Query, AddTargetEdgeListener> edgeAddListener = HashMultimap.create();
    private DefaultValueMap<BackwardQuery, BackwardBoomerangSolver<W>> backwardSolver;

    public QueryGraph(WeightedBoomerang<W> weightedBoomerang) {
        this.forwardSolvers = weightedBoomerang.getSolvers();
        this.backwardSolver = weightedBoomerang.getBackwardSolvers();
        this.icfg = weightedBoomerang.icfg;
    }

    public void addRoot(Query root) {
        this.roots.add(root);
    }

    public void addEdge(Query parent, Node<ControlFlowGraph.Edge, Val> node, Query child) {
        QueryEdge queryEdge = new QueryEdge(parent, node, child);
        this.sourceToQueryEdgeLookUp.put((Object)parent, (Object)queryEdge);
        if (this.targetToQueryEdgeLookUp.put((Object)child, (Object)queryEdge)) {
            for (AddTargetEdgeListener l : Lists.newArrayList((Iterable)this.edgeAddListener.get((Object)child))) {
                l.edgeAdded(queryEdge);
            }
        }
        this.getSolver(parent).getCallAutomaton().registerListener((WPAStateListener)new SourceListener((INode<Val>)new SingleNode((Object)((Val)node.fact())), parent, child, null));
    }

    private AbstractBoomerangSolver<W> getSolver(Query query) {
        if (query instanceof BackwardQuery) {
            return this.backwardSolver.get(query);
        }
        return this.forwardSolvers.get(query);
    }

    public void unregisterAllListeners() {
        this.edgeAddListener.clear();
    }

    public Set<Query> getNodes() {
        HashSet nodes = Sets.newHashSet((Iterable)this.sourceToQueryEdgeLookUp.keySet());
        nodes.addAll(this.targetToQueryEdgeLookUp.keySet());
        return nodes;
    }

    public String toString() {
        Object s = "";
        int level = 0;
        for (Query root : this.roots) {
            s = (String)s + "Root:" + root + "\n";
            s = (String)s + this.visit(root, "", ++level, Sets.newHashSet());
        }
        return s;
    }

    public void registerEdgeListener(AddTargetEdgeListener l) {
        if (this.edgeAddListener.put((Object)l.getTarget(), (Object)l)) {
            ArrayList edges = Lists.newArrayList((Iterable)this.targetToQueryEdgeLookUp.get((Object)l.getTarget()));
            for (QueryEdge edge : edges) {
                l.edgeAdded(edge);
            }
            if (edges.isEmpty()) {
                l.noParentEdge();
            }
        }
    }

    private String visit(Query parent, String s, int i, Set<Query> visited) {
        for (QueryEdge child : this.sourceToQueryEdgeLookUp.get((Object)parent)) {
            if (!visited.add(child.getTarget())) continue;
            for (int j = 0; j <= i; ++j) {
                s = (String)s + " ";
            }
            s = (String)s + i;
            s = (String)s + child + "\n";
            s = (String)s + this.visit(child.getTarget(), "", ++i, visited);
        }
        return s;
    }

    public String toDotString() {
        Object s = "digraph {\n";
        TreeSet<CallSite> trans = new TreeSet<CallSite>();
        for (Map.Entry target : this.sourceToQueryEdgeLookUp.entries()) {
            String v = "\t\"" + this.escapeQuotes(((Query)target.getKey()).toString()) + "\"";
            v = v + " -> \"" + this.escapeQuotes(((QueryEdge)target.getValue()).getTarget().toString()) + "\"";
            trans.add((CallSite)((Object)v));
        }
        s = (String)s + Joiner.on((String)"\n").join(trans);
        s = (String)s + "}\n";
        return s;
    }

    private String escapeQuotes(String string) {
        return string.replace("\"", "");
    }

    public boolean isRoot(Query q) {
        return this.roots.contains(q);
    }

    private static class QueryEdge {
        private final Query source;
        private final Query target;
        private Node<ControlFlowGraph.Edge, Val> node;

        public QueryEdge(Query source, Node<ControlFlowGraph.Edge, Val> node, Query target) {
            this.source = source;
            this.node = node;
            this.target = target;
        }

        public Node<ControlFlowGraph.Edge, Val> getNode() {
            return this.node;
        }

        public Query getSource() {
            return this.source;
        }

        public Query getTarget() {
            return this.target;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
            result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueryEdge other = (QueryEdge)obj;
            if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
                return false;
            }
            if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
                return false;
            }
            return !(this.node == null ? other.node != null : !this.node.equals(other.node));
        }
    }

    private class UnbalancedContextListener
    implements AddTargetEdgeListener {
        private final Transition<ControlFlowGraph.Edge, INode<Val>> transition;
        private Query parent;
        private Query child;

        public UnbalancedContextListener(Query child, Query parent, Transition<ControlFlowGraph.Edge, INode<Val>> t) {
            this.child = child;
            this.parent = parent;
            this.transition = t;
        }

        @Override
        public Query getTarget() {
            return this.parent;
        }

        @Override
        public void edgeAdded(QueryEdge parentOfParent) {
            Query newParent = parentOfParent.getSource();
            QueryGraph.this.getSolver(newParent).getCallAutomaton().registerListener((WPAStateListener)new SourceListener((INode<Val>)new SingleNode((Object)((Val)parentOfParent.getNode().fact())), newParent, this.child, null));
        }

        @Override
        public void noParentEdge() {
            if (this.child instanceof BackwardQuery) {
                final Method callee = ((Val)((INode)this.transition.getTarget()).fact()).m();
                QueryGraph.this.icfg.addCallerListener(new CallerListener<Statement, Method>(){

                    @Override
                    public Method getObservedCallee() {
                        return callee;
                    }

                    @Override
                    public void onCallerAdded(Statement callSite, Method method) {
                        QueryGraph.this.getSolver(UnbalancedContextListener.this.child).allowUnbalanced(callee, callSite);
                    }
                });
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            result = 31 * result + (this.transition == null ? 0 : this.transition.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UnbalancedContextListener other = (UnbalancedContextListener)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            if (this.child == null ? other.child != null : !this.child.equals(other.child)) {
                return false;
            }
            if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
                return false;
            }
            return !(this.parent == null ? other.transition != null : !this.transition.equals(other.transition));
        }

        private QueryGraph getEnclosingInstance() {
            return QueryGraph.this;
        }
    }

    private static interface AddTargetEdgeListener {
        public Query getTarget();

        public void edgeAdded(QueryEdge var1);

        public void noParentEdge();
    }

    private class SourceListener
    extends WPAStateListener<ControlFlowGraph.Edge, INode<Val>, W> {
        private Query child;
        private Query parent;
        private Method callee;

        public SourceListener(INode<Val> state, Query parent, Query child, Method callee) {
            super(state);
            this.parent = parent;
            this.child = child;
            this.callee = callee;
        }

        public void onOutTransitionAdded(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w, WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> weightedPAutomaton) {
            if (t.getStart() instanceof GeneratedState && this.callee != null) {
                ControlFlowGraph.Edge callSiteLabel = (ControlFlowGraph.Edge)t.getLabel();
                QueryGraph.this.getSolver(this.child).allowUnbalanced(this.callee, this.parent instanceof BackwardQuery ? callSiteLabel.getTarget() : callSiteLabel.getStart());
            }
            if (t.getTarget() instanceof GeneratedState) {
                QueryGraph.this.getSolver(this.parent).getCallAutomaton().registerListener((WPAStateListener)new SourceListener((INode<Val>)((INode)t.getTarget()), this.parent, this.child, ((ControlFlowGraph.Edge)t.getLabel()).getMethod()));
            }
            if (weightedPAutomaton.isUnbalancedState((State)((INode)t.getTarget()))) {
                QueryGraph.this.registerEdgeListener(new UnbalancedContextListener(this.child, this.parent, t));
            }
        }

        public void onInTransitionAdded(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w, WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> weightedPAutomaton) {
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.callee == null ? 0 : this.callee.hashCode());
            result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            SourceListener other = (SourceListener)((Object)obj);
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            if (this.callee == null ? other.callee != null : !this.callee.equals(other.callee)) {
                return false;
            }
            if (this.child == null ? other.child != null : !this.child.equals(other.child)) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }

        private QueryGraph getEnclosingInstance() {
            return QueryGraph.this;
        }
    }
}

