/*
 * Decompiled with CFR 0.152.
 */
package boomerang.stats;

import boomerang.BackwardQuery;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.WeightedBoomerang;
import boomerang.results.BackwardBoomerangResults;
import boomerang.results.ForwardBoomerangResults;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Method;
import boomerang.scene.Val;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.stats.IBoomerangStats;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.WPAUpdateListener;

public class SimpleBoomerangStats<W extends Weight>
implements IBoomerangStats<W> {
    private Map<Query, AbstractBoomerangSolver<W>> queries = Maps.newHashMap();
    private Set<Method> callVisitedMethods = Sets.newHashSet();
    private Set<Method> fieldVisitedMethods = Sets.newHashSet();

    @Override
    public void registerSolver(Query key, AbstractBoomerangSolver<W> solver) {
        if (this.queries.containsKey(key)) {
            return;
        }
        this.queries.put(key, solver);
        solver.getCallAutomaton().registerListener(new WPAUpdateListener<ControlFlowGraph.Edge, INode<Val>, W>(){

            public void onWeightAdded(Transition<ControlFlowGraph.Edge, INode<Val>> t, W w, WeightedPAutomaton<ControlFlowGraph.Edge, INode<Val>, W> aut) {
                SimpleBoomerangStats.this.callVisitedMethods.add(((ControlFlowGraph.Edge)t.getLabel()).getMethod());
            }
        });
        solver.getFieldAutomaton().registerListener((t, w, aut) -> this.fieldVisitedMethods.add(((ControlFlowGraph.Edge)((Node)((INode)t.getStart()).fact()).stmt()).getMethod()));
    }

    @Override
    public void registerFieldWritePOI(WeightedBoomerang.FieldWritePOI key) {
    }

    public String toString() {
        Object s = "=========== Boomerang Stats =============\n";
        int forwardQuery = 0;
        int backwardQuery = 0;
        for (Query q : this.queries.keySet()) {
            if (q instanceof ForwardQuery) {
                ++forwardQuery;
                continue;
            }
            ++backwardQuery;
        }
        s = (String)s + String.format("Queries (Forward/Backward/Total): \t\t %s/%s/%s\n", forwardQuery, backwardQuery, this.queries.keySet().size());
        s = (String)s + String.format("Visited Methods (Field/Call): \t\t %s/%s/(%s/%s)\n", this.fieldVisitedMethods.size(), this.callVisitedMethods.size(), Sets.difference(this.fieldVisitedMethods, this.callVisitedMethods).size(), Sets.difference(this.callVisitedMethods, this.fieldVisitedMethods).size());
        s = (String)s + "\n";
        return s;
    }

    @Override
    public Collection<? extends Node<ControlFlowGraph.Edge, Val>> getForwardReachesNodes() {
        HashSet res = Sets.newHashSet();
        for (Query q : this.queries.keySet()) {
            if (!(q instanceof ForwardQuery)) continue;
            res.addAll(this.queries.get(q).getReachedStates());
        }
        return res;
    }

    @Override
    public Set<Method> getCallVisitedMethods() {
        return Sets.newHashSet(this.callVisitedMethods);
    }

    @Override
    public void terminated(ForwardQuery query, ForwardBoomerangResults<W> forwardBoomerangResults) {
    }

    @Override
    public void terminated(BackwardQuery query, BackwardBoomerangResults<W> backwardBoomerangResults) {
    }
}

