/*
 * Decompiled with CFR 0.152.
 */
package boomerang.solver;

import boomerang.BoomerangOptions;
import boomerang.arrays.ArrayHandlingStrategy;
import boomerang.arrays.ArrayIndexInsensitiveStrategy;
import boomerang.arrays.ArrayIndexSensitiveStrategy;
import boomerang.arrays.IgnoreArrayStrategy;
import boomerang.scene.Field;
import boomerang.scene.Statement;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.staticfields.FlowSensitiveStaticFieldStrategy;
import boomerang.staticfields.IgnoreStaticFieldStrategy;
import boomerang.staticfields.SingletonStaticFieldStrategy;
import boomerang.staticfields.StaticFieldStrategy;
import com.google.common.collect.Multimap;
import wpds.impl.Weight;

public class Strategies<W extends Weight> {
    private final StaticFieldStrategy<W> staticFieldStrategy;
    private final ArrayHandlingStrategy<W> arrayHandlingStrategy;

    public Strategies(BoomerangOptions opts, AbstractBoomerangSolver solver, Multimap<Field, Statement> fieldLoadStatements, Multimap<Field, Statement> fieldStoreStatements) {
        switch (opts.getStaticFieldStrategy()) {
            case IGNORE: {
                this.staticFieldStrategy = new IgnoreStaticFieldStrategy();
                break;
            }
            case SINGLETON: {
                this.staticFieldStrategy = new SingletonStaticFieldStrategy(solver, fieldLoadStatements, fieldStoreStatements);
                break;
            }
            default: {
                this.staticFieldStrategy = new FlowSensitiveStaticFieldStrategy();
            }
        }
        switch (opts.getArrayStrategy()) {
            case DISABLED: {
                this.arrayHandlingStrategy = new IgnoreArrayStrategy();
                break;
            }
            case INDEX_INSENSITIVE: {
                this.arrayHandlingStrategy = new ArrayIndexInsensitiveStrategy();
                break;
            }
            default: {
                this.arrayHandlingStrategy = new ArrayIndexSensitiveStrategy();
            }
        }
    }

    public StaticFieldStrategy<W> getStaticFieldStrategy() {
        return this.staticFieldStrategy;
    }

    public ArrayHandlingStrategy<W> getArrayHandlingStrategy() {
        return this.arrayHandlingStrategy;
    }
}

