/*
 * Decompiled with CFR 0.152.
 */
package boomerang.results;

import boomerang.BackwardQuery;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.Util;
import boomerang.results.AbstractBoomerangResults;
import boomerang.results.ExtractAllAliasListener;
import boomerang.results.ExtractAllocationSiteStateListener;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Statement;
import boomerang.scene.Type;
import boomerang.scene.Val;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.BackwardBoomerangSolver;
import boomerang.solver.ForwardBoomerangSolver;
import boomerang.stats.IBoomerangStats;
import boomerang.util.AccessPath;
import boomerang.util.DefaultValueMap;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.WPAStateListener;

public class BackwardBoomerangResults<W extends Weight>
extends AbstractBoomerangResults<W> {
    private final BackwardQuery query;
    private final BackwardBoomerangSolver<W> backwardSolver;
    private Map<ForwardQuery, AbstractBoomerangResults.Context> allocationSites;
    private final boolean timedout;
    private final IBoomerangStats<W> stats;
    private Stopwatch analysisWatch;
    private long maxMemory;

    public BackwardBoomerangResults(BackwardQuery query, boolean timedout, DefaultValueMap<ForwardQuery, ForwardBoomerangSolver<W>> queryToSolvers, BackwardBoomerangSolver<W> backwardSolver, IBoomerangStats<W> stats, Stopwatch analysisWatch) {
        super(queryToSolvers);
        this.query = query;
        this.timedout = timedout;
        this.stats = stats;
        this.analysisWatch = analysisWatch;
        this.backwardSolver = backwardSolver;
        stats.terminated(query, this);
        this.maxMemory = Util.getReallyUsedMemory();
    }

    public Map<ForwardQuery, AbstractBoomerangResults.Context> getAllocationSites() {
        this.computeAllocations();
        return this.allocationSites;
    }

    public boolean isTimedout() {
        return this.timedout;
    }

    public IBoomerangStats<W> getStats() {
        return this.stats;
    }

    public Stopwatch getAnalysisWatch() {
        return this.analysisWatch;
    }

    private void computeAllocations() {
        if (this.allocationSites != null) {
            return;
        }
        final HashSet results = Sets.newHashSet();
        for (Map.Entry fw : this.queryToSolvers.entrySet()) {
            for (INode node : ((ForwardBoomerangSolver)((Object)fw.getValue())).getFieldAutomaton().getInitialStates()) {
                ((ForwardBoomerangSolver)((Object)fw.getValue())).getFieldAutomaton().registerListener((WPAStateListener)new ExtractAllocationSiteStateListener<W>(node, this.query, (ForwardQuery)fw.getKey()){

                    @Override
                    protected void allocationSiteFound(ForwardQuery allocationSite, BackwardQuery query) {
                        results.add(allocationSite);
                    }
                });
            }
        }
        this.allocationSites = Maps.newHashMap();
        for (ForwardQuery q : results) {
            AbstractBoomerangResults.Context context = this.constructContextGraph(q, this.query.asNode());
            assert (this.allocationSites.get(q) == null);
            this.allocationSites.put(q, context);
        }
    }

    public boolean aliases(Query el) {
        for (ForwardQuery fw : this.getAllocationSites().keySet()) {
            if (!((ForwardBoomerangSolver)((Object)this.queryToSolvers.getOrCreate(fw))).getReachedStates().contains(el.asNode()) || !((ForwardBoomerangSolver)((Object)this.queryToSolvers.getOrCreate(fw))).reachesNodeWithEmptyField(el.asNode())) continue;
            return true;
        }
        return false;
    }

    public Set<AccessPath> getAllAliases(ControlFlowGraph.Edge stmt) {
        HashSet results = Sets.newHashSet();
        for (ForwardQuery fw : this.getAllocationSites().keySet()) {
            ((ForwardBoomerangSolver)((Object)this.queryToSolvers.getOrCreate(fw))).registerListener(new ExtractAllAliasListener((AbstractBoomerangSolver)((Object)this.queryToSolvers.get(fw)), results, stmt));
        }
        return results;
    }

    public Set<AccessPath> getAllAliases() {
        return this.getAllAliases(this.query.cfgEdge());
    }

    public boolean isEmpty() {
        this.computeAllocations();
        return this.allocationSites.isEmpty();
    }

    public Set<Type> getPropagationType() {
        HashSet types = Sets.newHashSet();
        for (Transition t : this.backwardSolver.getCallAutomaton().getTransitions()) {
            if (((Val)((INode)t.getStart()).fact()).isStatic()) continue;
            types.add(((Val)((INode)t.getStart()).fact()).getType());
        }
        return types;
    }

    @Deprecated
    public Set<Node<ControlFlowGraph.Edge, Val>> getDataFlowPath(ForwardQuery query) {
        HashSet dataFlowPath = Sets.newHashSet();
        WeightedPAutomaton callAut = ((ForwardBoomerangSolver)((Object)this.queryToSolvers.getOrCreate(query))).getCallAutomaton();
        for (Map.Entry e : callAut.getTransitionsToFinalWeights().entrySet()) {
            Transition t = (Transition)e.getKey();
            if (((ControlFlowGraph.Edge)t.getLabel()).equals((Object)Statement.epsilon()) || ((Val)((INode)t.getStart()).fact()).isLocal() && !((ControlFlowGraph.Edge)t.getLabel()).getMethod().equals(((Val)((INode)t.getStart()).fact()).m()) || !((ControlFlowGraph.Edge)t.getLabel()).getStart().uses((Val)((INode)t.getStart()).fact())) continue;
            dataFlowPath.add(new Node((Object)((ControlFlowGraph.Edge)t.getLabel()), (Object)((Val)((INode)t.getStart()).fact())));
        }
        return dataFlowPath;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }
}

