/*
 * Decompiled with CFR 0.152.
 */
package boomerang.guided;

import boomerang.BackwardQuery;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.guided.IDemandDrivenGuidedManager;
import boomerang.guided.Specification;
import boomerang.scene.AllocVal;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.scene.jimple.JimpleStatement;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import soot.jimple.Stmt;

public class SimpleSpecificationGuidedManager
implements IDemandDrivenGuidedManager {
    private final Specification spec;

    public SimpleSpecificationGuidedManager(Specification spec) {
        this.spec = spec;
    }

    @Override
    public Collection<Query> onForwardFlow(ForwardQuery query, ControlFlowGraph.Edge dataFlowEdge, Val dataFlowVal) {
        Statement stmt = dataFlowEdge.getStart();
        HashSet res = Sets.newHashSet();
        if (stmt.containsInvokeExpr()) {
            Set selectors = this.spec.getMethodAndQueries().stream().filter(x -> this.isInOnList((Specification.SootMethodWithSelector)x, stmt, dataFlowVal, Specification.QueryDirection.FORWARD)).collect(Collectors.toSet());
            for (Specification.SootMethodWithSelector sel : selectors) {
                res.addAll(this.createNewQueries(sel, stmt));
            }
        }
        return res;
    }

    @Override
    public Collection<Query> onBackwardFlow(BackwardQuery query, ControlFlowGraph.Edge dataFlowEdge, Val dataFlowVal) {
        Statement stmt = dataFlowEdge.getStart();
        HashSet res = Sets.newHashSet();
        if (stmt.containsInvokeExpr()) {
            Set selectors = this.spec.getMethodAndQueries().stream().filter(x -> this.isInOnList((Specification.SootMethodWithSelector)x, stmt, dataFlowVal, Specification.QueryDirection.BACKWARD)).collect(Collectors.toSet());
            for (Specification.SootMethodWithSelector sel : selectors) {
                res.addAll(this.createNewQueries(sel, stmt));
            }
        }
        return res;
    }

    private Collection<Query> createNewQueries(Specification.SootMethodWithSelector sel, Statement stmt) {
        HashSet results = Sets.newHashSet();
        Method method = stmt.getMethod();
        for (Specification.QuerySelector qSel : sel.getGo()) {
            Optional<Val> parameterVal = this.getParameterVal(stmt, qSel.argumentSelection);
            if (!parameterVal.isPresent()) continue;
            if (qSel.direction == Specification.QueryDirection.BACKWARD) {
                for (Statement pred : method.getControlFlowGraph().getPredsOf(stmt)) {
                    results.add(BackwardQuery.make(new ControlFlowGraph.Edge(pred, stmt), parameterVal.get()));
                }
                continue;
            }
            if (qSel.direction != Specification.QueryDirection.FORWARD) continue;
            for (Statement succ : method.getControlFlowGraph().getSuccsOf(stmt)) {
                results.add(new ForwardQuery(new ControlFlowGraph.Edge(stmt, succ), (Val)new AllocVal(parameterVal.get(), stmt, parameterVal.get())));
            }
        }
        return results;
    }

    public boolean isInOnList(Specification.SootMethodWithSelector methodSelector, Statement stmt, Val fact, Specification.QueryDirection direction) {
        Stmt jimpleStmt;
        if (stmt instanceof JimpleStatement && (jimpleStmt = ((JimpleStatement)stmt).getDelegate()).getInvokeExpr().getMethod().getSignature().equals(methodSelector.getSootMethod())) {
            Collection<Specification.QuerySelector> on = methodSelector.getOn();
            return this.isInList(on, direction, stmt, fact);
        }
        return false;
    }

    private boolean isInList(Collection<Specification.QuerySelector> list, Specification.QueryDirection direction, Statement stmt, Val fact) {
        return list.stream().anyMatch(sel -> sel.direction == direction && this.isParameter(stmt, fact, sel.argumentSelection));
    }

    private boolean isParameter(Statement stmt, Val fact, Specification.Parameter argumentSelection) {
        if (stmt.getInvokeExpr().isInstanceInvokeExpr() && argumentSelection.equals(Specification.Parameter.base())) {
            return stmt.getInvokeExpr().getBase().equals((Object)fact);
        }
        if (argumentSelection.equals(Specification.Parameter.returnParam())) {
            return stmt.isAssign() && stmt.getLeftOp().equals((Object)fact);
        }
        return stmt.getInvokeExpr().getArgs().size() > argumentSelection.getValue() && argumentSelection.getValue() >= 0 && stmt.getInvokeExpr().getArg(argumentSelection.getValue()).equals((Object)fact);
    }

    private Optional<Val> getParameterVal(Statement stmt, Specification.Parameter selector) {
        if (stmt.containsInvokeExpr() && !stmt.getInvokeExpr().isStaticInvokeExpr() && selector.equals(Specification.Parameter.base())) {
            return Optional.of(stmt.getInvokeExpr().getBase());
        }
        if (stmt.isAssign() && selector.equals(Specification.Parameter.returnParam())) {
            return Optional.of(stmt.getLeftOp());
        }
        if (stmt.getInvokeExpr().getArgs().size() > selector.getValue() && selector.getValue() >= 0) {
            return Optional.of(stmt.getInvokeExpr().getArg(selector.getValue()));
        }
        return Optional.empty();
    }
}

