/*
 * Decompiled with CFR 0.152.
 */
package boomerang.callgraph;

import boomerang.BackwardQuery;
import boomerang.Boomerang;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.SolverCreationListener;
import boomerang.WeightedBoomerang;
import boomerang.callgraph.ICallerCalleeResolutionStrategy;
import boomerang.callgraph.ObservableDynamicICFG;
import boomerang.results.ExtractAllocationSiteStateListener;
import boomerang.scene.CallGraph;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.DataFlowScope;
import boomerang.scene.DeclaredMethod;
import boomerang.scene.InvokeExpr;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Type;
import boomerang.scene.Val;
import boomerang.scene.WrappedClass;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.solver.ForwardBoomerangSolver;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sync.pds.solver.nodes.INode;
import wpds.impl.Weight;
import wpds.interfaces.WPAStateListener;

public class BoomerangResolver
implements ICallerCalleeResolutionStrategy {
    public static final ICallerCalleeResolutionStrategy.Factory FACTORY = (solver, cg) -> new BoomerangResolver(solver, cg);
    private static final Logger logger = LoggerFactory.getLogger(BoomerangResolver.class);
    private static final String THREAD_CLASS = "java.lang.Thread";
    private static final String THREAD_START_SIGNATURE = "<java.lang.Thread: void start()>";
    private static final String THREAD_RUN_SUB_SIGNATURE = "void run()";
    private static NoCalleeFoundFallbackOptions FALLBACK_OPTION = NoCalleeFoundFallbackOptions.BYPASS;
    private static Multimap<DeclaredMethod, WrappedClass> didNotFindMethodLog = HashMultimap.create();
    private CallGraph precomputedCallGraph;
    private WeightedBoomerang<? extends Weight> solver;
    private Set<Statement> queriedInvokeExprAndAllocationSitesFound = Sets.newHashSet();
    private Set<Statement> queriedInvokeExpr = Sets.newHashSet();

    public BoomerangResolver(CallGraph cg, DataFlowScope scope) {
        this.solver = new Boomerang(cg, scope);
        this.precomputedCallGraph = cg;
    }

    public BoomerangResolver(WeightedBoomerang<? extends Weight> solver, CallGraph initialCallGraph) {
        this(solver, true, initialCallGraph);
    }

    public BoomerangResolver(WeightedBoomerang<? extends Weight> solver, boolean enableExceptions, CallGraph initialCallGraph) {
        this.solver = solver;
        this.precomputedCallGraph = initialCallGraph;
    }

    @Override
    public void computeFallback(ObservableDynamicICFG observableDynamicICFG) {
        int refined = 0;
        int precomputed = 0;
        for (Statement s : Lists.newArrayList(this.queriedInvokeExpr)) {
            if (!this.queriedInvokeExprAndAllocationSitesFound.contains(s)) {
                logger.debug("Call graph ends at {}", (Object)s);
                ++precomputed;
                if (FALLBACK_OPTION == NoCalleeFoundFallbackOptions.PRECOMPUTED) {
                    for (CallGraph.Edge e : this.precomputedCallGraph.edgesOutOf(s)) {
                        observableDynamicICFG.addCallIfNotInGraph(e.src(), e.tgt());
                    }
                }
                if (FALLBACK_OPTION != NoCalleeFoundFallbackOptions.BYPASS) continue;
                observableDynamicICFG.notifyNoCalleeFound(s);
                continue;
            }
            ++refined;
        }
        logger.debug("Refined edges {}, fallback to precomputed {}", (Object)refined, (Object)precomputed);
    }

    @Override
    public Method resolveSpecialInvoke(InvokeExpr ie) {
        Collection<Method> methodFromClassOrFromSuperclass = this.getMethodFromClassOrFromSuperclass(ie.getMethod(), ie.getMethod().getDeclaringClass());
        if (methodFromClassOrFromSuperclass.size() > 1) {
            throw new RuntimeException("Illegal state, a special call should exactly resolve to one target");
        }
        return (Method)Iterables.getFirst(methodFromClassOrFromSuperclass, null);
    }

    @Override
    public Method resolveStaticInvoke(InvokeExpr ie) {
        Collection<Method> methodFromClassOrFromSuperclass = this.getMethodFromClassOrFromSuperclass(ie.getMethod(), ie.getMethod().getDeclaringClass());
        if (methodFromClassOrFromSuperclass.size() > 1) {
            throw new RuntimeException("Illegal state, a static call should exactly resolve to one target");
        }
        return (Method)Iterables.getFirst(methodFromClassOrFromSuperclass, null);
    }

    @Override
    public Collection<Method> resolveInstanceInvoke(Statement stmt) {
        return this.queryForCallees(stmt);
    }

    private Collection<Method> queryForCallees(Statement resolvingStmt) {
        logger.debug("Queried for callees of '{}'.", (Object)resolvingStmt);
        InvokeExpr invokeExpr = resolvingStmt.getInvokeExpr();
        this.queriedInvokeExpr.add(resolvingStmt);
        Val value = invokeExpr.getBase();
        ArrayList<Method> res = new ArrayList<Method>();
        for (Statement pred : resolvingStmt.getMethod().getControlFlowGraph().getPredsOf(resolvingStmt)) {
            BackwardQuery query = BackwardQuery.make(new ControlFlowGraph.Edge(pred, resolvingStmt), value);
            this.solver.solve(query, false);
            res.addAll(this.forAnyAllocationSiteOfQuery(query, resolvingStmt, pred));
        }
        return res;
    }

    private Collection<Method> forAnyAllocationSiteOfQuery(BackwardQuery query, Statement resolvingStmt, Statement callSite) {
        IterateSolvers callback = new IterateSolvers(query, callSite, resolvingStmt);
        this.solver.registerSolverCreationListener(callback);
        return callback.results;
    }

    private Collection<Method> getMethodFromClassOrFromSuperclass(DeclaredMethod method, WrappedClass sootClass) {
        HashSet res = Sets.newHashSet();
        WrappedClass originalClass = sootClass;
        while (sootClass != null) {
            for (Method candidate : sootClass.getMethods()) {
                if (!candidate.getSubSignature().equals(method.getSubSignature())) continue;
                res.add(candidate);
            }
            this.handlingForThreading(method, sootClass, res);
            if (!res.isEmpty()) {
                return res;
            }
            if (sootClass.hasSuperclass()) {
                sootClass = sootClass.getSuperclass();
                continue;
            }
            this.logDidNotFindMethod(method, originalClass);
            return res;
        }
        this.logDidNotFindMethod(method, originalClass);
        return res;
    }

    private void logDidNotFindMethod(DeclaredMethod method, WrappedClass originalClass) {
        if (didNotFindMethodLog.put((Object)method, (Object)originalClass)) {
            logger.debug("Did not find method {} for class {}", (Object)method, (Object)originalClass);
        }
    }

    private void handlingForThreading(DeclaredMethod method, WrappedClass sootClass, Set<Method> res) {
    }

    private final class IterateSolvers<W extends Weight>
    implements SolverCreationListener<W> {
        private final BackwardQuery query;
        private final Statement invokeExpr;
        private final Collection<Method> results = new ArrayList<Method>();

        private IterateSolvers(BackwardQuery query, Statement unit, Statement invokeExpr) {
            this.query = query;
            this.invokeExpr = invokeExpr;
        }

        @Override
        public void onCreatedSolver(Query q, AbstractBoomerangSolver<W> solver) {
            if (solver instanceof ForwardBoomerangSolver) {
                final ForwardQuery forwardQuery = (ForwardQuery)q;
                ForwardBoomerangSolver forwardBoomerangSolver = (ForwardBoomerangSolver)solver;
                for (INode initialState : forwardBoomerangSolver.getFieldAutomaton().getInitialStates()) {
                    forwardBoomerangSolver.getFieldAutomaton().registerListener((WPAStateListener)new ExtractAllocationSiteStateListener<W>(initialState, this.query, (ForwardQuery)q){

                        @Override
                        protected void allocationSiteFound(ForwardQuery allocationSite, BackwardQuery query) {
                            block3: {
                                Type base;
                                Type type;
                                block2: {
                                    logger.debug("Found AllocationSite '{}'.", (Object)forwardQuery);
                                    BoomerangResolver.this.queriedInvokeExprAndAllocationSitesFound.add(IterateSolvers.this.invokeExpr);
                                    type = forwardQuery.getType();
                                    if (!type.isRefType()) break block2;
                                    for (Method calleeMethod : BoomerangResolver.this.getMethodFromClassOrFromSuperclass(IterateSolvers.this.invokeExpr.getInvokeExpr().getMethod(), type.getWrappedClass())) {
                                        IterateSolvers.this.results.add(calleeMethod);
                                    }
                                    break block3;
                                }
                                if (!type.isArrayType() || !(base = type.getArrayBaseType()).isRefType()) break block3;
                                for (Method calleeMethod : BoomerangResolver.this.getMethodFromClassOrFromSuperclass(IterateSolvers.this.invokeExpr.getInvokeExpr().getMethod(), base.getWrappedClass())) {
                                    IterateSolvers.this.results.add(calleeMethod);
                                }
                            }
                        }
                    });
                }
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
            result = 31 * result + (this.invokeExpr == null ? 0 : this.invokeExpr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IterateSolvers other = (IterateSolvers)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
                return false;
            }
            return !(this.invokeExpr == null ? other.invokeExpr != null : !this.invokeExpr.equals((Object)other.invokeExpr));
        }

        private BoomerangResolver getOuterType() {
            return BoomerangResolver.this;
        }
    }

    public static enum NoCalleeFoundFallbackOptions {
        PRECOMPUTED,
        BYPASS;

    }
}

