/*
 * Decompiled with CFR 0.152.
 */
package boomerang.weights;

import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.weights.PathConditionWeight;
import boomerang.weights.PathTrackingWeight;
import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import sync.pds.solver.nodes.Node;
import wpds.impl.Weight;

public class DataFlowPathWeight
extends Weight {
    private static DataFlowPathWeight one;
    private PathTrackingWeight path;
    private PathConditionWeight condition;

    private DataFlowPathWeight() {
        this.path = PathTrackingWeight.one();
        this.condition = PathConditionWeight.one();
    }

    public DataFlowPathWeight(Node<ControlFlowGraph.Edge, Val> path) {
        this.path = new PathTrackingWeight(path);
        this.condition = PathConditionWeight.one();
    }

    public DataFlowPathWeight(Node<ControlFlowGraph.Edge, Val> path, Statement callSite, Method callee) {
        this.path = new PathTrackingWeight(path);
        this.condition = new PathConditionWeight(callSite, callee);
    }

    public DataFlowPathWeight(Statement callSite, Method callee) {
        this.path = PathTrackingWeight.one();
        this.condition = new PathConditionWeight(callSite, callee);
    }

    public DataFlowPathWeight(Statement ifStatement, Boolean condition) {
        this.path = PathTrackingWeight.one();
        this.condition = new PathConditionWeight(ifStatement, condition);
    }

    private DataFlowPathWeight(PathTrackingWeight path, PathConditionWeight condition) {
        this.path = path;
        this.condition = condition;
    }

    public DataFlowPathWeight(Val leftOp, PathConditionWeight.ConditionDomain conditionVal) {
        this.path = PathTrackingWeight.one();
        this.condition = new PathConditionWeight(leftOp, conditionVal);
    }

    public DataFlowPathWeight(Val returnVal) {
        this.path = PathTrackingWeight.one();
        this.condition = new PathConditionWeight(returnVal);
    }

    public static DataFlowPathWeight one() {
        if (one == null) {
            one = new DataFlowPathWeight();
        }
        return one;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DataFlowPathWeight that = (DataFlowPathWeight)((Object)o);
        return Objects.equal((Object)((Object)this.path), (Object)((Object)that.path)) && Objects.equal((Object)((Object)this.condition), (Object)((Object)that.condition));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path, this.condition});
    }

    public List<Node<ControlFlowGraph.Edge, Val>> getAllStatements() {
        return this.path.getShortestPathWitness();
    }

    public Map<Statement, PathConditionWeight.ConditionDomain> getConditions() {
        return this.condition.getConditions();
    }

    public Map<Val, PathConditionWeight.ConditionDomain> getEvaluationMap() {
        return this.condition.getEvaluationMap();
    }

    public String toString() {
        return " COND: " + (Object)((Object)this.condition);
    }

    public Weight extendWith(Weight other) {
        return new DataFlowPathWeight((PathTrackingWeight)this.path.extendWith(((DataFlowPathWeight)other).path), (PathConditionWeight)this.condition.extendWith(((DataFlowPathWeight)other).condition));
    }

    public Weight combineWith(Weight other) {
        return new DataFlowPathWeight((PathTrackingWeight)this.path.combineWith(((DataFlowPathWeight)other).path), (PathConditionWeight)this.condition.combineWith(((DataFlowPathWeight)other).condition));
    }
}

