/*
 * Decompiled with CFR 0.152.
 */
package boomerang.util;

import boomerang.scene.Field;
import boomerang.scene.Val;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Set;

public class AccessPath {
    private final Val val;
    private final Collection<Field> fieldChain;

    public AccessPath(Val value) {
        this.val = value;
        this.fieldChain = Lists.newArrayList();
    }

    public AccessPath(Val value, Field field) {
        this.val = value;
        this.fieldChain = Lists.newArrayList((Object[])new Field[]{field});
    }

    public AccessPath(Val value, Collection<Field> fields) {
        this.val = value;
        this.fieldChain = fields;
    }

    public String toString() {
        return this.val.toString() + "" + (this.fieldChain.isEmpty() ? "" : this.fieldChain.toString()) + (this.isOverApproximated() ? "*" : "");
    }

    public boolean isOverApproximated() {
        return this.fieldChain instanceof Set;
    }

    public Val getBase() {
        return this.val;
    }

    public Collection<Field> getFields() {
        return this.fieldChain;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fieldChain == null ? 0 : this.fieldChain.hashCode());
        result = 31 * result + (this.val == null ? 0 : this.val.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPath other = (AccessPath)obj;
        if (this.fieldChain == null ? other.fieldChain != null : !this.fieldChain.equals(other.fieldChain)) {
            return false;
        }
        return !(this.val == null ? other.val != null : !this.val.equals((Object)other.val));
    }
}

