/*
 * Decompiled with CFR 0.152.
 */
package boomerang.staticfields;

import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Field;
import boomerang.scene.Statement;
import boomerang.scene.StaticFieldVal;
import boomerang.scene.Val;
import boomerang.solver.AbstractBoomerangSolver;
import boomerang.staticfields.StaticFieldStrategy;
import com.google.common.collect.Multimap;
import java.util.Set;
import sync.pds.solver.nodes.Node;
import wpds.impl.Weight;
import wpds.interfaces.State;

public class SingletonStaticFieldStrategy<W extends Weight>
implements StaticFieldStrategy<W> {
    private Multimap<Field, Statement> fieldStoreStatements;
    private Multimap<Field, Statement> fieldLoadStatements;
    private AbstractBoomerangSolver solver;

    public SingletonStaticFieldStrategy(AbstractBoomerangSolver solver, Multimap<Field, Statement> fieldLoadStatements, Multimap<Field, Statement> fieldStoreStatements) {
        this.solver = solver;
        this.fieldStoreStatements = fieldStoreStatements;
        this.fieldLoadStatements = fieldLoadStatements;
    }

    @Override
    public void handleForward(ControlFlowGraph.Edge storeStmt, Val storedVal, StaticFieldVal staticVal, Set<State> out) {
        for (Statement matchingStore : this.fieldLoadStatements.get((Object)staticVal.field())) {
            if (!matchingStore.isAssign()) continue;
            for (Statement succ : matchingStore.getMethod().getControlFlowGraph().getSuccsOf(matchingStore)) {
                this.solver.processNormal(new Node((Object)storeStmt, (Object)storedVal), new Node((Object)new ControlFlowGraph.Edge(matchingStore, succ), (Object)matchingStore.getLeftOp()));
            }
        }
    }

    @Override
    public void handleBackward(ControlFlowGraph.Edge loadStatement, Val loadedVal, StaticFieldVal staticVal, Set<State> out) {
        for (Statement matchingStore : this.fieldStoreStatements.get((Object)staticVal.field())) {
            for (Statement pred : matchingStore.getMethod().getControlFlowGraph().getPredsOf(matchingStore)) {
                this.solver.processNormal(new Node((Object)loadStatement, (Object)loadedVal), new Node((Object)new ControlFlowGraph.Edge(pred, matchingStore), (Object)matchingStore.getRightOp()));
            }
        }
    }
}

