/*
 * Decompiled with CFR 0.152.
 */
package boomerang.solver;

import boomerang.BoomerangOptions;
import boomerang.ForwardQuery;
import boomerang.Query;
import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.controlflowgraph.ObservableControlFlowGraph;
import boomerang.controlflowgraph.PredecessorListener;
import boomerang.controlflowgraph.SuccessorListener;
import boomerang.flowfunction.IForwardFlowFunction;
import boomerang.scene.AllocVal;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.DataFlowScope;
import boomerang.scene.Field;
import boomerang.scene.InvokeExpr;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Type;
import boomerang.scene.Val;
import boomerang.solver.AbstractBoomerangSolver;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sync.pds.solver.SyncPDSSolver;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.PopNode;
import sync.pds.solver.nodes.PushNode;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.NestedWeightedPAutomatons;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.Location;
import wpds.interfaces.State;
import wpds.interfaces.WPAStateListener;

public abstract class ForwardBoomerangSolver<W extends Weight>
extends AbstractBoomerangSolver<W> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForwardBoomerangSolver.class);
    private final ForwardQuery query;
    private final IForwardFlowFunction flowFunctions;

    public ForwardBoomerangSolver(ObservableICFG<Statement, Method> callGraph, ObservableControlFlowGraph cfg, ForwardQuery query, Map<Map.Entry<INode<Node<ControlFlowGraph.Edge, Val>>, Field>, INode<Node<ControlFlowGraph.Edge, Val>>> genField, BoomerangOptions options, NestedWeightedPAutomatons<ControlFlowGraph.Edge, INode<Val>, W> callSummaries, NestedWeightedPAutomatons<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> fieldSummaries, DataFlowScope scope, IForwardFlowFunction flowFunctions, Multimap<Field, Statement> fieldLoadStatements, Multimap<Field, Statement> fieldStoreStatements, Type propagationType) {
        super(callGraph, cfg, genField, options, callSummaries, fieldSummaries, scope, propagationType);
        this.query = query;
        this.flowFunctions = flowFunctions;
        this.flowFunctions.setSolver(this, fieldLoadStatements, fieldStoreStatements);
    }

    public void processPush(Node<ControlFlowGraph.Edge, Val> curr, Location location, PushNode<ControlFlowGraph.Edge, Val, ?> succ, SyncPDSSolver.PDSSystem system) {
        if (!(SyncPDSSolver.PDSSystem.CALLS != system || ((ControlFlowGraph.Edge)succ.location()).getStart().equals((Object)((ControlFlowGraph.Edge)curr.stmt()).getTarget()) && ((ControlFlowGraph.Edge)curr.stmt()).getTarget().containsInvokeExpr())) {
            throw new RuntimeException("Invalid push rule");
        }
        super.processPush(curr, location, succ, system);
    }

    @Override
    protected void propagateUnbalancedToCallSite(final Statement callSite, Transition<ControlFlowGraph.Edge, INode<Val>> transInCallee) {
        final GeneratedState target = (GeneratedState)transInCallee.getTarget();
        if (!callSite.containsInvokeExpr()) {
            throw new RuntimeException("Invalid propagate Unbalanced return");
        }
        if (!this.isMatchingCallSiteCalleePair(callSite, ((ControlFlowGraph.Edge)transInCallee.getLabel()).getMethod())) {
            return;
        }
        this.cfg.addSuccsOfListener(new SuccessorListener(callSite){

            @Override
            public void getSuccessor(final Statement succ) {
                ForwardBoomerangSolver.this.cfg.addPredsOfListener(new PredecessorListener(callSite){

                    @Override
                    public void getPredecessor(Statement pred) {
                        Node curr = new Node((Object)new ControlFlowGraph.Edge(pred, callSite), (Object)ForwardBoomerangSolver.this.query.var());
                        Transition callTrans = new Transition((State)ForwardBoomerangSolver.this.wrap(curr.fact()), (Location)curr.stmt(), (State)ForwardBoomerangSolver.this.generateCallState(ForwardBoomerangSolver.this.wrap(curr.fact()), (Location)curr.stmt()));
                        ForwardBoomerangSolver.this.callAutomaton.addTransition(callTrans);
                        ForwardBoomerangSolver.this.callAutomaton.addUnbalancedState((State)ForwardBoomerangSolver.this.generateCallState(ForwardBoomerangSolver.this.wrap(curr.fact()), (Location)curr.stmt()), (State)target);
                        PushNode s = new PushNode(target.location(), target.node().fact(), (Object)new ControlFlowGraph.Edge(callSite, succ), SyncPDSSolver.PDSSystem.CALLS);
                        ForwardBoomerangSolver.this.propagate(curr, (State)s);
                    }
                });
            }
        });
    }

    public void applyCallSummary(ControlFlowGraph.Edge returnSiteStatement, Val factInCallee, ControlFlowGraph.Edge spInCallee, ControlFlowGraph.Edge lastCfgEdgeInCallee, Val returnedFact) {
        Statement callSite = returnSiteStatement.getStart();
        HashSet out = Sets.newHashSet();
        if (callSite.containsInvokeExpr()) {
            if (returnedFact.isThisLocal() && callSite.getInvokeExpr().isInstanceInvokeExpr()) {
                out.add(new Node((Object)returnSiteStatement, (Object)callSite.getInvokeExpr().getBase()));
            }
            if (returnedFact.isReturnLocal() && callSite.isAssign()) {
                out.add(new Node((Object)returnSiteStatement, (Object)callSite.getLeftOp()));
            }
            for (int i = 0; i < callSite.getInvokeExpr().getArgs().size(); ++i) {
                if (!returnedFact.isParameterLocal(i)) continue;
                out.add(new Node((Object)returnSiteStatement, (Object)callSite.getInvokeExpr().getArg(i)));
            }
        }
        if (returnedFact.isStatic()) {
            out.add(new Node((Object)returnSiteStatement, (Object)returnedFact.withNewMethod(returnSiteStatement.getStart().getMethod())));
        }
        for (Node xs : out) {
            this.addNormalCallFlow(new Node((Object)returnSiteStatement, (Object)returnedFact), xs);
            this.addNormalFieldFlow(new Node((Object)lastCfgEdgeInCallee, (Object)returnedFact), xs);
        }
    }

    public Collection<? extends State> computeCallFlow(Method caller, Statement callSite, ControlFlowGraph.Edge succOfCallSite, Node<ControlFlowGraph.Edge, Val> currNode, Method callee, ControlFlowGraph.Edge calleeStartEdge) {
        if (this.dataFlowScope.isExcluded(callee)) {
            this.byPassFlowAtCallSite(caller, currNode, callSite);
            return Collections.emptySet();
        }
        Val fact = (Val)currNode.fact();
        return this.flowFunctions.callFlow(callSite, fact, callee).stream().map(x -> new PushNode((Object)calleeStartEdge, x, (Object)succOfCallSite, SyncPDSSolver.PDSSystem.CALLS)).collect(Collectors.toSet());
    }

    public Query getQuery() {
        return this.query;
    }

    public void computeSuccessor(final Node<ControlFlowGraph.Edge, Val> node) {
        final ControlFlowGraph.Edge curr = (ControlFlowGraph.Edge)node.stmt();
        final Val value = (Val)node.fact();
        assert (!(value instanceof AllocVal));
        final Method method = curr.getTarget().getMethod();
        if (method == null) {
            return;
        }
        if (this.dataFlowScope.isExcluded(method)) {
            return;
        }
        if (this.icfg.isExitStmt(curr.getTarget())) {
            this.returnFlow(method, node);
            return;
        }
        this.cfg.addSuccsOfListener(new SuccessorListener(curr.getTarget()){

            @Override
            public void getSuccessor(Statement succ) {
                if (ForwardBoomerangSolver.this.query.getType().isNullType() && curr.getStart().isIfStmt() && curr.getStart().killAtIfStmt(value, succ)) {
                    return;
                }
                if (!method.getLocals().contains(value) && !value.isStatic()) {
                    return;
                }
                if (curr.getTarget().containsInvokeExpr() && (curr.getTarget().isParameter(value) || value.isStatic())) {
                    ForwardBoomerangSolver.this.callFlow(method, (Node<ControlFlowGraph.Edge, Val>)node, new ControlFlowGraph.Edge(curr.getTarget(), succ), curr.getTarget().getInvokeExpr());
                } else {
                    ForwardBoomerangSolver.this.checkForFieldOverwrite(curr, value);
                    Collection<State> out = ForwardBoomerangSolver.this.computeNormalFlow(method, new ControlFlowGraph.Edge(curr.getTarget(), succ), value);
                    for (State s : out) {
                        LOGGER.trace("{}: {} -> {}", new Object[]{s, node, ForwardBoomerangSolver.this.query});
                        ForwardBoomerangSolver.this.propagate(node, s);
                    }
                }
            }
        });
    }

    private void checkForFieldOverwrite(ControlFlowGraph.Edge curr, Val value) {
        if (curr.getTarget().isFieldStore() && ((Val)curr.getTarget().getFieldStore().getX()).equals((Object)value)) {
            Node node = new Node((Object)curr, (Object)value);
            this.fieldAutomaton.registerListener((WPAStateListener)new OverwriteAtFieldStore((INode)new SingleNode((Object)node), curr));
        } else if (curr.getTarget().isArrayStore() && ((Val)curr.getTarget().getArrayBase().getX()).equals((Object)value)) {
            Node node = new Node((Object)curr, (Object)value);
            this.fieldAutomaton.registerListener((WPAStateListener)new OverwriteAtArrayStore((INode)new SingleNode((Object)node), curr));
        }
    }

    protected abstract void overwriteFieldAtStatement(ControlFlowGraph.Edge var1, Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> var2);

    @Override
    public Collection<State> computeNormalFlow(Method method, ControlFlowGraph.Edge nextEdge, Val fact) {
        return this.flowFunctions.normalFlow(this.query, nextEdge, fact);
    }

    protected void callFlow(Method caller, Node<ControlFlowGraph.Edge, Val> currNode, ControlFlowGraph.Edge callSiteEdge, InvokeExpr invokeExpr) {
        assert (this.icfg.isCallStmt(callSiteEdge.getStart()));
        if (this.dataFlowScope.isExcluded(invokeExpr.getMethod())) {
            this.byPassFlowAtCallSite(caller, currNode, callSiteEdge.getStart());
        }
        this.icfg.addCalleeListener(new CallSiteCalleeListener(caller, callSiteEdge, currNode, invokeExpr));
    }

    private void byPassFlowAtCallSite(Method caller, final Node<ControlFlowGraph.Edge, Val> currNode, final Statement callSite) {
        LOGGER.trace("Bypassing call flow of {} at callsite: {} for {}", new Object[]{currNode.fact(), callSite, this});
        this.cfg.addSuccsOfListener(new SuccessorListener(((ControlFlowGraph.Edge)currNode.stmt()).getTarget()){

            @Override
            public void getSuccessor(Statement returnSite) {
                for (State s : ForwardBoomerangSolver.this.flowFunctions.callToReturnFlow(ForwardBoomerangSolver.this.query, new ControlFlowGraph.Edge(callSite, returnSite), (Val)currNode.fact())) {
                    ForwardBoomerangSolver.this.propagate(currNode, s);
                }
            }
        });
    }

    @Override
    public Collection<? extends State> computeReturnFlow(Method method, Statement curr, Val value) {
        return this.flowFunctions.returnFlow(method, curr, value).stream().map(x -> new PopNode(x, SyncPDSSolver.PDSSystem.CALLS)).collect(Collectors.toSet());
    }

    public String toString() {
        return "ForwardSolver: " + this.query;
    }

    private final class CallSiteCalleeListener
    implements CalleeListener<Statement, Method> {
        private final Method caller;
        private final Statement callSite;
        private final ControlFlowGraph.Edge callSiteEdge;
        private final Node<ControlFlowGraph.Edge, Val> currNode;
        private final InvokeExpr invokeExpr;

        private CallSiteCalleeListener(Method caller, ControlFlowGraph.Edge callSiteEdge, Node<ControlFlowGraph.Edge, Val> currNode, InvokeExpr invokeExpr) {
            this.caller = caller;
            this.callSiteEdge = callSiteEdge;
            this.callSite = callSiteEdge.getStart();
            this.currNode = currNode;
            this.invokeExpr = invokeExpr;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.callSiteEdge == null ? 0 : this.callSiteEdge.hashCode());
            result = 31 * result + (this.caller == null ? 0 : this.caller.hashCode());
            result = 31 * result + (this.currNode == null ? 0 : this.currNode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CallSiteCalleeListener other = (CallSiteCalleeListener)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.callSiteEdge == null ? other.callSiteEdge != null : !this.callSiteEdge.equals((Object)other.callSiteEdge)) {
                return false;
            }
            if (this.caller == null ? other.caller != null : !this.caller.equals(other.caller)) {
                return false;
            }
            return !(this.currNode == null ? other.currNode != null : !this.currNode.equals(other.currNode));
        }

        @Override
        public void onCalleeAdded(Statement callSite, Method callee) {
            if (callee.isStaticInitializer()) {
                return;
            }
            LOGGER.trace("Call-flow of {} at callsite: {} to callee method: {} for {}", new Object[]{this.currNode.fact(), callSite, callee, this});
            for (Statement calleeSp : ForwardBoomerangSolver.this.icfg.getStartPointsOf(callee)) {
                Collection<State> res = ForwardBoomerangSolver.this.computeCallFlow(this.caller, callSite, this.callSiteEdge, this.currNode, callee, new ControlFlowGraph.Edge(calleeSp, calleeSp));
                for (State s : res) {
                    ForwardBoomerangSolver.this.propagate(this.currNode, s);
                }
            }
        }

        @Override
        public void onNoCalleeFound() {
            ForwardBoomerangSolver.this.byPassFlowAtCallSite(this.caller, (Node<ControlFlowGraph.Edge, Val>)this.currNode, this.callSite);
        }

        @Override
        public Statement getObservedCaller() {
            return this.callSite;
        }

        private ForwardBoomerangSolver getOuterType() {
            return ForwardBoomerangSolver.this;
        }
    }

    private final class OverwriteAtArrayStore
    extends WPAStateListener<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> {
        private final ControlFlowGraph.Edge nextStmt;

        private OverwriteAtArrayStore(INode<Node<ControlFlowGraph.Edge, Val>> state, ControlFlowGraph.Edge nextStmt) {
            super(state);
            this.nextStmt = nextStmt;
        }

        public void onOutTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
            if (((Field)t.getLabel()).equals((Object)Field.array((int)((Integer)this.nextStmt.getTarget().getArrayBase().getY())))) {
                LOGGER.trace("Overwriting field {} at {}", (Object)t.getLabel(), (Object)this.nextStmt);
                ForwardBoomerangSolver.this.overwriteFieldAtStatement(this.nextStmt, t);
            }
        }

        public void onInTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + ((Object)((Object)this.getEnclosingInstance())).hashCode();
            result = 31 * result + (this.nextStmt == null ? 0 : this.nextStmt.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            OverwriteAtArrayStore other = (OverwriteAtArrayStore)((Object)obj);
            if (!((Object)((Object)this.getEnclosingInstance())).equals((Object)other.getEnclosingInstance())) {
                return false;
            }
            return !(this.nextStmt == null ? other.nextStmt != null : !this.nextStmt.equals((Object)other.nextStmt));
        }

        private ForwardBoomerangSolver getEnclosingInstance() {
            return ForwardBoomerangSolver.this;
        }
    }

    private final class OverwriteAtFieldStore
    extends WPAStateListener<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> {
        private final ControlFlowGraph.Edge nextStmt;

        private OverwriteAtFieldStore(INode<Node<ControlFlowGraph.Edge, Val>> state, ControlFlowGraph.Edge nextEdge) {
            super(state);
            this.nextStmt = nextEdge;
        }

        public void onOutTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
            if (((Field)t.getLabel()).equals(this.nextStmt.getTarget().getFieldStore().getY())) {
                LOGGER.trace("Overwriting field {} at {}", (Object)t.getLabel(), (Object)this.nextStmt);
                ForwardBoomerangSolver.this.overwriteFieldAtStatement(this.nextStmt, t);
            }
        }

        public void onInTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + ((Object)((Object)this.getEnclosingInstance())).hashCode();
            result = 31 * result + (this.nextStmt == null ? 0 : this.nextStmt.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            OverwriteAtFieldStore other = (OverwriteAtFieldStore)((Object)obj);
            if (!((Object)((Object)this.getEnclosingInstance())).equals((Object)other.getEnclosingInstance())) {
                return false;
            }
            return !(this.nextStmt == null ? other.nextStmt != null : !this.nextStmt.equals((Object)other.nextStmt));
        }

        private ForwardBoomerangSolver getEnclosingInstance() {
            return ForwardBoomerangSolver.this;
        }
    }
}

