/*
 * Decompiled with CFR 0.152.
 */
package boomerang.solver;

import boomerang.BackwardQuery;
import boomerang.BoomerangOptions;
import boomerang.callgraph.CalleeListener;
import boomerang.callgraph.ObservableICFG;
import boomerang.controlflowgraph.ObservableControlFlowGraph;
import boomerang.controlflowgraph.PredecessorListener;
import boomerang.controlflowgraph.SuccessorListener;
import boomerang.flowfunction.IBackwardFlowFunction;
import boomerang.scene.AllocVal;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.DataFlowScope;
import boomerang.scene.Field;
import boomerang.scene.InvokeExpr;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Type;
import boomerang.scene.Val;
import boomerang.solver.AbstractBoomerangSolver;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sync.pds.solver.SyncPDSSolver;
import sync.pds.solver.nodes.GeneratedState;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.PopNode;
import sync.pds.solver.nodes.PushNode;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.NestedWeightedPAutomatons;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.interfaces.Location;
import wpds.interfaces.State;

public abstract class BackwardBoomerangSolver<W extends Weight>
extends AbstractBoomerangSolver<W> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackwardBoomerangSolver.class);
    private final BackwardQuery query;
    private final IBackwardFlowFunction flowFunction;

    public BackwardBoomerangSolver(ObservableICFG<Statement, Method> icfg, ObservableControlFlowGraph cfg, Map<Map.Entry<INode<Node<ControlFlowGraph.Edge, Val>>, Field>, INode<Node<ControlFlowGraph.Edge, Val>>> genField, BackwardQuery query, BoomerangOptions options, NestedWeightedPAutomatons<ControlFlowGraph.Edge, INode<Val>, W> callSummaries, NestedWeightedPAutomatons<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> fieldSummaries, DataFlowScope scope, IBackwardFlowFunction backwardFlowFunction, Multimap<Field, Statement> fieldLoadStatements, Multimap<Field, Statement> fieldStoreStatements, Type propagationType) {
        super(icfg, cfg, genField, options, callSummaries, fieldSummaries, scope, propagationType);
        this.query = query;
        this.flowFunction = backwardFlowFunction;
        this.flowFunction.setSolver(this, fieldLoadStatements, fieldStoreStatements);
    }

    private boolean notUsedInMethod(Method m, Statement curr, Val value) {
        if (value.isStatic()) {
            return false;
        }
        return !m.getLocals().contains(value);
    }

    @Override
    public INode<Node<ControlFlowGraph.Edge, Val>> generateFieldState(INode<Node<ControlFlowGraph.Edge, Val>> d, Field loc) {
        AbstractMap.SimpleEntry<INode<Node<ControlFlowGraph.Edge, Val>>, Field> e = new AbstractMap.SimpleEntry<INode<Node<ControlFlowGraph.Edge, Val>>, Field>(d, loc);
        if (!this.generatedFieldState.containsKey(e)) {
            this.generatedFieldState.put(e, new GeneratedState((INode)new SingleNode((Object)new Node((Object)this.epsilonStmt(), (Object)Val.zero())), (Object)loc));
        }
        return (INode)this.generatedFieldState.get(e);
    }

    @Override
    protected Collection<? extends State> computeReturnFlow(Method method, Statement callerReturnStatement, Val value) {
        return this.flowFunction.returnFlow(method, callerReturnStatement, value).stream().map(x -> new PopNode(x, SyncPDSSolver.PDSSystem.CALLS)).collect(Collectors.toSet());
    }

    protected void callFlow(Method caller, Node<ControlFlowGraph.Edge, Val> curr, Statement callSite) {
        this.icfg.addCalleeListener(new CallSiteCalleeListener(curr, caller));
        InvokeExpr invokeExpr = callSite.getInvokeExpr();
        if (this.dataFlowScope.isExcluded(invokeExpr.getMethod())) {
            this.byPassFlowAtCallsite(caller, curr);
        }
    }

    private void byPassFlowAtCallsite(Method caller, Node<ControlFlowGraph.Edge, Val> curr) {
        for (Statement returnSite : ((ControlFlowGraph.Edge)curr.stmt()).getStart().getMethod().getControlFlowGraph().getPredsOf(((ControlFlowGraph.Edge)curr.stmt()).getStart())) {
            Set res = this.flowFunction.callToReturnFlow(new ControlFlowGraph.Edge(returnSite, ((ControlFlowGraph.Edge)curr.stmt()).getStart()), (Val)curr.fact()).stream().collect(Collectors.toSet());
            for (State s : res) {
                this.propagate(curr, s);
            }
        }
    }

    public void computeSuccessor(Node<ControlFlowGraph.Edge, Val> node) {
        LOGGER.trace("BW: Computing successor of {} for {}", node, (Object)this);
        ControlFlowGraph.Edge edge = (ControlFlowGraph.Edge)node.stmt();
        Val value = (Val)node.fact();
        assert (!(value instanceof AllocVal));
        Method method = edge.getStart().getMethod();
        if (method == null) {
            return;
        }
        if (this.dataFlowScope.isExcluded(method)) {
            return;
        }
        if (this.notUsedInMethod(method, edge.getStart(), value)) {
            return;
        }
        if (edge.getStart().containsInvokeExpr() && edge.getStart().uses(value) && this.INTERPROCEDURAL) {
            this.callFlow(method, node, edge.getStart());
        } else if (this.icfg.isExitStmt(edge.getStart())) {
            this.returnFlow(method, node);
        } else {
            this.normalFlow(method, node);
        }
    }

    protected void normalFlow(Method method, Node<ControlFlowGraph.Edge, Val> currNode) {
        ControlFlowGraph.Edge curr = (ControlFlowGraph.Edge)currNode.stmt();
        Val value = (Val)currNode.fact();
        for (Statement pred : curr.getStart().getMethod().getControlFlowGraph().getPredsOf(curr.getStart())) {
            Collection<State> flow = this.computeNormalFlow(method, new ControlFlowGraph.Edge(pred, curr.getStart()), value);
            for (State s : flow) {
                this.propagate(currNode, s);
            }
        }
    }

    protected Collection<? extends State> computeCallFlow(ControlFlowGraph.Edge callSiteEdge, Val fact, Method callee, ControlFlowGraph.Edge calleeStartEdge) {
        Statement calleeSp = calleeStartEdge.getTarget();
        return this.flowFunction.callFlow(callSiteEdge.getTarget(), fact, callee, calleeSp).stream().map(x -> new PushNode((Object)calleeStartEdge, x, (Object)callSiteEdge, SyncPDSSolver.PDSSystem.CALLS)).collect(Collectors.toSet());
    }

    public void processPush(Node<ControlFlowGraph.Edge, Val> curr, Location location, PushNode<ControlFlowGraph.Edge, Val, ?> succ, SyncPDSSolver.PDSSystem system) {
        if (!(SyncPDSSolver.PDSSystem.CALLS != system || ((ControlFlowGraph.Edge)succ.location()).getTarget().equals((Object)((ControlFlowGraph.Edge)curr.stmt()).getStart()) && ((ControlFlowGraph.Edge)curr.stmt()).getStart().containsInvokeExpr())) {
            throw new RuntimeException("Invalid push rule");
        }
        super.processPush(curr, location, succ, system);
    }

    @Override
    protected Collection<State> computeNormalFlow(Method method, ControlFlowGraph.Edge currEdge, Val fact) {
        return this.flowFunction.normalFlow(currEdge, fact).stream().collect(Collectors.toSet());
    }

    public void applyCallSummary(ControlFlowGraph.Edge callSiteEdge, Val factAtSpInCallee, ControlFlowGraph.Edge spInCallee, ControlFlowGraph.Edge exitStmt, Val exitingFact) {
        HashSet out = Sets.newHashSet();
        Statement callSite = callSiteEdge.getTarget();
        if (callSite.containsInvokeExpr()) {
            if (exitingFact.isThisLocal() && callSite.getInvokeExpr().isInstanceInvokeExpr()) {
                out.add(new Node((Object)callSiteEdge, (Object)callSite.getInvokeExpr().getBase()));
            }
            if (exitingFact.isReturnLocal() && callSite.isAssign()) {
                out.add(new Node((Object)callSiteEdge, (Object)callSite.getLeftOp()));
            }
            for (int i = 0; i < callSite.getInvokeExpr().getArgs().size(); ++i) {
                if (!exitingFact.isParameterLocal(i)) continue;
                out.add(new Node((Object)callSiteEdge, (Object)callSite.getInvokeExpr().getArg(i)));
            }
        }
        for (Node xs : out) {
            this.addNormalCallFlow(new Node((Object)callSiteEdge, (Object)exitingFact), xs);
            this.addNormalFieldFlow(new Node((Object)exitStmt, (Object)exitingFact), xs);
        }
    }

    @Override
    protected void propagateUnbalancedToCallSite(final Statement callSite, Transition<ControlFlowGraph.Edge, INode<Val>> transInCallee) {
        final GeneratedState target = (GeneratedState)transInCallee.getTarget();
        if (!callSite.containsInvokeExpr()) {
            throw new RuntimeException("Invalid propagate Unbalanced return");
        }
        if (!this.isMatchingCallSiteCalleePair(callSite, ((ControlFlowGraph.Edge)transInCallee.getLabel()).getMethod())) {
            return;
        }
        this.cfg.addSuccsOfListener(new SuccessorListener(callSite){

            @Override
            public void getSuccessor(final Statement succ) {
                BackwardBoomerangSolver.this.cfg.addPredsOfListener(new PredecessorListener(callSite){

                    @Override
                    public void getPredecessor(Statement pred) {
                        Node curr = new Node((Object)new ControlFlowGraph.Edge(callSite, succ), (Object)BackwardBoomerangSolver.this.query.var());
                        Transition callTrans = new Transition((State)BackwardBoomerangSolver.this.wrap(curr.fact()), (Location)curr.stmt(), (State)BackwardBoomerangSolver.this.generateCallState(BackwardBoomerangSolver.this.wrap(curr.fact()), (Location)curr.stmt()));
                        BackwardBoomerangSolver.this.callAutomaton.addTransition(callTrans);
                        BackwardBoomerangSolver.this.callAutomaton.addUnbalancedState((State)BackwardBoomerangSolver.this.generateCallState(BackwardBoomerangSolver.this.wrap(curr.fact()), (Location)curr.stmt()), (State)target);
                        PushNode s = new PushNode(target.location(), target.node().fact(), (Object)new ControlFlowGraph.Edge(pred, callSite), SyncPDSSolver.PDSSystem.CALLS);
                        BackwardBoomerangSolver.this.propagate(curr, (State)s);
                    }
                });
            }
        });
    }

    public String toString() {
        return "BackwardBoomerangSolver{query=" + this.query + '}';
    }

    private final class CallSiteCalleeListener
    implements CalleeListener<Statement, Method> {
        private final Statement callSite;
        private final Node<ControlFlowGraph.Edge, Val> curr;
        private final Method caller;

        private CallSiteCalleeListener(Node<ControlFlowGraph.Edge, Val> curr, Method caller) {
            this.curr = curr;
            this.callSite = ((ControlFlowGraph.Edge)curr.stmt()).getStart();
            this.caller = caller;
        }

        @Override
        public Statement getObservedCaller() {
            return this.callSite;
        }

        @Override
        public void onCalleeAdded(Statement callSite, Method callee) {
            if (callee.isStaticInitializer()) {
                return;
            }
            for (Statement calleeSp : BackwardBoomerangSolver.this.icfg.getStartPointsOf(callee)) {
                for (Statement predOfCall : callSite.getMethod().getControlFlowGraph().getPredsOf(callSite)) {
                    Collection<State> res = BackwardBoomerangSolver.this.computeCallFlow(new ControlFlowGraph.Edge(predOfCall, callSite), (Val)this.curr.fact(), callee, new ControlFlowGraph.Edge(calleeSp, calleeSp));
                    for (State o : res) {
                        BackwardBoomerangSolver.this.propagate(this.curr, o);
                    }
                }
            }
        }

        @Override
        public void onNoCalleeFound() {
            BackwardBoomerangSolver.this.byPassFlowAtCallsite(this.caller, (Node<ControlFlowGraph.Edge, Val>)this.curr);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((Object)((Object)this.getOuterType())).hashCode();
            result = 31 * result + (this.caller == null ? 0 : this.caller.hashCode());
            result = 31 * result + (this.curr == null ? 0 : this.curr.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CallSiteCalleeListener other = (CallSiteCalleeListener)obj;
            if (!((Object)((Object)this.getOuterType())).equals((Object)other.getOuterType())) {
                return false;
            }
            if (this.caller == null ? other.caller != null : !this.caller.equals(other.caller)) {
                return false;
            }
            return !(this.curr == null ? other.curr != null : !this.curr.equals(other.curr));
        }

        private BackwardBoomerangSolver getOuterType() {
            return BackwardBoomerangSolver.this;
        }
    }
}

