/*
 * Decompiled with CFR 0.152.
 */
package boomerang.scene.jimple;

import boomerang.DefaultBoomerangOptions;
import boomerang.scene.AllocVal;
import boomerang.scene.DeclaredMethod;
import boomerang.scene.Method;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import java.util.Optional;

public class IntAndStringBoomerangOptions
extends DefaultBoomerangOptions {
    @Override
    public boolean isAllocationVal(Val val) {
        if (val.isIntConstant()) {
            return true;
        }
        return super.isAllocationVal(val);
    }

    protected boolean isArrayAllocationVal(Val val) {
        return val.isArrayAllocationVal();
    }

    @Override
    public Optional<AllocVal> getAllocationVal(Method m, Statement stmt, Val fact) {
        DeclaredMethod method;
        if (!stmt.isAssign()) {
            return Optional.empty();
        }
        if (!stmt.getLeftOp().equals((Object)fact)) {
            return Optional.empty();
        }
        if (stmt.getRightOp().isLengthExpr()) {
            return Optional.of(new AllocVal(stmt.getLeftOp(), stmt, stmt.getRightOp()));
        }
        if (stmt.getRightOp().isIntConstant()) {
            return Optional.of(new AllocVal(stmt.getLeftOp(), stmt, stmt.getRightOp()));
        }
        if (stmt.containsInvokeExpr() && (method = stmt.getInvokeExpr().getMethod()).toString().equals("<java.math.BigInteger: java.math.BigInteger valueOf(long)>")) {
            Val arg = stmt.getInvokeExpr().getArg(0);
            return Optional.of(new AllocVal(stmt.getLeftOp(), stmt, arg));
        }
        return super.getAllocationVal(m, stmt, fact);
    }

    @Override
    public boolean trackStrings() {
        return true;
    }
}

