/*
 * Decompiled with CFR 0.152.
 */
package boomerang.poi;

import boomerang.BackwardQuery;
import boomerang.scene.ControlFlowGraph;
import boomerang.scene.Field;
import boomerang.scene.Statement;
import boomerang.scene.Val;
import boomerang.solver.BackwardBoomerangSolver;
import boomerang.solver.ForwardBoomerangSolver;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Set;
import sync.pds.solver.nodes.INode;
import sync.pds.solver.nodes.Node;
import sync.pds.solver.nodes.SingleNode;
import wpds.impl.Transition;
import wpds.impl.Weight;
import wpds.impl.WeightedPAutomaton;
import wpds.interfaces.Location;
import wpds.interfaces.WPAStateListener;

public class CopyAccessPathChain<W extends Weight> {
    private static final int MAX_WALK_DEPTH = -1;
    private ForwardBoomerangSolver<W> forwardSolver;
    private BackwardBoomerangSolver<W> backwardSolver;
    private ControlFlowGraph.Edge fieldWriteStatement;
    private INode<Node<ControlFlowGraph.Edge, Val>> killedTransitionTarget;
    private Set<INode<Node<ControlFlowGraph.Edge, Val>>> reachable = Sets.newHashSet();
    private Multimap<INode<Node<ControlFlowGraph.Edge, Val>>, InsertFieldTransitionCallback> delayedTransitions = HashMultimap.create();

    public CopyAccessPathChain(ForwardBoomerangSolver<W> forwardSolver, BackwardBoomerangSolver<W> backwardSolver, ControlFlowGraph.Edge fieldWriteStatement, Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> killedTransition) {
        this.forwardSolver = forwardSolver;
        this.backwardSolver = backwardSolver;
        this.fieldWriteStatement = fieldWriteStatement;
        this.killedTransitionTarget = (INode)killedTransition.getTarget();
    }

    public void exec() {
        this.forwardSolver.getFieldAutomaton().registerListener((WPAStateListener)new WalkForwardSolverListener(this.killedTransitionTarget, (INode<Node<ControlFlowGraph.Edge, Val>>)new SingleNode((Object)new Node((Object)this.fieldWriteStatement, (Object)this.fieldWriteStatement.getTarget().getRightOp())), 0));
    }

    public void addReachable(INode<Node<ControlFlowGraph.Edge, Val>> node) {
        if (this.reachable.add(node)) {
            for (InsertFieldTransitionCallback callback : Lists.newArrayList((Iterable)this.delayedTransitions.get(node))) {
                callback.trigger();
            }
        }
    }

    private void queueOrAdd(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> transToInsert) {
        if (this.reachable.contains(transToInsert.getTarget())) {
            this.backwardSolver.getFieldAutomaton().addTransition(transToInsert);
        } else {
            this.delayedTransitions.put((Object)transToInsert.getTarget(), (Object)new InsertFieldTransitionCallback(transToInsert));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.backwardSolver == null ? 0 : ((Object)this.backwardSolver).hashCode());
        result = 31 * result + (this.fieldWriteStatement == null ? 0 : this.fieldWriteStatement.hashCode());
        result = 31 * result + (this.forwardSolver == null ? 0 : ((Object)this.forwardSolver).hashCode());
        result = 31 * result + (this.killedTransitionTarget == null ? 0 : this.killedTransitionTarget.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CopyAccessPathChain other = (CopyAccessPathChain)obj;
        if (this.backwardSolver == null ? other.backwardSolver != null : !((Object)this.backwardSolver).equals(other.backwardSolver)) {
            return false;
        }
        if (this.fieldWriteStatement == null ? other.fieldWriteStatement != null : !this.fieldWriteStatement.equals((Object)other.fieldWriteStatement)) {
            return false;
        }
        if (this.forwardSolver == null ? other.forwardSolver != null : !((Object)this.forwardSolver).equals(other.forwardSolver)) {
            return false;
        }
        return !(this.killedTransitionTarget == null ? other.killedTransitionTarget != null : !this.killedTransitionTarget.equals(other.killedTransitionTarget));
    }

    private class InsertFieldTransitionCallback {
        private final Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> trans;

        public InsertFieldTransitionCallback(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> trans) {
            this.trans = trans;
        }

        public void trigger() {
            CopyAccessPathChain.this.backwardSolver.getFieldAutomaton().addTransition(this.trans);
            CopyAccessPathChain.this.addReachable((INode<Node<ControlFlowGraph.Edge, Val>>)((INode)this.trans.getStart()));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.trans == null ? 0 : this.trans.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InsertFieldTransitionCallback other = (InsertFieldTransitionCallback)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return !(this.trans == null ? other.trans != null : !this.trans.equals(other.trans));
        }

        private CopyAccessPathChain getEnclosingInstance() {
            return CopyAccessPathChain.this;
        }
    }

    private class WalkForwardSolverListener
    extends WPAStateListener<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> {
        private INode<Node<ControlFlowGraph.Edge, Val>> stateInBwSolver;
        private int walkDepth;

        public WalkForwardSolverListener(INode<Node<ControlFlowGraph.Edge, Val>> target, INode<Node<ControlFlowGraph.Edge, Val>> stateInBwSolver, int walkDepth) {
            super(target);
            this.stateInBwSolver = stateInBwSolver;
            this.walkDepth = walkDepth;
        }

        public void onOutTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
            if (((Field)t.getLabel()).equals((Object)Field.empty())) {
                if (CopyAccessPathChain.this.forwardSolver.getFieldAutomaton().isUnbalancedState(t.getTarget()) && ((INode)t.getStart()).equals(CopyAccessPathChain.this.killedTransitionTarget)) {
                    BackwardQuery query = BackwardQuery.make(CopyAccessPathChain.this.fieldWriteStatement, CopyAccessPathChain.this.fieldWriteStatement.getTarget().getRightOp());
                    INode<Node<ControlFlowGraph.Edge, Val>> fieldTarget = CopyAccessPathChain.this.backwardSolver.createQueryNodeField(query);
                    INode callTarget = CopyAccessPathChain.this.backwardSolver.generateCallState((INode)new SingleNode((Object)query.var()), (Location)query.cfgEdge());
                    CopyAccessPathChain.this.backwardSolver.solve(query.asNode(), (Location)Field.empty(), fieldTarget, (Location)query.cfgEdge(), callTarget);
                    return;
                }
                return;
            }
            INode<Node<ControlFlowGraph.Edge, Val>> targetState = CopyAccessPathChain.this.backwardSolver.generateFieldState((INode<Node<ControlFlowGraph.Edge, Val>>)new SingleNode((Object)new Node((Object)new ControlFlowGraph.Edge(Statement.epsilon(), Statement.epsilon()), (Object)Val.zero())), (Field)t.getLabel());
            Transition insert = new Transition(this.stateInBwSolver, t.getLabel(), targetState);
            CopyAccessPathChain.this.queueOrAdd((Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>>)insert);
            int newDepth = this.walkDepth + 1;
            CopyAccessPathChain.this.forwardSolver.getFieldAutomaton().registerListener((WPAStateListener)new WalkForwardSolverListener((INode<Node<ControlFlowGraph.Edge, Val>>)((INode)t.getTarget()), targetState, newDepth));
        }

        public void onInTransitionAdded(Transition<Field, INode<Node<ControlFlowGraph.Edge, Val>>> t, W w, WeightedPAutomaton<Field, INode<Node<ControlFlowGraph.Edge, Val>>, W> weightedPAutomaton) {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            WalkForwardSolverListener that = (WalkForwardSolverListener)((Object)o);
            if (!this.getEnclosingInstance().equals(that.getEnclosingInstance())) {
                return false;
            }
            return Objects.equal(this.stateInBwSolver, that.stateInBwSolver);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getEnclosingInstance().hashCode();
            result = 31 * result + (this.stateInBwSolver == null ? 0 : this.stateInBwSolver.hashCode());
            return result;
        }

        private CopyAccessPathChain getEnclosingInstance() {
            return CopyAccessPathChain.this;
        }
    }
}

